/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import java.io.IOException;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.ProgressHandler;
import org.bimserver.database.RollbackListener;
import org.bimserver.database.actions.StreamingCheckinDatabaseAction;
import org.bimserver.database.berkeley.BimserverConcurrentModificationDatabaseException;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.longaction.LongAction;
import org.bimserver.longaction.LongCheckinActionKey;
import org.bimserver.models.store.ActionState;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongStreamingCheckinAction
extends LongAction<LongCheckinActionKey> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LongStreamingCheckinAction.class);
    private StreamingCheckinDatabaseAction checkinDatabaseAction;
    private String fileName;

    public LongStreamingCheckinAction(Long topicId, BimServer bimServer, String username, String userUsername, Authorization authorization, StreamingCheckinDatabaseAction checkinDatabaseAction) {
        super(bimServer, username, userUsername, authorization);
        this.checkinDatabaseAction = checkinDatabaseAction;
        this.fileName = checkinDatabaseAction.getFileName();
        if (topicId != -1L) {
            this.setProgressTopic(bimServer.getNotificationsManager().getProgressTopic(topicId));
        } else {
            this.setProgressTopic(bimServer.getNotificationsManager().createProgressOnProjectTopic(authorization.getUoid(), checkinDatabaseAction.getPoid(), SProgressTopicType.UPLOAD, "Checkin"));
        }
        checkinDatabaseAction.addProgressListener(this);
    }

    public LongStreamingCheckinAction(BimServer bimServer, String username, String userUsername, Authorization authorization, StreamingCheckinDatabaseAction checkinDatabaseAction) {
        this(-1L, bimServer, username, userUsername, authorization, checkinDatabaseAction);
    }

    @Override
    public void execute() {
        DatabaseSession session = this.getBimServer().getDatabase().createSession();
        try {
            this.checkinDatabaseAction.setDatabaseSession(session);
            session.executeAndCommitAction(this.checkinDatabaseAction, new ProgressHandler(){
                private int count;

                @Override
                public void progress(int current, int max) {
                    if (this.count == 0) {
                        LongStreamingCheckinAction.this.updateProgress("Saving to database (" + LongStreamingCheckinAction.this.fileName + ")", current * 100 / max);
                    } else {
                        LongStreamingCheckinAction.this.updateProgress("Saving to database (" + LongStreamingCheckinAction.this.fileName + ", " + this.count + " try)", current * 100 / max);
                    }
                }

                @Override
                public void retry(int count) {
                    this.count = count;
                }
            }, new RollbackListener(){

                @Override
                public void rollback() {
                    try {
                        LongStreamingCheckinAction.this.checkinDatabaseAction.rollback();
                    }
                    catch (BimserverDatabaseException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            if (!(e instanceof UserException) && !(e instanceof BimserverConcurrentModificationDatabaseException)) {
                LOGGER.error("", (Throwable)e);
            }
            this.error(e);
        }
        finally {
            try {
                this.checkinDatabaseAction.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
            session.close();
            if (this.getActionState() != ActionState.AS_ERROR) {
                this.changeActionState(ActionState.FINISHED, "Checkin of " + this.fileName, 100);
            }
            this.done();
        }
    }

    @Override
    protected void done() {
        super.done();
        this.checkinDatabaseAction = null;
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

