/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.longaction;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bimserver.plugins.serializers.MessagingStreamingSerializer;
import org.bimserver.plugins.serializers.SerializerException;

public class MessagingSerializerInputstream
extends InputStream {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private int pos = 0;
    private byte[] buffer;
    private MessagingStreamingSerializer messagingStreamingSerializer;

    public MessagingSerializerInputstream(MessagingStreamingSerializer messagingStreamingSerializer) {
        this.messagingStreamingSerializer = messagingStreamingSerializer;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = 0;
            if (this.buffer != null && this.pos < this.buffer.length) {
                int nrToCopy = Math.min(this.buffer.length - this.pos, len);
                System.arraycopy(this.buffer, this.pos, b, off, nrToCopy);
                this.pos += nrToCopy;
                read += nrToCopy;
            }
            while (read < len) {
                this.out.reset();
                this.buffer = null;
                this.pos = 0;
                boolean write = this.messagingStreamingSerializer.writeMessage((OutputStream)this.out, null);
                if (write) {
                    this.buffer = this.out.toByteArray();
                    if (this.buffer.length <= 0) continue;
                    int nrToCopy = Math.min(this.buffer.length, len - read);
                    System.arraycopy(this.buffer, this.pos, b, off + read, nrToCopy);
                    this.pos += nrToCopy;
                    read += nrToCopy;
                    continue;
                }
                if (read != 0) {
                    return read;
                }
                return -1;
            }
            return read;
        }
        catch (SerializerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.buffer != null && this.pos < this.buffer.length) {
                return this.buffer[this.pos++];
            }
            this.buffer = null;
            while (this.buffer == null) {
                this.out.reset();
                boolean write = this.messagingStreamingSerializer.writeMessage((OutputStream)this.out, null);
                byte[] newBuffer = this.out.toByteArray();
                if (newBuffer.length > 0) {
                    this.buffer = newBuffer;
                    this.pos = 1;
                    return this.buffer[0];
                }
                if (write) continue;
                return -1;
            }
            return 0;
        }
        catch (SerializerException e) {
            throw new IOException(e);
        }
    }
}

