/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bimserver.BimServer;
import org.bimserver.client.Channel;
import org.bimserver.client.DirectChannel;
import org.bimserver.client.SimpleTokenHolder;
import org.bimserver.client.json.JsonChannel;
import org.bimserver.client.json.JsonReflectorFactory;
import org.bimserver.client.json.JsonSocketReflectorFactory;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.Service;
import org.bimserver.notifications.ChangeProgressTopicOnProjectTopic;
import org.bimserver.notifications.ChangeProgressTopicOnProjectTopicKey;
import org.bimserver.notifications.ChangeProgressTopicOnRevisionTopic;
import org.bimserver.notifications.ChangeProgressTopicOnRevisionTopicKey;
import org.bimserver.notifications.ChangeProgressTopicOnServerTopic;
import org.bimserver.notifications.LogActionNotification;
import org.bimserver.notifications.NewExtendedDataOnRevisionTopic;
import org.bimserver.notifications.NewExtendedDataOnRevisionTopicKey;
import org.bimserver.notifications.NewProgressTopicOnProjectNotification;
import org.bimserver.notifications.NewProgressTopicOnRevisionNotification;
import org.bimserver.notifications.NewProgressTopicOnServerNotification;
import org.bimserver.notifications.NewProjectTopic;
import org.bimserver.notifications.NewRevisionOnSpecificProjectTopic;
import org.bimserver.notifications.NewRevisionOnSpecificProjectTopicKey;
import org.bimserver.notifications.NewRevisionTopic;
import org.bimserver.notifications.NewUserTopic;
import org.bimserver.notifications.Notification;
import org.bimserver.notifications.NotificationsProcessor;
import org.bimserver.notifications.ProgressOnProjectTopic;
import org.bimserver.notifications.ProgressOnProjectTopicKey;
import org.bimserver.notifications.ProgressOnRevisionTopic;
import org.bimserver.notifications.ProgressOnRevisionTopicKey;
import org.bimserver.notifications.ProgressTopic;
import org.bimserver.notifications.ProgressTopicKey;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.ServiceFactory;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationsManager.class);
    private final NewRevisionTopic newRevisionTopic = new NewRevisionTopic(this);
    private final NewProjectTopic newProjectTopic = new NewProjectTopic(this);
    private final NewUserTopic newUserTopic = new NewUserTopic(this);
    private final Map<NewExtendedDataOnRevisionTopicKey, NewExtendedDataOnRevisionTopic> newExtendedDataOnRevisionTopics = new HashMap<NewExtendedDataOnRevisionTopicKey, NewExtendedDataOnRevisionTopic>();
    private final Map<NewRevisionOnSpecificProjectTopicKey, NewRevisionOnSpecificProjectTopic> newRevisionOnSpecificProjectTopics = new HashMap<NewRevisionOnSpecificProjectTopicKey, NewRevisionOnSpecificProjectTopic>();
    private final Map<ChangeProgressTopicOnProjectTopicKey, ChangeProgressTopicOnProjectTopic> changeProgressTopicOnProjectTopics = new HashMap<ChangeProgressTopicOnProjectTopicKey, ChangeProgressTopicOnProjectTopic>();
    private final Map<ChangeProgressTopicOnRevisionTopicKey, ChangeProgressTopicOnRevisionTopic> changeProgressTopicOnRevisionTopics = new HashMap<ChangeProgressTopicOnRevisionTopicKey, ChangeProgressTopicOnRevisionTopic>();
    private final ChangeProgressTopicOnServerTopic changeProgressTopicOnServerTopic = new ChangeProgressTopicOnServerTopic(this);
    private final Map<Long, ProgressTopic> progressTopicsById = new HashMap<Long, ProgressTopic>();
    private final Map<ProgressOnRevisionTopicKey, Set<ProgressOnRevisionTopic>> progressOnRevisionTopics = new HashMap<ProgressOnRevisionTopicKey, Set<ProgressOnRevisionTopic>>();
    private final Map<ProgressOnProjectTopicKey, Set<ProgressOnProjectTopic>> progressOnProjectTopics = new HashMap<ProgressOnProjectTopicKey, Set<ProgressOnProjectTopic>>();
    private final JsonSocketReflectorFactory jsonSocketReflectorFactory;
    private final BimServer bimServer;
    private String url;
    private final NotificationsProcessor notificationsProcessor;

    public NotificationsManager(BimServer bimServer, JsonSocketReflectorFactory jsonSocketReflectorFactory) {
        this.jsonSocketReflectorFactory = jsonSocketReflectorFactory;
        this.bimServer = bimServer;
        this.notificationsProcessor = new NotificationsProcessor(bimServer);
        this.notificationsProcessor.start();
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }

    public void notify(Notification notification) {
        this.addToQueue(notification);
    }

    public void notify(SLogAction logAction) {
        this.addToQueue(new LogActionNotification(this.bimServer, logAction));
    }

    public void addToQueue(Notification notification) {
        this.notificationsProcessor.queue(notification);
    }

    public void init() {
        ServerSettings serverSettings = this.bimServer.getServerSettingsCache().getServerSettings();
        this.url = serverSettings.getSiteAddress() + "/json";
    }

    public Channel getChannel(Service service) throws ChannelConnectionException {
        switch (service.getNotificationProtocol()) {
            case JSON: {
                JsonChannel jsonChannel = new JsonChannel(null, this.bimServer.getReflectorFactory(), (JsonReflectorFactory)this.jsonSocketReflectorFactory, service.getUrl() + "/json", this.bimServer.getServicesMap());
                jsonChannel.connect((TokenHolder)new SimpleTokenHolder());
                return jsonChannel;
            }
            case INTERNAL: {
                DirectChannel directChannel = new DirectChannel(null, (ServiceFactory)this.bimServer.getServiceFactory(), this.bimServer.getServicesMap());
                try {
                    directChannel.connect();
                }
                catch (UserException e) {
                    LOGGER.error("", (Throwable)e);
                }
                return directChannel;
            }
        }
        LOGGER.error("Unimplemented AccessMethod: " + service.getNotificationProtocol());
        return null;
    }

    public void shutdown() {
        this.notificationsProcessor.termintate();
    }

    public NewRevisionTopic getNewRevisionTopic() {
        return this.newRevisionTopic;
    }

    public NewProjectTopic getNewProjectTopic() {
        return this.newProjectTopic;
    }

    public NewRevisionOnSpecificProjectTopic getNewRevisionOnSpecificProjectTopic(NewRevisionOnSpecificProjectTopicKey key) {
        return this.newRevisionOnSpecificProjectTopics.get(key);
    }

    public NewExtendedDataOnRevisionTopic getOrCreateNewExtendedDataOnRevisionTopic(NewExtendedDataOnRevisionTopicKey key) {
        if (!this.newExtendedDataOnRevisionTopics.containsKey(key)) {
            this.newExtendedDataOnRevisionTopics.put(key, new NewExtendedDataOnRevisionTopic(this, key));
        }
        return this.newExtendedDataOnRevisionTopics.get(key);
    }

    public NewRevisionOnSpecificProjectTopic getOrCreateNewRevisionOnSpecificProjectTopic(NewRevisionOnSpecificProjectTopicKey key) {
        if (!this.newRevisionOnSpecificProjectTopics.containsKey(key)) {
            this.newRevisionOnSpecificProjectTopics.put(key, new NewRevisionOnSpecificProjectTopic(this, key));
        }
        return this.newRevisionOnSpecificProjectTopics.get(key);
    }

    public ProgressTopic getProgressTopic(long topicId) {
        return this.progressTopicsById.get(topicId);
    }

    public void unregister(long topicId) {
    }

    public NewUserTopic getNewUserTopic() {
        return this.newUserTopic;
    }

    public String getSiteAddress() {
        return this.url;
    }

    public synchronized ProgressTopic createProgressTopic(SProgressTopicType type, String description) {
        ProgressTopicKey key = new ProgressTopicKey();
        ProgressTopic topic = new ProgressTopic(this, key, type, description);
        this.progressTopicsById.put(key.getId(), topic);
        this.addToQueue(new NewProgressTopicOnServerNotification(this.bimServer, key.getId()));
        return topic;
    }

    public ProgressOnProjectTopic createProgressOnProjectTopic(long uoid, long poid, SProgressTopicType type, String description) {
        ProgressOnProjectTopicKey key = new ProgressOnProjectTopicKey(poid);
        Set<Object> topics = null;
        if (this.progressOnProjectTopics.containsKey(key)) {
            topics = this.progressOnProjectTopics.get(key);
        } else {
            topics = new HashSet();
            this.progressOnProjectTopics.put(key, topics);
        }
        ProgressOnProjectTopic topic = new ProgressOnProjectTopic(this, key, poid, type, description);
        this.progressTopicsById.put(key.getId(), topic);
        topics.add(topic);
        this.addToQueue(new NewProgressTopicOnProjectNotification(this.bimServer, poid, key.getId()));
        return topic;
    }

    public ProgressOnRevisionTopic createProgressOnRevisionTopic(long poid, long roid, SProgressTopicType type, String description) {
        ProgressOnRevisionTopicKey key = new ProgressOnRevisionTopicKey(poid, roid);
        Set<Object> topics = null;
        if (this.progressOnRevisionTopics.containsKey(key)) {
            topics = this.progressOnRevisionTopics.get(key);
        } else {
            topics = new HashSet();
            this.progressOnRevisionTopics.put(key, topics);
        }
        ProgressOnRevisionTopic topic = new ProgressOnRevisionTopic(this, key, poid, roid, type, description);
        this.progressTopicsById.put(key.getId(), topic);
        topics.add(topic);
        this.addToQueue(new NewProgressTopicOnRevisionNotification(this.bimServer, poid, roid, key.getId()));
        return topic;
    }

    public Set<ProgressTopic> getProgressOnProjectTopics(long poid, List<Long> roids) {
        HashSet<ProgressTopic> topics = new HashSet<ProgressTopic>();
        Set<ProgressOnProjectTopic> set = this.progressOnProjectTopics.get(new ProgressOnProjectTopicKey(poid));
        if (set != null) {
            for (ProgressOnProjectTopic progressOnProjectTopic : set) {
                topics.add(progressOnProjectTopic);
            }
        }
        for (Long roid : roids) {
            Set<ProgressOnRevisionTopic> progressOnRevisionTopics2 = this.getProgressOnRevisionTopics(poid, roid);
            if (progressOnRevisionTopics2 == null) continue;
            topics.addAll(progressOnRevisionTopics2);
        }
        return topics;
    }

    public Set<ProgressOnRevisionTopic> getProgressOnRevisionTopics(long poid, long roid) {
        return this.progressOnRevisionTopics.get(new ProgressOnRevisionTopicKey(poid, roid));
    }

    public Collection<ProgressTopic> getProgressOnServerTopics() {
        return this.progressTopicsById.values();
    }

    public ChangeProgressTopicOnProjectTopic getChangeProgressOnProjectTopic(Long poid) {
        ChangeProgressTopicOnProjectTopicKey key = new ChangeProgressTopicOnProjectTopicKey(poid);
        ChangeProgressTopicOnProjectTopic topic = this.changeProgressTopicOnProjectTopics.get(key);
        if (topic == null) {
            topic = new ChangeProgressTopicOnProjectTopic(this, key);
            this.changeProgressTopicOnProjectTopics.put(key, topic);
        }
        return topic;
    }

    public ChangeProgressTopicOnServerTopic getChangeProgressTopicOnServerTopic() {
        return this.changeProgressTopicOnServerTopic;
    }

    public ChangeProgressTopicOnRevisionTopic getChangeProgressOnRevisionTopic(Long poid, Long roid) {
        ChangeProgressTopicOnRevisionTopicKey key = new ChangeProgressTopicOnRevisionTopicKey(poid, roid);
        ChangeProgressTopicOnRevisionTopic topic = this.changeProgressTopicOnRevisionTopics.get(key);
        if (topic == null) {
            topic = new ChangeProgressTopicOnRevisionTopic(this, key);
            this.changeProgressTopicOnRevisionTopics.put(key, topic);
        }
        return topic;
    }

    public NewExtendedDataOnRevisionTopic getNewExtendedDataOnRevisionTopic(NewExtendedDataOnRevisionTopicKey key) {
        return this.newExtendedDataOnRevisionTopics.get(key);
    }

    public void removeChangeProgressTopicOnProject(ChangeProgressTopicOnProjectTopicKey key) {
        this.changeProgressTopicOnProjectTopics.remove(key);
    }

    public void removeChangeProgressTopicOnRevision(ChangeProgressTopicOnRevisionTopicKey key) {
        this.changeProgressTopicOnRevisionTopics.remove(key);
    }

    public void removeNewExtendedDataOnRevisionTopic(NewExtendedDataOnRevisionTopicKey key) {
        this.newExtendedDataOnRevisionTopics.remove(key);
    }

    public void removeNewRevisionOnSpecificProjectTopic(NewRevisionOnSpecificProjectTopicKey key) {
        this.newRevisionOnSpecificProjectTopics.remove(key);
    }

    public void removeProgressTopic(ProgressTopicKey key) {
        if (key instanceof ProgressOnProjectTopicKey) {
            this.progressOnProjectTopics.remove((ProgressOnProjectTopicKey)key);
        } else if (key instanceof ProgressOnRevisionTopicKey) {
            this.progressOnRevisionTopics.remove((ProgressOnRevisionTopicKey)key);
        }
        this.progressTopicsById.remove(key.getId());
    }
}

