/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import java.util.concurrent.LinkedBlockingQueue;
import org.bimserver.BimServer;
import org.bimserver.notifications.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationsProcessor
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationsProcessor.class);
    private final LinkedBlockingQueue<Notification> queue = new LinkedBlockingQueue(1000000);
    private volatile boolean running = true;

    public NotificationsProcessor(BimServer bimServer) {
        this.setName("Notifications processor");
    }

    @Override
    public void run() {
        block3: {
            try {
                while (this.running) {
                    this.queue.take().run();
                }
            }
            catch (InterruptedException e) {
                if (!this.running) break block3;
                LOGGER.error("Unexpected interruption");
            }
        }
    }

    public void termintate() {
        this.running = false;
        this.interrupt();
    }

    public void queue(Notification notification) {
        if (!this.queue.offer(notification)) {
            LOGGER.error("Notification queue is full!");
        }
    }
}

