/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import org.bimserver.BimserverDatabaseException;
import org.bimserver.endpoints.EndPoint;
import org.bimserver.interfaces.SConverter;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.models.store.ActionState;
import org.bimserver.models.store.LongActionState;
import org.bimserver.notifications.NotificationsManager;
import org.bimserver.notifications.ProgressNotification;
import org.bimserver.notifications.ProgressTopicKey;
import org.bimserver.notifications.Topic;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressTopic
extends Topic {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressTopic.class);
    private static final long RATE_LIMIT_NANO_SECONDS = 200000000L;
    private SProgressTopicType type;
    private String description;
    private ProgressTopicKey key;
    private volatile LongActionState lastProgress;
    private long lastSent = -1L;

    public ProgressTopic(NotificationsManager notificationsManager, ProgressTopicKey key, SProgressTopicType type, String description) {
        super(notificationsManager);
        this.key = key;
        this.type = type;
        this.description = description;
    }

    public ProgressTopicKey getKey() {
        return this.key;
    }

    protected synchronized void updateProgress(final LongActionState state) {
        block4: {
            try {
                boolean sendMessage = this.lastSent == -1L || System.nanoTime() - this.lastSent > 200000000L && state.getProgress().intValue() != this.lastProgress.getProgress().intValue();
                sendMessage |= state.getProgress() == 100;
                sendMessage |= state.getState() == ActionState.FINISHED;
                sendMessage |= state.getState() == ActionState.AS_ERROR;
                sendMessage |= this.lastProgress != null && this.lastProgress.getStage() != state.getStage();
                if (!(sendMessage |= this.lastProgress != null && (this.lastProgress.getTitle() == null && state.getTitle() != null || !this.lastProgress.getTitle().equals(state.getTitle())))) break block4;
                try {
                    this.map(new Topic.Mapper(){

                        @Override
                        public void map(EndPoint endPoint) throws UserException, ServerException, BimserverDatabaseException {
                            try {
                                endPoint.getNotificationInterface().progress(Long.valueOf(ProgressTopic.this.key.getId()), new SConverter().convertToSObject(state));
                            }
                            catch (Exception e) {
                                LOGGER.error("", (Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                }
                this.lastProgress = state;
                this.lastSent = System.nanoTime();
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public LongActionState getLastProgress() {
        return this.lastProgress;
    }

    public SProgressTopicType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public void close() {
    }

    @Override
    public void remove() {
        this.getNotificationsManager().removeProgressTopic(this.key);
    }

    public void stageProgressUpdate(LongActionState longActionState) {
        this.getNotificationsManager().notify(new ProgressNotification(this.getNotificationsManager().getBimServer(), this, longActionState));
    }
}

