/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.notifications;

import java.util.HashSet;
import java.util.Set;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.endpoints.EndPoint;
import org.bimserver.notifications.NotificationsManager;
import org.bimserver.notifications.TopicRegisterException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;

public abstract class Topic {
    private final Set<EndPoint> endPoints = new HashSet<EndPoint>();
    private final NotificationsManager notificationsManager;

    public Topic(NotificationsManager notificationsManager) {
        this.notificationsManager = notificationsManager;
    }

    public synchronized void map(Mapper mapper) throws UserException, ServerException, BimserverDatabaseException {
        for (EndPoint endPoint : this.endPoints) {
            mapper.map(endPoint);
        }
    }

    public synchronized void register(EndPoint endPoint) throws TopicRegisterException {
        this.endPoints.add(endPoint);
    }

    public synchronized void unregister(EndPoint endPoint) throws TopicRegisterException {
        this.endPoints.remove(endPoint);
    }

    public NotificationsManager getNotificationsManager() {
        return this.notificationsManager;
    }

    public Set<EndPoint> getEndPoints() {
        return this.endPoints;
    }

    public abstract void remove();

    public static interface Mapper {
        public void map(EndPoint var1) throws UserException, ServerException, BimserverDatabaseException;
    }
}

