/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.pb.server;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.pb.server.ProtocolBuffersServer;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SService;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.shared.pb.ReflectiveRpcChannel;
import org.bimserver.webservices.PublicInterfaceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolBuffersConnectionHandler
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolBuffersConnectionHandler.class);
    private OutputStream outputStream;
    private DataInputStream dataInputStream;
    private final ProtocolBuffersServer protocolBuffersServer;
    private final SServicesMap servicesMap;
    private PublicInterfaceFactory serviceFactory;
    private volatile boolean running;
    private Socket socket;

    public ProtocolBuffersConnectionHandler(Socket socket, ProtocolBuffersServer protocolBuffersServer, PublicInterfaceFactory serviceFactory, SServicesMap servicesMap) {
        this.socket = socket;
        this.protocolBuffersServer = protocolBuffersServer;
        this.serviceFactory = serviceFactory;
        this.servicesMap = servicesMap;
        this.setName("ProtocolBuffersConnectionHandler");
        try {
            this.dataInputStream = new DataInputStream(socket.getInputStream());
            this.outputStream = socket.getOutputStream();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public void run() {
        block7: {
            try {
                this.running = true;
                while (this.running) {
                    String serviceName = this.dataInputStream.readUTF();
                    String methodName = this.dataInputStream.readUTF();
                    String token = this.dataInputStream.readUTF();
                    ProtocolBuffersMetaData protocolBuffersMetaData = this.protocolBuffersServer.getProtocolBuffersMetaData();
                    SService sService = this.servicesMap.getBySimpleName(serviceName);
                    if (sService == null) {
                        throw new UserException("No service found with name " + serviceName);
                    }
                    SMethod method = sService.getSMethod(methodName);
                    if (method == null) {
                        throw new UserException("Method " + methodName + " not found on " + serviceName);
                    }
                    Class clazz = sService.getInterfaceClass();
                    PublicInterface service = null;
                    service = token.equals("") ? (PublicInterface)this.serviceFactory.get(AccessMethod.PROTOCOL_BUFFERS).get(clazz) : (PublicInterface)this.serviceFactory.get(token, AccessMethod.PROTOCOL_BUFFERS).get(clazz);
                    ReflectiveRpcChannel reflectiveRpcChannel = new ReflectiveRpcChannel(clazz, service, protocolBuffersMetaData, this.servicesMap);
                    ProtocolBuffersMetaData.MethodDescriptorContainer pbMethod = protocolBuffersMetaData.getMethod(serviceName, methodName);
                    DynamicMessage.Builder requestBuilder = DynamicMessage.getDefaultInstance((Descriptors.Descriptor)pbMethod.getInputDescriptor()).newBuilderForType();
                    requestBuilder.mergeDelimitedFrom((InputStream)this.dataInputStream);
                    Message response = reflectiveRpcChannel.callBlockingMethod(pbMethod, (Message)requestBuilder.build());
                    response.writeDelimitedTo(this.outputStream);
                    this.outputStream.flush();
                }
            }
            catch (SocketException serviceName) {
            }
            catch (EOFException serviceName) {
            }
            catch (Exception e) {
                if (!this.running) break block7;
                LOGGER.error("", (Throwable)e);
            }
        }
        this.protocolBuffersServer.unregister(this);
    }

    public void close() {
        this.running = false;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        this.interrupt();
    }
}

