/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.pb.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import org.bimserver.pb.server.ProtocolBuffersConnectionHandler;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.shared.pb.ReflectiveRpcChannel;
import org.bimserver.webservices.PublicInterfaceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolBuffersServer
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolBuffersServer.class);
    private volatile boolean running;
    private final Set<ProtocolBuffersConnectionHandler> activeHandlers = new HashSet<ProtocolBuffersConnectionHandler>();
    private final ProtocolBuffersMetaData protocolBuffersMetaData;
    private final int port;
    private ServerSocket serverSocket;
    private final SServicesMap servicesMap;
    private final PublicInterfaceFactory publicInterfaceFactory;

    public ProtocolBuffersServer(ProtocolBuffersMetaData protocolBuffersMetaData, PublicInterfaceFactory publicInterfaceFactory, SServicesMap servicesMap, int port) {
        this.publicInterfaceFactory = publicInterfaceFactory;
        this.setName("ProtocolBuffersServer");
        this.servicesMap = servicesMap;
        this.protocolBuffersMetaData = protocolBuffersMetaData;
        this.port = port;
    }

    @Override
    public void run() {
        block3: {
            this.running = true;
            try {
                this.serverSocket = new ServerSocket(this.port);
                while (this.running) {
                    Socket socket = this.serverSocket.accept();
                    ProtocolBuffersConnectionHandler protocolBuffersConnectionHandler = new ProtocolBuffersConnectionHandler(socket, this, this.publicInterfaceFactory, this.servicesMap);
                    this.activeHandlers.add(protocolBuffersConnectionHandler);
                    protocolBuffersConnectionHandler.start();
                }
            }
            catch (IOException e) {
                if (!this.running) break block3;
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public ProtocolBuffersMetaData getProtocolBuffersMetaData() {
        return this.protocolBuffersMetaData;
    }

    public void registerService(ReflectiveRpcChannel reflectiveRpcChannel) {
    }

    public void shutdown() {
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        for (ProtocolBuffersConnectionHandler protocolBuffersConnectionHandler : this.activeHandlers) {
            protocolBuffersConnectionHandler.close();
        }
        this.interrupt();
    }

    public void unregister(ProtocolBuffersConnectionHandler protocolBuffersConnectionHandler) {
        this.activeHandlers.remove(protocolBuffersConnectionHandler);
    }
}

