/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.renderengine;

import java.util.HashMap;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.emf.Schema;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.renderengine.RenderEngineFactory;
import org.bimserver.renderengine.RenderEnginePool;
import org.bimserver.renderengine.RenderEnginePoolFactory;
import org.bimserver.shared.exceptions.PluginException;

public class RenderEnginePools {
    private BimServer bimServer;
    private final Map<Schema, Map<String, RenderEnginePool>> pools = new HashMap<Schema, Map<String, RenderEnginePool>>();
    private RenderEnginePoolFactory renderEnginePoolFactory;

    public RenderEnginePools(BimServer bimServer, RenderEnginePoolFactory renderEnginePoolFactory) throws RenderEngineException {
        this.bimServer = bimServer;
        this.renderEnginePoolFactory = renderEnginePoolFactory;
        for (Schema schema : Schema.getIfcSchemas()) {
            HashMap map = new HashMap();
            this.pools.put(schema, map);
        }
    }

    public RenderEnginePool getRenderEnginePool(final Schema schema, String className, final PluginConfiguration pluginConfiguration) throws PluginException {
        if (this.pools.containsKey(schema)) {
            Map<String, RenderEnginePool> map = this.pools.get(schema);
            if (map.containsKey(className)) {
                return map.get(className);
            }
            final RenderEnginePlugin renderEnginePlugin = this.bimServer.getPluginManager().getRenderEnginePlugin(className, true);
            if (renderEnginePlugin == null) {
                throw new PluginException("No render engine found for className " + className);
            }
            RenderEnginePool renderEnginePool = this.renderEnginePoolFactory.newRenderEnginePool(new RenderEngineFactory(){

                @Override
                public RenderEngine createRenderEngine() throws RenderEngineException {
                    return renderEnginePlugin.createRenderEngine(pluginConfiguration, schema.name());
                }
            });
            map.put(className, renderEnginePool);
            return renderEnginePool;
        }
        throw new PluginException("No render engine found for schema " + schema);
    }
}

