/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.renderengine.pooled;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.renderengine.RenderEngineFactory;
import org.bimserver.renderengine.RenderEnginePool;

public class CommonsRenderEnginePool
implements RenderEnginePool {
    private GenericObjectPool<RenderEngine> genericObjectPool;

    public CommonsRenderEnginePool(int poolSize, final RenderEngineFactory renderEngineFactory) throws RenderEngineException {
        PooledObjectFactory<RenderEngine> pooledObjectFactory = new PooledObjectFactory<RenderEngine>(){

            public void activateObject(PooledObject<RenderEngine> arg0) throws Exception {
                ((RenderEngine)arg0.getObject()).init();
            }

            public void destroyObject(PooledObject<RenderEngine> arg0) throws Exception {
                ((RenderEngine)arg0.getObject()).close();
            }

            public PooledObject<RenderEngine> makeObject() throws Exception {
                return new DefaultPooledObject((Object)renderEngineFactory.createRenderEngine());
            }

            public void passivateObject(PooledObject<RenderEngine> arg0) throws Exception {
            }

            public boolean validateObject(PooledObject<RenderEngine> arg0) {
                return false;
            }
        };
        this.genericObjectPool = new GenericObjectPool((PooledObjectFactory)pooledObjectFactory);
        this.genericObjectPool.setMaxWaitMillis(60000L);
        this.genericObjectPool.setMaxTotal(8);
    }

    @Override
    public RenderEngine borrowObject() throws RenderEngineException {
        try {
            return (RenderEngine)this.genericObjectPool.borrowObject();
        }
        catch (Exception e) {
            throw new RenderEngineException(e);
        }
    }

    @Override
    public void returnObject(RenderEngine renderEngine) throws RenderEngineException {
        this.genericObjectPool.returnObject((Object)renderEngine);
    }
}

