/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.objectinfo;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.bimserver.plugins.serializers.EmfSerializer;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.SerializerException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ObjectInfoSerializer
extends EmfSerializer {
    public boolean write(OutputStream outputStream, ProgressReporter progressReporter) throws SerializerException {
        if (this.getMode() == EmfSerializer.Mode.BODY) {
            PrintWriter out = new PrintWriter(outputStream);
            for (EObject eObject : this.model.getObjects().values()) {
                if (eObject.eClass().getEAnnotation("hidden") != null) continue;
                this.writeTable(out, eObject);
            }
            out.flush();
            this.setMode(EmfSerializer.Mode.FINISHED);
            return true;
        }
        if (this.getMode() == EmfSerializer.Mode.FINISHED) {
            return false;
        }
        return false;
    }

    private void writeTable(PrintWriter out, EObject eObject) {
        out.println("<h1>" + eObject.eClass().getName() + "</h1>");
        out.println("<table>");
        for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
            if (eStructuralFeature.getEAnnotation("hidden") == null) {
                List list;
                out.println("<tr>");
                out.println("<td>" + eStructuralFeature.getName() + "</td>");
                Object eGet = eObject.eGet(eStructuralFeature);
                if (eStructuralFeature instanceof EAttribute) {
                    if (eStructuralFeature.getUpperBound() == 1) {
                        out.println("<td>" + eGet + "</td>");
                    } else {
                        list = (List)eGet;
                        out.println("<td>");
                        for (Object object : list) {
                            out.println(object + " ");
                        }
                        out.println("</td>");
                    }
                } else if (eStructuralFeature instanceof EReference) {
                    if (eStructuralFeature.getUpperBound() == 1) {
                        EObject value;
                        if (eStructuralFeature.getEType().getEAnnotation("wrapped") != null && (value = (EObject)eGet) != null) {
                            out.println("<td>" + value.eGet(value.eClass().getEStructuralFeature("wrappedValue")) + "</td>");
                        }
                    } else if (eStructuralFeature.getEType().getEAnnotation("wrapped") != null) {
                        list = (List)eGet;
                        out.println("<td>");
                        for (Object object : list) {
                            out.println("<td>" + object.eGet(object.eClass().getEStructuralFeature("wrappedValue")) + "</td>");
                        }
                        out.println("</td>");
                    }
                }
            }
            out.println("</tr>");
        }
        out.println("</table>");
    }
}

