/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.bimserver.BimServer;
import org.bimserver.interfaces.objects.SDeserializerPluginConfiguration;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.servlets.SubServlet;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.utils.InputStreamDataSource;
import org.opensourcebim.bcf.utils.FakeClosingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkUploadServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkUploadServlet.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public BulkUploadServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectNode result;
        block17: {
            if (request.getHeader("Origin") != null && !this.getBimServer().getServerSettingsCache().isHostAllowed(request.getHeader("Origin"))) {
                response.setStatus(403);
                return;
            }
            response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
            response.setHeader("Access-Control-Allow-Headers", "Content-Type");
            String token = (String)request.getSession().getAttribute("token");
            result = OBJECT_MAPPER.createObjectNode();
            response.setContentType("text/json");
            try {
                boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
                long poid = -1L;
                String comment = null;
                if (!isMultipart) break block17;
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = upload.getItemIterator(request);
                InputStream in = null;
                String name = "";
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    if (item.isFormField()) {
                        if ("token".equals(item.getFieldName())) {
                            token = Streams.asString((InputStream)item.openStream());
                            continue;
                        }
                        if ("poid".equals(item.getFieldName())) {
                            poid = Long.parseLong(Streams.asString((InputStream)item.openStream()));
                            continue;
                        }
                        if (!"comment".equals(item.getFieldName())) continue;
                        comment = Streams.asString((InputStream)item.openStream());
                        continue;
                    }
                    name = item.getName();
                    in = item.openStream();
                    if (poid != -1L) {
                        ServiceInterface service = this.getBimServer().getServiceFactory().get(token, AccessMethod.INTERNAL).get(ServiceInterface.class);
                        SProject mainProject = service.getProjectByPoid(Long.valueOf(poid));
                        ZipInputStream zipInputStream = new ZipInputStream(in);
                        ZipEntry nextEntry = zipInputStream.getNextEntry();
                        while (nextEntry != null) {
                            String fullfilename = nextEntry.getName();
                            if (fullfilename.toLowerCase().endsWith(".ifc") || fullfilename.toLowerCase().endsWith("ifcxml") || fullfilename.toLowerCase().endsWith(".ifczip")) {
                                InputStreamDataSource inputStreamDataSource = new InputStreamDataSource((InputStream)new FakeClosingInputStream((InputStream)zipInputStream));
                                inputStreamDataSource.setName(name);
                                DataHandler ifcFile = new DataHandler((DataSource)inputStreamDataSource);
                                if (fullfilename.contains("/")) {
                                    String path = fullfilename.substring(0, fullfilename.lastIndexOf("/"));
                                    String filename = fullfilename.substring(fullfilename.lastIndexOf("/") + 1);
                                    String extension = filename.substring(filename.lastIndexOf(".") + 1);
                                    SProject project = this.getOrCreatePath(service, mainProject, mainProject, path);
                                    SDeserializerPluginConfiguration deserializer = service.getSuggestedDeserializerForExtension(extension, Long.valueOf(project.getOid()));
                                    long topicId = -1L;
                                    try {
                                        topicId = service.checkin(Long.valueOf(project.getOid()), comment, Long.valueOf(deserializer.getOid()), Long.valueOf(-1L), filename, ifcFile, Boolean.valueOf(false), Boolean.valueOf(true));
                                    }
                                    finally {
                                        if (topicId != -1L) {
                                            service.cleanupLongAction(Long.valueOf(topicId));
                                        }
                                    }
                                }
                            } else if (!nextEntry.isDirectory()) {
                                LOGGER.info("Unknown fileextenstion " + fullfilename);
                            }
                            nextEntry = zipInputStream.getNextEntry();
                        }
                        continue;
                    }
                    result.put("exception", "No poid");
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                return;
            }
        }
        response.getWriter().write(result.toString());
    }

    private SProject getOrCreatePath(ServiceInterface service, SProject mainProject, SProject currentProject, String path) throws UserException, ServerException {
        String name = path;
        if (path.contains("/")) {
            name = path.substring(0, path.indexOf("/"));
        }
        SProject newProject = null;
        try {
            newProject = service.addProjectAsSubProject(name, Long.valueOf(currentProject.getOid()), currentProject.getSchema());
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (UserException e) {
            newProject = service.getSubProjectByName(Long.valueOf(currentProject.getOid()), name);
        }
        if (path.contains("/")) {
            return this.getOrCreatePath(service, mainProject, newProject, path.substring(path.indexOf("/") + 1));
        }
        return newProject;
    }
}

