/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataSource;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.bimserver.BimServer;
import org.bimserver.interfaces.objects.SDownloadResult;
import org.bimserver.interfaces.objects.SExtendedData;
import org.bimserver.interfaces.objects.SFile;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ActionState;
import org.bimserver.models.store.LongActionState;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.notifications.ProgressTopic;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.serializers.ExtendedDataSource;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.servlets.SubServlet;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.BcfCache;
import org.opensourcebim.bcf.BcfException;
import org.opensourcebim.bcf.BcfFile;
import org.opensourcebim.bcf.ReadOptions;
import org.opensourcebim.bcf.TopicFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadServlet.class);

    public DownloadServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String token;
            boolean zip;
            String acceptEncoding = request.getHeader("Accept-Encoding");
            boolean useGzip = false;
            if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
                useGzip = true;
            }
            Object outputStream = response.getOutputStream();
            boolean bl = zip = request.getParameter("zip") != null && request.getParameter("zip").equals("on");
            if (useGzip && !zip) {
                response.setHeader("Content-Encoding", "gzip");
                outputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
            }
            if ((token = (String)request.getSession().getAttribute("token")) == null) {
                token = request.getParameter("token");
            }
            long topicId = -1L;
            if (request.getParameter("topicId") != null) {
                topicId = Long.parseLong(request.getParameter("topicId"));
            }
            ServiceMap serviceMap = this.getBimServer().getServiceFactory().get(token, AccessMethod.INTERNAL);
            String action = request.getParameter("action");
            if (action != null) {
                if (action.equals("extendeddata")) {
                    SExtendedData sExtendedData = serviceMap.getServiceInterface().getExtendedData(Long.valueOf(Long.parseLong(request.getParameter("edid"))));
                    SFile file = serviceMap.getServiceInterface().getFile(Long.valueOf(sExtendedData.getFileId()));
                    if (file.getMime() != null) {
                        response.setContentType(file.getMime());
                    }
                    if (file.getFilename() != null) {
                        response.setHeader("Content-Disposition", "inline; filename=\"" + file.getFilename() + "\"");
                    }
                    ((OutputStream)outputStream).write(file.getData());
                    if (outputStream instanceof GZIPOutputStream) {
                        ((GZIPOutputStream)outputStream).finish();
                    }
                    ((OutputStream)outputStream).flush();
                    return;
                }
                if (action.equals("getfile")) {
                    String type = request.getParameter("type");
                    if (type.equals("proto")) {
                        try {
                            String protocolBuffersFile = serviceMap.getAdminInterface().getProtocolBuffersFile(request.getParameter("name"));
                            ((OutputStream)outputStream).write(protocolBuffersFile.getBytes(Charsets.UTF_8));
                            ((OutputStream)outputStream).flush();
                        }
                        catch (ServiceException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    } else if (type.equals("serverlog")) {
                        try {
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream);
                            writer.write(serviceMap.getAdminInterface().getServerLog());
                            writer.flush();
                        }
                        catch (ServerException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                        catch (UserException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    }
                } else if (action.equals("getBcfImage")) {
                    byte[] data;
                    TopicFolder topicFolder;
                    long extendedDataId = Long.parseLong(request.getParameter("extendedDataId"));
                    String topicGuid = request.getParameter("topicGuid");
                    String name = request.getParameter("name");
                    BcfFile bcfFile = BcfCache.INSTANCE.get(extendedDataId);
                    if (bcfFile == null) {
                        SExtendedData extendedData = serviceMap.getServiceInterface().getExtendedData(Long.valueOf(extendedDataId));
                        long fileId = extendedData.getFileId();
                        SFile file = serviceMap.getServiceInterface().getFile(Long.valueOf(fileId));
                        try {
                            bcfFile = BcfFile.read((InputStream)new ByteArrayInputStream(file.getData()), (ReadOptions)new ReadOptions(false));
                            BcfCache.INSTANCE.put(extendedDataId, bcfFile);
                        }
                        catch (BcfException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((topicFolder = bcfFile.getTopicFolder(topicGuid)) != null && (data = topicFolder.getSnapshot(topicGuid + "/" + name)) != null) {
                        response.setContentType("image/png");
                        IOUtils.write((byte[])data, (OutputStream)outputStream);
                        if (outputStream instanceof GZIPOutputStream) {
                            ((GZIPOutputStream)outputStream).finish();
                        }
                        ((OutputStream)outputStream).flush();
                        return;
                    }
                }
            } else {
                if (request.getParameter("topicId") != null) {
                    topicId = Long.parseLong(request.getParameter("topicId"));
                }
                if (topicId == -1L) {
                    response.getWriter().println("No valid topicId");
                    return;
                }
                SDownloadResult checkoutResult = serviceMap.getServiceInterface().getDownloadData(Long.valueOf(topicId));
                if (checkoutResult == null) {
                    LOGGER.error("Invalid topicId: " + topicId);
                } else {
                    DataSource dataSource = checkoutResult.getFile().getDataSource();
                    PluginConfiguration pluginConfiguration = new PluginConfiguration(serviceMap.getPluginInterface().getPluginSettings(Long.valueOf(checkoutResult.getSerializerOid())));
                    final ProgressTopic progressTopic = this.getBimServer().getNotificationsManager().getProgressTopic(topicId);
                    ProgressReporter progressReporter = new ProgressReporter(){
                        private long lastMax;
                        private long lastProgress;
                        private int stage = 3;
                        private Date start = new Date();
                        private String title = "Downloading...";

                        public void update(long progress, long max) {
                            if (progressTopic != null) {
                                LongActionState ds = StoreFactory.eINSTANCE.createLongActionState();
                                ds.setStart(this.start);
                                ds.setState(progress == max ? ActionState.FINISHED : ActionState.STARTED);
                                ds.setTitle(this.title);
                                ds.setStage(this.stage);
                                ds.setProgress(Integer.valueOf((int)Math.round(100.0 * (double)progress / (double)max)));
                                progressTopic.stageProgressUpdate(ds);
                                this.lastMax = max;
                                this.lastProgress = progress;
                            }
                        }

                        public void setTitle(String title) {
                            if (progressTopic != null) {
                                ++this.stage;
                                this.title = title;
                                LongActionState ds = StoreFactory.eINSTANCE.createLongActionState();
                                ds.setStart(new Date());
                                ds.setState(this.lastProgress == this.lastMax ? ActionState.FINISHED : ActionState.STARTED);
                                ds.setTitle(title);
                                ds.setStage(this.stage);
                                ds.setProgress(Integer.valueOf((int)Math.round(100.0 * (double)this.lastProgress / (double)this.lastMax)));
                                progressTopic.stageProgressUpdate(ds);
                            }
                        }
                    };
                    try {
                        if (zip) {
                            if (pluginConfiguration.getString("ZipExtension") != null) {
                                response.setHeader("Content-Disposition", "inline; filename=\"" + dataSource.getName() + "." + pluginConfiguration.getString("ZipExtension") + "\"");
                            } else {
                                response.setHeader("Content-Disposition", "inline; filename=\"" + dataSource.getName() + ".zip\"");
                            }
                            response.setContentType("application/zip");
                            String nameInZip = dataSource.getName() + "." + pluginConfiguration.getString("Extension");
                            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)outputStream);
                            zipOutputStream.putNextEntry(new ZipEntry(nameInZip));
                            this.processDataSource(zipOutputStream, dataSource, progressReporter);
                            try {
                                zipOutputStream.finish();
                            }
                            catch (IOException iOException) {}
                        } else {
                            if (request.getParameter("mime") == null) {
                                response.setContentType(pluginConfiguration.getString("ContentType"));
                                response.setHeader("Content-Disposition", "inline; filename=\"" + dataSource.getName() + "." + pluginConfiguration.getString("Extension") + "\"");
                            } else {
                                response.setContentType(request.getParameter("mime"));
                            }
                            this.processDataSource((OutputStream)outputStream, dataSource, progressReporter);
                        }
                    }
                    catch (SerializerException s) {
                        if (s.getCause() == null || !(s.getCause() instanceof IOException)) {
                            LOGGER.error("", (Throwable)s);
                        }
                        LongActionState ds = StoreFactory.eINSTANCE.createLongActionState();
                        ds.setStart(new Date());
                        ds.setState(ActionState.AS_ERROR);
                        ds.setTitle("Serialization Error");
                        ds.setProgress(Integer.valueOf(-1));
                        ds.setStage(3);
                        ds.getErrors().add((Object)s.getMessage());
                        progressTopic.stageProgressUpdate(ds);
                    }
                }
            }
            if (outputStream instanceof GZIPOutputStream) {
                ((GZIPOutputStream)outputStream).finish();
            }
            ((OutputStream)outputStream).flush();
        }
        catch (NumberFormatException e) {
            LOGGER.error("", (Throwable)e);
            response.getWriter().println("Some number was incorrectly formatted");
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
            response.getWriter().println(e.getUserMessage());
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void processDataSource(OutputStream outputStream, DataSource dataSource, ProgressReporter progressReporter) throws Exception {
        if (!(dataSource instanceof ExtendedDataSource)) {
            throw new SerializerException("Unsupported datasource type: " + dataSource);
        }
        ((ExtendedDataSource)dataSource).writeToOutputStream(outputStream, progressReporter);
    }
}

