/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.as.issuer.MD5Generator;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.issuer.ValueGenerator;
import org.apache.oltu.oauth2.as.request.OAuthTokenRequest;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.models.store.OAuthAuthorizationCode;
import org.bimserver.models.store.SingleProjectAuthorization;
import org.bimserver.models.store.StorePackage;
import org.bimserver.servlets.SubServlet;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.RunServiceAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAccessTokenServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthAccessTokenServlet.class);

    public OAuthAccessTokenServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OAuthTokenRequest oauthRequest = null;
        OAuthIssuerImpl oauthIssuerImpl = new OAuthIssuerImpl((ValueGenerator)new MD5Generator());
        if (!request.getContentType().equals("application/x-www-form-urlencoded")) {
            response.setStatus(405);
            PrintWriter pw = response.getWriter();
            pw.print("ContentType must be application/x-www-form-urlencoded");
            pw.flush();
            pw.close();
            return;
        }
        try {
            oauthRequest = new OAuthTokenRequest(request);
            OAuthAuthorizationCode code = null;
            try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
                String codeAsString = oauthRequest.getCode();
                code = (OAuthAuthorizationCode)session.querySingle(StorePackage.eINSTANCE.getOAuthAuthorizationCode_Code(), codeAsString);
                this.validateClient(oauthRequest);
                String resourceUrl = "";
                org.bimserver.models.store.Authorization auth = code.getAuthorization();
                Authorization authorization = null;
                if (auth instanceof SingleProjectAuthorization) {
                    SingleProjectAuthorization singleProjectAuthorization = (SingleProjectAuthorization)auth;
                    authorization = new org.bimserver.webservices.authorization.SingleProjectAuthorization(this.getBimServer(), code.getUser().getOid(), singleProjectAuthorization.getProject().getOid());
                } else if (auth instanceof org.bimserver.models.store.RunServiceAuthorization) {
                    org.bimserver.models.store.RunServiceAuthorization runServiceAuthorization = (org.bimserver.models.store.RunServiceAuthorization)auth;
                    authorization = new RunServiceAuthorization(this.getBimServer(), code.getUser().getOid(), runServiceAuthorization.getService().getOid());
                    resourceUrl = this.getBimServer().getServerSettingsCache().getServerSettings().getSiteAddress() + "/services/" + runServiceAuthorization.getService().getOid();
                } else {
                    throw new Exception("Unknown auth");
                }
                String accessToken = authorization.asHexToken(this.getBimServer().getEncryptionKey());
                String refreshToken = oauthIssuerImpl.refreshToken();
                OAuthASResponse.OAuthTokenResponseBuilder builder = OAuthASResponse.tokenResponse((int)200).setAccessToken(accessToken).setExpiresIn("3600").setRefreshToken(refreshToken);
                builder.setParam("resource_url", resourceUrl);
                if (auth instanceof SingleProjectAuthorization) {
                    builder.setParam("poid", "" + ((SingleProjectAuthorization)code.getAuthorization()).getProject().getOid());
                } else if (auth instanceof org.bimserver.models.store.RunServiceAuthorization) {
                    builder.setParam("soid", "" + ((org.bimserver.models.store.RunServiceAuthorization)code.getAuthorization()).getService().getOid());
                }
                OAuthResponse r = builder.buildJSONMessage();
                response.setStatus(r.getResponseStatus());
                response.setContentType("application/json");
                PrintWriter pw = response.getWriter();
                pw.print(r.getBody());
                pw.flush();
                pw.close();
            }
            catch (BimserverDatabaseException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        catch (OAuthProblemException ex) {
            LOGGER.error("", (Throwable)ex);
            try {
                OAuthResponse r = OAuthResponse.errorResponse((int)401).error(ex).buildJSONMessage();
                response.setStatus(r.getResponseStatus());
                PrintWriter pw = response.getWriter();
                pw.print(r.getBody());
                pw.flush();
                pw.close();
            }
            catch (OAuthSystemException e) {
                LOGGER.error("", (Throwable)ex);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void validateClient(OAuthTokenRequest oauthRequest) {
    }
}

