/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.oltu.oauth2.as.request.OAuthAuthzRequest;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.BimserverLockConflictException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.models.store.OAuthAuthorizationCode;
import org.bimserver.models.store.OAuthServer;
import org.bimserver.models.store.RunServiceAuthorization;
import org.bimserver.models.store.SingleProjectAuthorization;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.servlets.SubServlet;
import org.bimserver.webservices.authorization.AuthenticationException;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthorizationServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthAuthorizationServlet.class);

    public OAuthAuthorizationServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        OAuthAuthzRequest oauthRequest = null;
        String authType = request.getParameter("auth_type");
        if (request.getParameter("token") == null) {
            String location = "/apps/bimviews/?page=OAuth&auth_type=" + authType + "&client_id=" + request.getParameter("client_id") + "&response_type=" + request.getParameter("response_type") + "&redirect_uri=" + request.getParameter("redirect_uri");
            if (request.getParameter("state") != null) {
                location = location + "&state=" + request.getParameter("state");
            }
            httpServletResponse.sendRedirect(location);
            return;
        }
        OAuthAuthorizationCode oauthCode = null;
        String token = request.getParameter("token");
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            OAuthServer oAuthServer = (OAuthServer)session.querySingle(StorePackage.eINSTANCE.getOAuthServer_ClientId(), request.getParameter("client_id"));
            Authorization realAuth = Authorization.fromToken(this.getBimServer().getEncryptionKey(), token);
            long uoid = realAuth.getUoid();
            User user = (User)session.get(uoid, OldQuery.getDefault());
            for (OAuthAuthorizationCode oAuthAuthorizationCode : user.getOAuthIssuedAuthorizationCodes()) {
                if (oAuthAuthorizationCode.getOauthServer() != oAuthServer || oAuthAuthorizationCode.getAuthorization() == null) continue;
                oauthCode = oAuthAuthorizationCode;
            }
            try {
                if (oauthCode == null) {
                    throw new ServletException("No auth found for token " + token);
                }
                oauthRequest = new OAuthAuthzRequest(request);
                String responseType = oauthRequest.getParam("response_type");
                OAuthASResponse.OAuthAuthorizationResponseBuilder builder = OAuthASResponse.authorizationResponse((HttpServletRequest)request, (int)302);
                if (responseType.equals(ResponseType.CODE.toString())) {
                    builder.setCode(oauthCode.getCode());
                }
                String redirectURI = oauthRequest.getParam("redirect_uri");
                OAuthASResponse.OAuthAuthorizationResponseBuilder build = builder.location(redirectURI).setParam("address", this.getBimServer().getServerSettingsCache().getServerSettings().getSiteAddress() + "/json");
                if (oauthCode.getAuthorization() instanceof SingleProjectAuthorization) {
                    SingleProjectAuthorization singleProjectAuthorization = (SingleProjectAuthorization)oauthCode.getAuthorization();
                    build.setParam("poid", "" + singleProjectAuthorization.getProject().getOid());
                } else if (oauthCode.getAuthorization() instanceof RunServiceAuthorization) {
                    RunServiceAuthorization auth = (RunServiceAuthorization)oauthCode.getAuthorization();
                    build.setParam("soid", "" + auth.getService().getOid());
                }
                OAuthResponse response = build.buildQueryMessage();
                String locationUri = response.getLocationUri();
                URI url = new URI(locationUri);
                LOGGER.info("Redirecting to " + url);
                httpServletResponse.sendRedirect(locationUri);
            }
            catch (OAuthProblemException e) {
                Response.ResponseBuilder responseBuilder = Response.status((int)302);
                String redirectUri = e.getRedirectUri();
                if (OAuthUtils.isEmpty((String)redirectUri)) {
                    throw new WebApplicationException(responseBuilder.entity((Object)"OAuth callback url needs to be provided by client!!!").build());
                }
                try {
                    OAuthResponse response = OAuthASResponse.errorResponse((int)302).error(e).location(redirectUri).buildQueryMessage();
                    httpServletResponse.sendRedirect(response.getLocationUri());
                }
                catch (OAuthSystemException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (OAuthSystemException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (BimserverLockConflictException e2) {
            e2.printStackTrace();
        }
        catch (BimserverDatabaseException e2) {
            e2.printStackTrace();
        }
        catch (AuthenticationException e2) {
            e2.printStackTrace();
        }
    }
}

