/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.google.common.base.Charsets;
import com.google.common.primitives.Longs;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bimserver.plugins.LittleEndianSerializerDataOutputStream;
import org.bimserver.utils.GrowingByteBuffer;

public class ReusableLittleEndianDataOutputStream
extends LittleEndianSerializerDataOutputStream {
    GrowingByteBuffer growingByteBuffer = new GrowingByteBuffer(100000);
    private DataOutputStream dataOutputStream = new DataOutputStream(new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            ReusableLittleEndianDataOutputStream.this.growingByteBuffer.putNoCheck((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ReusableLittleEndianDataOutputStream.this.growingByteBuffer.putNoCheck(b, off, len);
        }
    });

    public GrowingByteBuffer getGrowingByteBuffer() {
        return this.growingByteBuffer;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(len);
        this.dataOutputStream.write(b, off, len);
    }

    public void writeDouble(double v) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(8);
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeFloat(float v) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(4);
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeInt(int v) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(4);
        this.dataOutputStream.write(0xFF & v);
        this.dataOutputStream.write(0xFF & v >> 8);
        this.dataOutputStream.write(0xFF & v >> 16);
        this.dataOutputStream.write(0xFF & v >> 24);
    }

    public void writeLong(long v) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(8);
        byte[] bytes = Longs.toByteArray((long)Long.reverseBytes(v));
        this.write(bytes, 0, bytes.length);
    }

    public void writeShort(short v) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(2);
        this.dataOutputStream.write(0xFF & v);
        this.dataOutputStream.write(0xFF & v >> 8);
    }

    public void writeUTF(String str) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(2 + str.getBytes(Charsets.UTF_8).length);
        this.dataOutputStream.writeUTF(str);
    }

    public void write(int b) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(1);
        this.dataOutputStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(b.length);
        this.dataOutputStream.write(b);
    }

    public void reset() {
        this.growingByteBuffer.position(0);
    }

    public void writeByte(byte val) throws IOException {
        this.growingByteBuffer.ensureExtraCapacity(1);
        this.dataOutputStream.write(val);
    }
}

