/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.bimserver.BimServer;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.bimbots.BimBotsException;
import org.bimserver.bimbots.BimBotsInput;
import org.bimserver.bimbots.BimBotsOutput;
import org.bimserver.bimbots.BimBotsServiceInterface;
import org.bimserver.bimbots.BimServerBimBotsInput;
import org.bimserver.database.BimDatabase;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.emf.Schema;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.interfaces.objects.SDeserializerPluginConfiguration;
import org.bimserver.interfaces.objects.SExtendedData;
import org.bimserver.interfaces.objects.SExtendedDataSchema;
import org.bimserver.interfaces.objects.SFile;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.InternalServicePluginConfiguration;
import org.bimserver.models.store.ObjectState;
import org.bimserver.models.store.PluginDescriptor;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.SchemaName;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.plugins.deserializers.Deserializer;
import org.bimserver.plugins.deserializers.DeserializerPlugin;
import org.bimserver.plugins.services.ServicePlugin;
import org.bimserver.servlets.SubServlet;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.utils.InputStreamDataSource;
import org.bimserver.webservices.authorization.AuthenticationException;
import org.bimserver.webservices.authorization.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRunnerServlet
extends SubServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRunnerServlet.class);

    public ServiceRunnerServlet(BimServer bimServer, ServletContext servletContext) {
        super(bimServer, servletContext);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block37: {
            String serviceName;
            String a;
            if (request.getRequestURI().endsWith("/servicelist")) {
                this.processServiceList(request, response);
                return;
            }
            String token = null;
            if (request.getHeader("Authorization") != null && (a = request.getHeader("Authorization")).startsWith("Bearer")) {
                token = a.substring(7);
            }
            if (token == null) {
                token = request.getHeader("token");
            }
            if ((serviceName = request.getHeader("ServiceName")) == null && (serviceName = request.getRequestURI()).startsWith("/services/")) {
                serviceName = serviceName.substring(10);
            }
            long serviceOid = Long.parseLong(serviceName);
            String inputType = request.getHeader("Input-Type");
            try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
                Authorization authorization = Authorization.fromToken(this.getBimServer().getEncryptionKey(), token);
                User user = (User)session.get(authorization.getUoid(), OldQuery.getDefault());
                if (user == null) {
                    throw new UserException("No user found with uoid " + authorization.getUoid());
                }
                if (user.getState() == ObjectState.DELETED) {
                    throw new UserException("User has been deleted");
                }
                InternalServicePluginConfiguration foundService = null;
                UserSettings userSettings = user.getUserSettings();
                for (InternalServicePluginConfiguration internalServicePluginConfiguration : userSettings.getServices()) {
                    if (internalServicePluginConfiguration.getOid() != serviceOid) continue;
                    foundService = internalServicePluginConfiguration;
                    break;
                }
                if (foundService == null) {
                    throw new ServletException("Service \"" + serviceName + "\" not found for this user");
                }
                PluginDescriptor pluginDescriptor = foundService.getPluginDescriptor();
                ServicePlugin servicePlugin = this.getBimServer().getPluginManager().getServicePlugin(pluginDescriptor.getPluginClassName(), true);
                if (servicePlugin instanceof BimBotsServiceInterface) {
                    BimBotsServiceInterface bimBotsServiceInterface = (BimBotsServiceInterface)servicePlugin;
                    try {
                        if (this.getBimServer().getServerSettingsCache().getServerSettings().isStoreServiceRuns()) {
                            SProject project;
                            ServiceInterface serviceInterface = this.getBimServer().getServiceFactory().get(authorization, AccessMethod.INTERNAL).get(ServiceInterface.class);
                            SDeserializerPluginConfiguration deserializer = serviceInterface.getSuggestedDeserializerForExtension("ifc", Long.valueOf((project = serviceInterface.addProject("tmp-" + new Random().nextInt(), "ifc2x3tc1")).getOid()));
                            if (deserializer == null) {
                                throw new BimBotsException("No deserializer found");
                            }
                            serviceInterface.checkin(Long.valueOf(project.getOid()), "Auto checkin", Long.valueOf(deserializer.getOid()), Long.valueOf(-1L), "s", new DataHandler((DataSource)new InputStreamDataSource((InputStream)request.getInputStream())), Boolean.valueOf(false), Boolean.valueOf(true));
                            project = serviceInterface.getProjectByPoid(Long.valueOf(project.getOid()));
                            PackageMetaData packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(project.getSchema());
                            BasicIfcModel model = new BasicIfcModel(packageMetaData, null);
                            try {
                                Revision revision = (Revision)session.get(project.getLastRevisionId(), OldQuery.getDefault());
                                session.getMap((IfcModelInterface)model, new OldQuery(packageMetaData, project.getId(), revision.getId(), revision.getOid(), null, OldQuery.Deep.NO));
                            }
                            catch (BimserverDatabaseException e) {
                                e.printStackTrace();
                            }
                            BimServerBimBotsInput input = new BimServerBimBotsInput(this.getBimServer(), authorization.getUoid(), null, null, (IfcModelInterface)model);
                            BimBotsOutput output = bimBotsServiceInterface.runBimBot((BimBotsInput)input, this.getBimServer().getSConverter().convertToSObject(foundService.getSettings()));
                            SExtendedData extendedData = new SExtendedData();
                            SFile file = new SFile();
                            file.setData(output.getData());
                            file.setFilename(output.getContentDisposition());
                            file.setMime(output.getContentType());
                            file.setSize((long)output.getData().length);
                            Long fileId = serviceInterface.uploadFile(file);
                            extendedData.setFileId(fileId.longValue());
                            extendedData.setTitle(output.getTitle());
                            SExtendedDataSchema extendedDataSchema = null;
                            try {
                                extendedDataSchema = serviceInterface.getExtendedDataSchemaByName(output.getSchemaName());
                            }
                            catch (UserException e) {
                                extendedDataSchema = new SExtendedDataSchema();
                                extendedDataSchema.setContentType(output.getContentType());
                                extendedDataSchema.setName(output.getSchemaName());
                                serviceInterface.addExtendedDataSchema(extendedDataSchema);
                            }
                            extendedData.setSchemaId(extendedDataSchema.getOid());
                            serviceInterface.addExtendedDataToRevision(Long.valueOf(project.getLastRevisionId()), extendedData);
                            response.setHeader("Output-Type", output.getSchemaName());
                            response.setHeader("Data-Title", output.getTitle());
                            response.setHeader("Content-Type", output.getContentType());
                            response.setHeader("Content-Disposition", output.getContentDisposition());
                            response.getOutputStream().write(output.getData());
                            break block37;
                        }
                        DeserializerPlugin deserializerPlugin = this.getBimServer().getPluginManager().getFirstDeserializer("ifc", Schema.IFC2X3TC1, true);
                        if (deserializerPlugin == null) {
                            throw new BimBotsException("No deserializer plugin found");
                        }
                        byte[] data = IOUtils.toByteArray((InputStream)request.getInputStream());
                        SchemaName schema = SchemaName.valueOf((String)inputType);
                        Deserializer deserializer = deserializerPlugin.createDeserializer(new PluginConfiguration());
                        PackageMetaData packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData("ifc2x3tc1");
                        deserializer.init(packageMetaData);
                        IfcModelInterface model = deserializer.read((InputStream)new ByteArrayInputStream(data), schema.name(), (long)data.length, null);
                        BimServerBimBotsInput input = new BimServerBimBotsInput(this.getBimServer(), authorization.getUoid(), schema, data, model);
                        BimBotsOutput output = bimBotsServiceInterface.runBimBot((BimBotsInput)input, this.getBimServer().getSConverter().convertToSObject(foundService.getSettings()));
                        response.setHeader("Output-Type", output.getSchemaName());
                        response.setHeader("Data-Title", output.getTitle());
                        response.setHeader("Content-Type", output.getContentType());
                        response.setHeader("Content-Disposition", output.getContentDisposition());
                        response.getOutputStream().write(output.getData());
                    }
                    catch (BimBotsException e) {
                        e.printStackTrace();
                    }
                    catch (DeserializeException e) {
                        e.printStackTrace();
                    }
                    catch (PluginException e) {
                        e.printStackTrace();
                    }
                    catch (ServerException e1) {
                        e1.printStackTrace();
                    }
                    break block37;
                }
                throw new ServletException("Service \"" + serviceName + "\" does not implement the BimBotsServiceInterface");
            }
            catch (AuthenticationException e) {
                e.printStackTrace();
            }
            catch (BimserverDatabaseException e) {
                e.printStackTrace();
            }
            catch (UserException e) {
                e.printStackTrace();
            }
        }
    }

    private void processServiceList(HttpServletRequest request, HttpServletResponse response) {
        BimDatabase database = this.getBimServer().getDatabase();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode result = mapper.createObjectNode();
        ArrayNode array = mapper.createArrayNode();
        result.set("services", (JsonNode)array);
        try (DatabaseSession session = database.createSession();){
            for (PluginDescriptor pluginDescriptor : session.getAllOfType(StorePackage.eINSTANCE.getPluginDescriptor(), PluginDescriptor.class, (QueryInterface)OldQuery.getDefault())) {
                ServicePlugin servicePlugin;
                if (!pluginDescriptor.getPluginInterfaceClassName().equals(ServicePlugin.class.getName()) || !((servicePlugin = this.getBimServer().getPluginManager().getServicePlugin(pluginDescriptor.getPluginClassName(), true)) instanceof BimBotsServiceInterface)) continue;
                try {
                    BimBotsServiceInterface bimBotsServiceInterface = (BimBotsServiceInterface)servicePlugin;
                    ObjectNode descriptorJson = mapper.createObjectNode();
                    descriptorJson.put("id", pluginDescriptor.getOid());
                    descriptorJson.put("name", pluginDescriptor.getName());
                    descriptorJson.put("description", pluginDescriptor.getDescription());
                    descriptorJson.put("provider", this.getBimServer().getServerSettingsCache().getServerSettings().getName());
                    descriptorJson.put("providerIcon", this.getBimServer().getServerSettingsCache().getServerSettings().getIcon());
                    ArrayNode inputs = mapper.createArrayNode();
                    ArrayNode outputs = mapper.createArrayNode();
                    for (String schemaName : bimBotsServiceInterface.getAvailableInputs()) {
                        inputs.add(schemaName);
                    }
                    for (String schemaName : bimBotsServiceInterface.getAvailableOutputs()) {
                        outputs.add(schemaName);
                    }
                    descriptorJson.set("inputs", (JsonNode)inputs);
                    descriptorJson.set("outputs", (JsonNode)outputs);
                    ObjectNode oauth = mapper.createObjectNode();
                    oauth.put("authorizationUrl", this.getBimServer().getServerSettingsCache().getServerSettings().getSiteAddress() + "/oauth/authorize");
                    oauth.put("registerUrl", this.getBimServer().getServerSettingsCache().getServerSettings().getSiteAddress() + "/oauth/register");
                    oauth.put("tokenUrl", this.getBimServer().getServerSettingsCache().getServerSettings().getSiteAddress() + "/oauth/access");
                    descriptorJson.set("oauth", (JsonNode)oauth);
                    descriptorJson.put("resourceUrl", this.getBimServer().getServerSettingsCache().getServerSettings().getSiteAddress() + "/services");
                    array.add((JsonNode)descriptorJson);
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
            response.setContentType("application/json");
            response.getOutputStream().write(mapper.writeValueAsBytes((Object)result));
        }
        catch (BimserverDatabaseException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

