/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.GregorianCalendar;
import org.apache.commons.io.output.NullWriter;
import org.bimserver.BimServer;
import org.bimserver.endpoints.EndPoint;
import org.bimserver.longaction.LongAction;
import org.bimserver.longaction.LongDownloadOrCheckoutAction;
import org.bimserver.longaction.LongStreamingDownloadAction;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.servlets.JsonWebsocketReflector;
import org.bimserver.servlets.ReusableLittleEndianDataOutputStream;
import org.bimserver.shared.StreamingSocketInterface;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.NotificationInterface;
import org.bimserver.shared.interfaces.RemoteServiceInterface;
import org.bimserver.shared.reflector.Reflector;
import org.bimserver.utils.Formatters;
import org.bimserver.utils.GrowingByteBuffer;
import org.bimserver.webservices.ServiceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Streamer
implements EndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(Streamer.class);
    private long uoid;
    private long endpointid;
    private BimServer bimServer;
    private NotificationInterface notificationInterface;
    private RemoteServiceInterface remoteServiceInterface;
    private StreamingSocketInterface streamingSocketInterface;

    public Streamer(StreamingSocketInterface streamingSocketInterface, BimServer bimServer) {
        this.streamingSocketInterface = streamingSocketInterface;
        this.bimServer = bimServer;
        this.notificationInterface = (NotificationInterface)bimServer.getReflectorFactory().createReflector(NotificationInterface.class, (Reflector)new JsonWebsocketReflector(bimServer.getServicesMap(), streamingSocketInterface));
        this.remoteServiceInterface = (RemoteServiceInterface)bimServer.getReflectorFactory().createReflector(RemoteServiceInterface.class, (Reflector)new JsonWebsocketReflector(bimServer.getServicesMap(), streamingSocketInterface));
    }

    public void onOpen() {
        JsonObject welcome = new JsonObject();
        welcome.add("welcome", (JsonElement)new JsonPrimitive((Number)new GregorianCalendar().getTimeInMillis()));
        this.streamingSocketInterface.send(welcome);
    }

    public void onText(Reader reader) {
        JsonParser parser = new JsonParser();
        JsonReader jsonreader = new JsonReader(reader);
        JsonObject request = (JsonObject)parser.parse(jsonreader);
        if (!request.has("hb")) {
            if (request.has("action")) {
                if (request.get("action").getAsString().equals("download")) {
                    final long topicId = request.get("topicId").getAsLong();
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                final LongAction<?> longAction = Streamer.this.bimServer.getLongActionManager().getLongAction(topicId);
                                org.bimserver.plugins.serializers.Writer writer = null;
                                if (longAction instanceof LongStreamingDownloadAction) {
                                    LongStreamingDownloadAction longStreamingDownloadAction = (LongStreamingDownloadAction)longAction;
                                    writer = longStreamingDownloadAction.getMessagingStreamingSerializer();
                                } else {
                                    LongDownloadOrCheckoutAction longDownloadAction = (LongDownloadOrCheckoutAction)longAction;
                                    writer = longDownloadAction.getMessagingSerializer();
                                }
                                boolean writeMessage = true;
                                int counter = 0;
                                long bytes = 0L;
                                long start = System.nanoTime();
                                ReusableLittleEndianDataOutputStream byteArrayOutputStream = new ReusableLittleEndianDataOutputStream();
                                GrowingByteBuffer growingByteBuffer = byteArrayOutputStream.getGrowingByteBuffer();
                                ProgressReporter progressReporter = new ProgressReporter(){

                                    public void update(long progress, long max) {
                                        longAction.updateProgress("test", (int)(progress * 100L / max));
                                    }

                                    public void setTitle(String title) {
                                    }
                                };
                                do {
                                    byteArrayOutputStream.reset();
                                    byteArrayOutputStream.writeLong(topicId);
                                    writeMessage = writer.writeMessage((OutputStream)((Object)byteArrayOutputStream), progressReporter);
                                    bytes += (long)growingByteBuffer.usedSize();
                                    Streamer.this.streamingSocketInterface.sendBlocking(growingByteBuffer.array(), 0, growingByteBuffer.usedSize());
                                    ++counter;
                                } while (writeMessage);
                                long end = System.nanoTime();
                                LOGGER.info(counter + " messages written " + Formatters.bytesToString((long)bytes) + " in " + (end - start) / 1000000L + " ms");
                            }
                            catch (IOException longAction) {
                            }
                            catch (SerializerException e) {
                                LOGGER.error("", (Throwable)e);
                            }
                        }
                    };
                    thread.setName("Streamer " + topicId);
                    thread.start();
                }
            } else if (request.has("token")) {
                String token = request.get("token").getAsString();
                try {
                    ServiceMap serviceMap = this.bimServer.getServiceFactory().get(token, AccessMethod.JSON);
                    this.uoid = serviceMap.getBimServerAuthInterface().getLoggedInUser().getOid();
                    this.endpointid = this.bimServer.getEndPointManager().register(this);
                    JsonObject enpointMessage = new JsonObject();
                    enpointMessage.add("endpointid", (JsonElement)new JsonPrimitive((Number)this.endpointid));
                    this.streamingSocketInterface.send(enpointMessage);
                }
                catch (UserException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (ServerException e) {
                    LOGGER.error("", (Throwable)e);
                }
            } else {
                this.bimServer.getJsonHandler().execute(request, null, (Writer)new NullWriter());
            }
        }
    }

    @Override
    public void cleanup() {
        this.bimServer.getEndPointManager().unregister(this.endpointid);
    }

    public void onClose() {
        LOGGER.debug("onClose, unregistering endpoint " + this.getEndPointId());
        this.bimServer.getEndPointManager().unregister(this);
    }

    @Override
    public long getEndPointId() {
        return this.endpointid;
    }

    @Override
    public NotificationInterface getNotificationInterface() {
        return this.notificationInterface;
    }

    @Override
    public RemoteServiceInterface getRemoteServiceInterface() {
        return this.remoteServiceInterface;
    }

    @Override
    public long getUoid() {
        return this.uoid;
    }

    public String toString() {
        return "Streamer with endpoint " + this.endpointid;
    }
}

