/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.servlets.websockets.jsr356;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import org.bimserver.BimServer;
import org.bimserver.servlets.Streamer;
import org.bimserver.shared.StreamingSocketInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
@ServerEndpoint(value="/stream")
public class Jsr356Impl
implements StreamingSocketInterface,
ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jsr356Impl.class);
    private Streamer streamer;
    private Session websocketSession;
    private static Map<ServerContainer, ServletContext> servletContexts = new HashMap<ServerContainer, ServletContext>();
    private static ServletContext defaultServletContext;

    @OnOpen
    public void onOpen(Session websocketSession, EndpointConfig config) {
        LOGGER.debug("WebSocket open");
        try {
            this.websocketSession = websocketSession;
            ServletContext servletContext = servletContexts.get(websocketSession.getContainer());
            if (servletContext == null) {
                servletContext = defaultServletContext;
            }
            BimServer bimServer = (BimServer)servletContext.getAttribute("bimserver");
            this.streamer = new Streamer(this, bimServer);
            this.streamer.onOpen();
        }
        catch (Throwable t) {
            LOGGER.error("", t);
        }
    }

    public static void setServletContext(ServerContainer serverContainer, ServletContext servletContext) {
        servletContexts.put(serverContainer, servletContext);
    }

    public static void setDefaultServletContext(ServletContext servletContext) {
        defaultServletContext = servletContext;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        LOGGER.info("WebSocket context initialized");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        LOGGER.info("WebSocket context destroyed");
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        this.streamer.onText(new StringReader(message));
    }

    @OnError
    public void onError(Throwable exception, Session session) {
        if (exception instanceof IOException) {
            LOGGER.error("", exception);
        } else {
            LOGGER.error("", exception);
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        this.streamer.onClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JsonObject request) {
        Jsr356Impl jsr356Impl = this;
        synchronized (jsr356Impl) {
            if (this.websocketSession.isOpen()) {
                try {
                    this.websocketSession.getBasicRemote().sendText(request.toString());
                }
                catch (Exception exception) {}
            } else {
                this.streamer.onClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> send(byte[] data, int start, int length) {
        Jsr356Impl jsr356Impl = this;
        synchronized (jsr356Impl) {
            return this.websocketSession.getAsyncRemote().sendBinary(ByteBuffer.wrap(data, start, length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBlocking(byte[] data, int start, int length) throws IOException {
        Jsr356Impl jsr356Impl = this;
        synchronized (jsr356Impl) {
            this.websocketSession.getBasicRemote().sendBinary(ByteBuffer.wrap(data, start, length));
        }
    }
}

