/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.templating;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.URLResourceLoader;
import org.bimserver.templating.TemplateIdentifier;
import org.bimserver.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateEngine.class);
    private VelocityEngine velocityEngine;

    public String process(Map<String, Object> context, TemplateIdentifier templateIdentifier) {
        StringWriter stringWriter = new StringWriter();
        VelocityContext velocityContext = new VelocityContext(context);
        try {
            this.velocityEngine.mergeTemplate(templateIdentifier.getFileName(), "UTF-8", (Context)velocityContext, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (ResourceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ParseErrorException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (MethodInvocationException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return "";
    }

    public void init(URL resource) {
        LOGGER.info("Using \"" + StringUtils.getPrettyFileUrl((URL)resource) + "\" as template dir");
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("resource.loader", (Object)"url");
        this.velocityEngine.setProperty("url.resource.loader.class", (Object)URLResourceLoader.class.getName());
        this.velocityEngine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.Log4JLogChute");
        this.velocityEngine.setProperty("runtime.log.logsystem.log4j.logger", (Object)"velocity");
        try {
            this.velocityEngine.setProperty("url.resource.loader.root", (Object)URLDecoder.decode(resource.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("", (Throwable)e);
        }
        try {
            this.velocityEngine.init();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

