/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.tools.generators;

import java.io.File;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SParameter;
import org.bimserver.shared.meta.SService;
import org.bimserver.utils.Licenser;

public class AdaptorGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package org.bimserver.shared.interfaces;" + this.NL;
    protected final String TEXT_2 = this.NL;
    protected final String TEXT_3 = this.NL + "import org.bimserver.shared.exceptions.UserException;" + this.NL + "import org.bimserver.shared.exceptions.ServerException;";
    protected final String TEXT_4 = this.NL + this.NL + "public class ";
    protected final String TEXT_5 = "Adaptor implements ";
    protected final String TEXT_6 = " {" + this.NL;
    protected final String TEXT_7 = this.NL + "\tpublic ";
    protected final String TEXT_8 = " ";
    protected final String TEXT_9 = "(";
    protected final String TEXT_10 = " ";
    protected final String TEXT_11 = ") throws UserException, ServerException {";
    protected final String TEXT_12 = this.NL + "\t\treturn null;";
    protected final String TEXT_13 = this.NL + "\t}" + this.NL + "\t";
    protected final String TEXT_14 = this.NL + "}";

    public static synchronized AdaptorGenerator create(String lineSeparator) {
        nl = lineSeparator;
        AdaptorGenerator result = new AdaptorGenerator();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.TEXT_1);
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(Licenser.getCommentedLicenseText((File)new File("license.txt")));
        stringBuffer.append(this.TEXT_3);
        SService sService = (SService)argument;
        stringBuffer.append(this.TEXT_4);
        stringBuffer.append(sService.getSimpleName());
        stringBuffer.append("Adaptor implements ");
        stringBuffer.append(sService.getInterfaceClass().getName());
        stringBuffer.append(this.TEXT_6);
        for (SMethod method : sService.getMethods()) {
            stringBuffer.append(this.TEXT_7);
            stringBuffer.append(method.getGenericReturnType() != null ? method.getReturnType().toJavaCode() + "<" + method.getGenericReturnType().toJavaCode() + ">" : method.getReturnType().toJavaCode());
            stringBuffer.append(" ");
            stringBuffer.append(method.getName());
            stringBuffer.append("(");
            for (SParameter parameter : method.getParameters()) {
                stringBuffer.append(parameter.getGenericType() != null ? parameter.getType().toJavaCode() + "<" + parameter.getGenericType() + ">" : parameter.getType().toJavaCode());
                stringBuffer.append(" ");
                stringBuffer.append(parameter.getName());
                stringBuffer.append(parameter.isLast() ? "" : ", ");
            }
            stringBuffer.append(") throws UserException, ServerException {");
            if (!method.getReturnType().isVoid()) {
                stringBuffer.append(this.TEXT_12);
            }
            stringBuffer.append(this.TEXT_13);
        }
        stringBuffer.append(this.TEXT_14);
        return stringBuffer.toString();
    }
}

