/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.tools.generators;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.bimserver.shared.meta.SService;
import org.bimserver.tools.generators.AdaptorGenerator;
import org.bimserver.tools.generators.SConverterGeneratorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptorGeneratorWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SConverterGeneratorWrapper.class);

    public void generate(Class<?> interfaceClass, SService sService) {
        File adaptorFile = new File("../PluginBase/generated/org/bimserver/shared/interfaces/" + interfaceClass.getSimpleName() + "Adaptor.java");
        AdaptorGenerator adaptorGenerator = new AdaptorGenerator();
        String generated = adaptorGenerator.generate(sService);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(adaptorFile);
            ((OutputStream)fileOutputStream).write(generated.getBytes(Charsets.UTF_8));
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

