/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.tools.generators;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.tools.generators.ImportManager;
import org.bimserver.tools.generators.ServiceInterfaceObjectGenerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataObjectGeneratorWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataObjectGeneratorWrapper.class);
    private File sourceFolder = new File("../PluginBase/generated");
    private File packageFolder = new File(this.sourceFolder, "org" + File.separator + "bimserver" + File.separator + "interfaces" + File.separator + "objects");
    private MetaDataManager metaDataManager;

    public DataObjectGeneratorWrapper(MetaDataManager metaDataManager) {
        this.metaDataManager = metaDataManager;
    }

    public void generateDataObjects(Set<EPackage> ePackages) {
        try {
            FileUtils.forceMkdir((File)this.packageFolder);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        ServiceInterfaceObjectGenerator dataObjectGenerator = new ServiceInterfaceObjectGenerator();
        HashSet<String> fileNamesCreated = new HashSet<String>();
        for (EPackage ePackage : ePackages) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass) && !(eClassifier instanceof EEnum)) continue;
                Object[] arguments = new Object[]{eClassifier, new ImportManager(), this.metaDataManager};
                String generated = dataObjectGenerator.generate(arguments);
                String fileName = "S" + eClassifier.getName() + ".java";
                fileNamesCreated.add(fileName);
                File file = new File(this.packageFolder, fileName);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ((OutputStream)fileOutputStream).write(generated.getBytes(Charsets.UTF_8));
                    ((OutputStream)fileOutputStream).close();
                }
                catch (FileNotFoundException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
        for (File file : this.packageFolder.listFiles()) {
            if (fileNamesCreated.contains(file.getName())) continue;
            file.delete();
        }
    }
}

