/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.tools.generators;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FileUtils;
import org.bimserver.tools.generators.SServiceGenerator;
import org.eclipse.emf.ecore.EPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SServiceGeneratorWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SServiceGeneratorWrapper.class);
    private File sourceFolder = new File("../PluginBase/generated");
    private File packageFolder = new File(this.sourceFolder, "org" + File.separator + "bimserver" + File.separator + "interfaces");

    public void generate(Class<?> clazz, EPackage ePackage) {
        try {
            FileUtils.forceMkdir((File)this.packageFolder);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        SServiceGenerator converterGenerator = new SServiceGenerator();
        Object[] arguments = new Object[]{clazz, ePackage};
        String generated = converterGenerator.generate(arguments);
        File file = new File(this.packageFolder, "S" + clazz.getSimpleName() + "Service.java");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(generated.getBytes(Charsets.UTF_8));
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

