/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.version;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.bimserver.interfaces.objects.SVersion;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.version.VersionCheckException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionChecker.class);
    private GregorianCalendar lastCheck;
    private SVersion onlineVersion;
    private SVersion localVersion;

    public static void main(String[] args) {
        SVersion version = new SVersion();
        version.setMajor(Integer.valueOf(1));
        version.setMinor(Integer.valueOf(1));
        version.setRevision(Integer.valueOf(0));
        version.setDate(new Date());
        version.setSupportEmail("support@bimserver.org");
        version.setDownloadUrl("http://download.bimserver.org");
        version.setSupportUrl("http://support.bimserver.org");
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SVersion.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)version, new File("version.xml"));
        }
        catch (JAXBException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public VersionChecker(ResourceFetcher resourceFetcher) throws VersionCheckException {
        block33: {
            try {
                Path pom = resourceFetcher.getFile("pom.xml");
                if (pom == null) {
                    throw new VersionCheckException("No pom.xml found");
                }
                if (Files.exists(pom, new LinkOption[0])) {
                    String version = null;
                    MavenXpp3Reader mavenreader = new MavenXpp3Reader();
                    if (pom != null) {
                        try (FileReader fileReader = new FileReader(pom.toFile());){
                            Model model = mavenreader.read((Reader)fileReader);
                            version = model.getVersion();
                        }
                    }
                    if (version == null) {
                        Path parentPom = resourceFetcher.getFile("../pom.xml");
                        if (parentPom != null) {
                            try (FileReader fileReader = new FileReader(parentPom.toFile());){
                                Model parentModel = mavenreader.read((Reader)fileReader);
                                version = parentModel.getVersion();
                            }
                        } else {
                            LOGGER.error("No parent pom.xml found");
                        }
                    }
                    DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(version);
                    this.localVersion = new SVersion();
                    this.localVersion.setMajor(Integer.valueOf(defaultArtifactVersion.getMajorVersion()));
                    this.localVersion.setMinor(Integer.valueOf(defaultArtifactVersion.getMinorVersion()));
                    this.localVersion.setRevision(Integer.valueOf(defaultArtifactVersion.getIncrementalVersion()));
                    this.localVersion.setFullString(defaultArtifactVersion.toString());
                    break block33;
                }
                LOGGER.warn("No version info");
            }
            catch (Exception e) {
                throw new VersionCheckException(e);
            }
        }
    }

    public synchronized SVersion getOnlineVersion() {
        if (this.lastCheck == null || this.lastCheck.before(this.getReferenceDate())) {
            LOGGER.info("Fetching online version info");
            try {
                URL url = new URL("http://www.bimserver.org/version/versionv2.xml");
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SVersion.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                this.onlineVersion = (SVersion)unmarshaller.unmarshal(url);
                this.lastCheck = new GregorianCalendar();
                return this.onlineVersion;
            }
            catch (UnmarshalException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (MalformedURLException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (JAXBException e) {
                LOGGER.error("", (Throwable)e);
            }
            if (this.onlineVersion == null) {
                this.onlineVersion = new SVersion();
                this.onlineVersion.setDownloadUrl("unknown");
                this.onlineVersion.setMajor(Integer.valueOf(-1));
                this.onlineVersion.setMinor(Integer.valueOf(-1));
                this.onlineVersion.setRevision(Integer.valueOf(-1));
                this.onlineVersion.setSupportEmail("unknown");
                this.onlineVersion.setSupportUrl("unknown");
                this.onlineVersion.setDate(new Date(0L));
                this.lastCheck = new GregorianCalendar();
            }
        }
        return this.onlineVersion;
    }

    private GregorianCalendar getReferenceDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.add(11, -1);
        return gregorianCalendar;
    }

    public SVersion getLocalVersion() {
        return this.localVersion;
    }

    public boolean updateNeeded() {
        SVersion localVersion = this.getLocalVersion();
        SVersion onlineVersion = this.getOnlineVersion();
        if (localVersion.getMajor().compareTo(onlineVersion.getMajor()) < 0) {
            return true;
        }
        if (localVersion.getMajor() == onlineVersion.getMajor()) {
            if (localVersion.getMinor().compareTo(onlineVersion.getMinor()) > 0) {
                return true;
            }
            if (localVersion.getMinor().equals(onlineVersion.getMinor()) && onlineVersion.getRevision() != null && localVersion.getRevision() < onlineVersion.getRevision()) {
                return true;
            }
        }
        return false;
    }
}

