/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices;

import java.util.HashMap;
import java.util.Map;
import org.bimserver.BimServer;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.shared.ServiceHolder;
import org.bimserver.shared.ServiceMapInterface;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.AuthInterface;
import org.bimserver.shared.interfaces.LowLevelInterface;
import org.bimserver.shared.interfaces.MetaInterface;
import org.bimserver.shared.interfaces.NewServicesInterface;
import org.bimserver.shared.interfaces.NotificationInterface;
import org.bimserver.shared.interfaces.NotificationInterfaceAdaptor;
import org.bimserver.shared.interfaces.NotificationRegistryInterface;
import org.bimserver.shared.interfaces.OAuthInterface;
import org.bimserver.shared.interfaces.PluginInterface;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.interfaces.RemoteServiceInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.shared.interfaces.async.AsyncAdminInterface;
import org.bimserver.shared.interfaces.async.AsyncAuthInterface;
import org.bimserver.shared.interfaces.async.AsyncMetaInterface;
import org.bimserver.shared.interfaces.async.AsyncPluginInterface;
import org.bimserver.shared.interfaces.async.AsyncRegistryInterface;
import org.bimserver.shared.interfaces.async.AsyncServiceInterface;
import org.bimserver.shared.interfaces.async.AsyncSettingsInterface;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.impl.AdminServiceImpl;
import org.bimserver.webservices.impl.AuthServiceImpl;
import org.bimserver.webservices.impl.LowLevelServiceImpl;
import org.bimserver.webservices.impl.MetaServiceImpl;
import org.bimserver.webservices.impl.NewServicesImpl;
import org.bimserver.webservices.impl.NotificationRegistryServiceImpl;
import org.bimserver.webservices.impl.OAuthServiceImpl;
import org.bimserver.webservices.impl.PluginServiceImpl;
import org.bimserver.webservices.impl.RemoteServiceImpl;
import org.bimserver.webservices.impl.ServiceImpl;
import org.bimserver.webservices.impl.SettingsServiceImpl;

public class ServiceMap
implements ServiceMapInterface,
ServiceHolder {
    private BimServer bimServer;
    private AccessMethod accessMethod;
    private Authorization authorization;
    private final Map<Class<? extends PublicInterface>, PublicInterface> interfaces = new HashMap<Class<? extends PublicInterface>, PublicInterface>();

    public ServiceMap(BimServer bimServer, Authorization authorization, AccessMethod accessMethod) {
        this.bimServer = bimServer;
        this.authorization = authorization;
        this.accessMethod = accessMethod;
    }

    public void put(Class<PublicInterface> clazz, PublicInterface publicInterface) {
        this.interfaces.put(clazz, publicInterface);
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }

    public AccessMethod getAccessMethod() {
        return this.accessMethod;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(Authorization authorization) {
        this.authorization = authorization;
    }

    public <T extends PublicInterface> T get(Class<T> clazz) {
        Object publicInterface = this.interfaces.get(clazz);
        if (publicInterface != null) {
            return (T)publicInterface;
        }
        if (clazz == ServiceInterface.class) {
            publicInterface = new ServiceImpl(this);
        } else if (clazz == NewServicesInterface.class) {
            publicInterface = new NewServicesImpl(this);
        } else if (clazz == AuthInterface.class) {
            publicInterface = new AuthServiceImpl(this);
        } else if (clazz == AdminInterface.class) {
            publicInterface = new AdminServiceImpl(this);
        } else if (clazz == LowLevelInterface.class) {
            publicInterface = new LowLevelServiceImpl(this);
        } else if (clazz == MetaInterface.class) {
            publicInterface = new MetaServiceImpl(this);
        } else if (clazz == SettingsInterface.class) {
            publicInterface = new SettingsServiceImpl(this);
        } else if (clazz == RemoteServiceInterface.class) {
            publicInterface = new RemoteServiceImpl(this.bimServer, this);
        } else if (clazz == NotificationRegistryInterface.class) {
            publicInterface = new NotificationRegistryServiceImpl(this);
        } else if (clazz == NotificationInterface.class) {
            publicInterface = new NotificationInterfaceAdaptor();
        } else if (clazz == PluginInterface.class) {
            publicInterface = new PluginServiceImpl(this);
        } else if (clazz == OAuthInterface.class) {
            publicInterface = new OAuthServiceImpl(this);
        } else {
            throw new RuntimeException("Unknown interface: " + clazz.getName());
        }
        this.interfaces.put((Class<? extends PublicInterface>)clazz, (PublicInterface)publicInterface);
        return (T)publicInterface;
    }

    public <T extends PublicInterface> void add(Class<T> class1, T remoteServiceInterface) {
        this.interfaces.put(class1, remoteServiceInterface);
    }

    public AsyncAdminInterface getAdminAsync() {
        return new AsyncAdminInterface(this.get(AdminInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncMetaInterface getMetaAsync() {
        return new AsyncMetaInterface(this.get(MetaInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncPluginInterface getPluginAsync() {
        return new AsyncPluginInterface(this.get(PluginInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncRegistryInterface getRegistryAsync() {
        return new AsyncRegistryInterface(this.get(NotificationRegistryInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncServiceInterface getServiceAsync() {
        return new AsyncServiceInterface(this.get(ServiceInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncAuthInterface getAuthInterfaceAsync() {
        return new AsyncAuthInterface(this.get(AuthInterface.class), this.bimServer.getExecutorService());
    }

    public AsyncSettingsInterface getSettingsAsync() {
        return new AsyncSettingsInterface(this.get(SettingsInterface.class), this.bimServer.getExecutorService());
    }

    public AdminInterface getAdminInterface() throws PublicInterfaceNotFoundException {
        return this.get(AdminInterface.class);
    }

    public AuthInterface getAuthInterface() throws PublicInterfaceNotFoundException {
        return this.get(AuthInterface.class);
    }

    public MetaInterface getMeta() throws PublicInterfaceNotFoundException {
        return this.get(MetaInterface.class);
    }

    public PluginInterface getPluginInterface() {
        return this.get(PluginInterface.class);
    }

    public ServiceInterface getServiceInterface() throws PublicInterfaceNotFoundException {
        return this.get(ServiceInterface.class);
    }

    public NewServicesInterface getNewServicesInterface() throws PublicInterfaceNotFoundException {
        return this.get(NewServicesInterface.class);
    }

    public SettingsInterface getSettingsInterface() throws PublicInterfaceNotFoundException {
        return this.get(SettingsInterface.class);
    }

    public AuthInterface getBimServerAuthInterface() {
        return this.get(AuthInterface.class);
    }

    public NotificationRegistryInterface getRegistry() throws PublicInterfaceNotFoundException {
        return this.get(NotificationRegistryInterface.class);
    }

    public LowLevelInterface getLowLevelInterface() throws PublicInterfaceNotFoundException {
        return this.get(LowLevelInterface.class);
    }
}

