/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.authorization;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.bimserver.BimServer;
import org.bimserver.webservices.authorization.Authorization;

public class RunServiceAuthorization
extends Authorization {
    public static final byte ID = 7;
    private long soid;

    public RunServiceAuthorization(BimServer bimServer, long uoid, long soid) {
        super(bimServer.getServerSettingsCache().getServerSettings().getSessionTimeOutSeconds(), TimeUnit.SECONDS);
        this.soid = soid;
        this.setUoid(uoid);
    }

    public RunServiceAuthorization() {
    }

    @Override
    protected int getBufferSize() {
        return 16;
    }

    @Override
    protected byte getId() {
        return 7;
    }

    @Override
    protected void getBytes(ByteBuffer buffer) {
        buffer.putLong(this.getUoid());
        buffer.putLong(this.soid);
    }

    public static Authorization fromBuffer(ByteBuffer buffer) {
        RunServiceAuthorization runServiceAuthorization = new RunServiceAuthorization();
        runServiceAuthorization.setUoid(buffer.getLong());
        runServiceAuthorization.setSoid(buffer.getLong());
        return runServiceAuthorization;
    }

    private void setSoid(long soid) {
        this.soid = soid;
    }
}

