/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bimserver.GeometryGenerator;
import org.bimserver.bimbots.BimBotsException;
import org.bimserver.client.protocolbuffers.ProtocolBuffersBimServerClientFactory;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.AddUserDatabaseAction;
import org.bimserver.database.actions.GetDatabaseInformationAction;
import org.bimserver.database.actions.GetLogsDatabaseAction;
import org.bimserver.database.migrations.Migrator;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.QueryInterface;
import org.bimserver.ifc.BasicIfcModel;
import org.bimserver.interfaces.objects.SBimServerInfo;
import org.bimserver.interfaces.objects.SDatabaseInformation;
import org.bimserver.interfaces.objects.SJavaInfo;
import org.bimserver.interfaces.objects.SLogAction;
import org.bimserver.interfaces.objects.SMetrics;
import org.bimserver.interfaces.objects.SMigration;
import org.bimserver.interfaces.objects.SPluginDescriptor;
import org.bimserver.interfaces.objects.SServerInfo;
import org.bimserver.interfaces.objects.SSystemInfo;
import org.bimserver.interfaces.objects.SVersion;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.log.LogAction;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.PluginDescriptor;
import org.bimserver.models.store.RenderEnginePluginConfiguration;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.models.store.UserSettings;
import org.bimserver.models.store.UserType;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.renderengine.RenderEnginePool;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.webservices.SLogComparator;
import org.bimserver.webservices.SMigrationComparator;
import org.bimserver.webservices.SPluginDescriptorComparator;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServiceImpl
extends GenericServiceImpl
implements AdminInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminServiceImpl.class);

    public AdminServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    public Integer clearOutputFileCache() {
        return this.getBimServer().getNewDiskCacheManager().cleanup();
    }

    public SSystemInfo getSystemInfo() {
        SSystemInfo systemInfo = new SSystemInfo();
        systemInfo.setCpucores(Runtime.getRuntime().availableProcessors());
        systemInfo.setDatetime(new GregorianCalendar().getTime());
        systemInfo.setOsname(System.getProperty("os.name"));
        systemInfo.setOsversion(System.getProperty("os.version"));
        systemInfo.setUserName(System.getProperty("user.name"));
        systemInfo.setUserHome(System.getProperty("user.home"));
        systemInfo.setUserDir(System.getProperty("user.dir"));
        return systemInfo;
    }

    public SJavaInfo getJavaInfo() {
        SJavaInfo javaInfo = new SJavaInfo();
        javaInfo.setHeapTotal(Runtime.getRuntime().totalMemory());
        javaInfo.setHeapUsed(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        javaInfo.setHeapFree(Runtime.getRuntime().freeMemory());
        javaInfo.setHeapMax(Runtime.getRuntime().maxMemory());
        javaInfo.setThreads(Thread.activeCount());
        javaInfo.setJavaHome(System.getProperty("java.home"));
        javaInfo.setJavaVersion(System.getProperty("java.version"));
        javaInfo.setJavaVendor(System.getProperty("java.vendor"));
        javaInfo.setJavaVendorurl(System.getProperty("java.vendor.url"));
        javaInfo.setJavavmVersion(System.getProperty("java.vm.version"));
        javaInfo.setJavavmVendor(System.getProperty("java.vm.vendor"));
        javaInfo.setJavavmName(System.getProperty("java.vm.name"));
        javaInfo.setJavaspecVersion(System.getProperty("java.specification.version"));
        javaInfo.setJavaspecVendor(System.getProperty("java.specification.vendor"));
        javaInfo.setJavaspecName(System.getProperty("java.specification.name"));
        javaInfo.setJavaClassVersion(System.getProperty("java.class.version"));
        for (String classp : System.getProperty("java.class.path").split(File.pathSeparator)) {
            javaInfo.getJavaClasspath().add(classp);
        }
        for (String classp : System.getProperty("java.library.path").split(File.pathSeparator)) {
            javaInfo.getJavaLibrarypath().add(classp);
        }
        javaInfo.setJavaIoTmp(System.getProperty("java.io.tmpdir"));
        javaInfo.setJavaExtdir(System.getProperty("java.ext.dirs"));
        javaInfo.setJavaFileSeparator(System.getProperty("file.separator"));
        javaInfo.setJavaPathSeparator(System.getProperty("path.separator"));
        javaInfo.setJavaLineSeparator(System.getProperty("line.separator"));
        return javaInfo;
    }

    public SBimServerInfo getBimServerInfo() throws ServerException, UserException {
        SBimServerInfo bimServerInfo = new SBimServerInfo();
        SVersion version = this.getBimServer().getVersionChecker().getLocalVersion();
        SVersion latestVersion = this.getBimServer().getVersionChecker().getOnlineVersion();
        SDatabaseInformation databaseInformation = this.getDatabaseInformation();
        bimServerInfo.setCurrentVersion(version.getFullString());
        bimServerInfo.setCurrentDate(version.getDate());
        bimServerInfo.setLatestVersion(latestVersion.getMajor() + "." + latestVersion.getMinor() + "." + latestVersion.getRevision());
        bimServerInfo.setLatestDate(latestVersion.getDate());
        bimServerInfo.setCheckouts(databaseInformation.getNumberOfCheckouts().intValue());
        bimServerInfo.setRevisions(databaseInformation.getNumberOfRevisions().intValue());
        bimServerInfo.setUsers(databaseInformation.getNumberOfUsers().intValue());
        bimServerInfo.setProjects(databaseInformation.getNumberOfProjects().intValue());
        bimServerInfo.setSchemaVersion(databaseInformation.getSchemaVersion().intValue());
        bimServerInfo.setServerLogUrl(this.getBimServer().getServerSettingsCache().getServerSettings().getSiteAddress() + "/download?token=" + this.getServiceMap().getAuthorization().asHexToken(this.getBimServer().getEncryptionKey()) + "&action=getfile&type=serverlog");
        bimServerInfo.setStarted(this.getServerStartTime());
        return bimServerInfo;
    }

    public String getServerLog() throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try {
            return FileUtils.readFileToString((File)this.getBimServer().getHomeDir().resolve("logs/bimserver.log").toFile());
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            throw new ServerException((Throwable)e);
        }
    }

    public String getProtocolBuffersFile(String interfaceName) throws ServerException, UserException {
        InputStream resourceAsStream = ProtocolBuffersBimServerClientFactory.class.getResourceAsStream(interfaceName + ".proto");
        StringWriter stringWriter = new StringWriter();
        try {
            IOUtils.copy((InputStream)resourceAsStream, (Writer)stringWriter);
        }
        catch (IOException e) {
            throw new ServerException((Throwable)e);
        }
        return stringWriter.toString();
    }

    public SServerInfo getServerInfo() {
        return this.getBimServer().getSConverter().convertToSObject(this.getBimServer().getServerInfo());
    }

    public SVersion getVersion() throws ServerException, UserException {
        return this.getBimServer().getVersionChecker().getLocalVersion();
    }

    public SVersion getLatestVersion() throws ServerException, UserException {
        return this.getBimServer().getVersionChecker().getOnlineVersion();
    }

    public Boolean upgradePossible() {
        return this.getBimServer().getVersionChecker().updateNeeded();
    }

    public void disablePlugin(String name) throws UserException {
        this.requireAdminAuthenticationAndRunningServer();
        this.getBimServer().getPluginManager().disablePlugin(name);
    }

    public void enablePlugin(String name) throws UserException {
        this.requireAdminAuthenticationAndRunningServer();
        this.getBimServer().getPluginManager().enablePlugin(name);
    }

    public Date getServerStartTime() {
        return this.getBimServer().getServerStartTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastDatabaseReset() throws ServerException, UserException {
        this.requireRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            Date date = session.getCreatedDate();
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(String siteAddress, String serverName, String serverDescription, String serverIcon, String adminName, String adminUsername, String adminPassword) throws ServerException, UserException {
        SettingsInterface settingsInterface = this.getServiceMap().get(SettingsInterface.class);
        if (!siteAddress.startsWith("http://") && !siteAddress.startsWith("https://")) {
            throw new UserException("Site address should start with \"http://\" or \"https://\"");
        }
        if (siteAddress.startsWith("http://http://") || siteAddress.startsWith("https://https://")) {
            throw new UserException("Site address should not have duplicate protocols");
        }
        settingsInterface.setSiteAddress(siteAddress);
        settingsInterface.setServerName(serverName);
        settingsInterface.setServerDescription(serverDescription);
        settingsInterface.setServerIcon(serverIcon);
        if (adminUsername.trim().isEmpty()) {
            throw new UserException("Admin Username cannot be empty");
        }
        if (adminPassword.trim().isEmpty()) {
            throw new UserException("Admin Password cannot be empty");
        }
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            AddUserDatabaseAction addUserDatabaseAction = new AddUserDatabaseAction(this.getBimServer(), session, AccessMethod.INTERNAL, adminUsername, adminPassword, adminName, UserType.ADMIN, this.getAuthorization(), false, "");
            session.executeAndCommitAction(addUserDatabaseAction);
        }
        this.getBimServer().getServerInfoManager().update();
    }

    public List<SMigration> getMigrations() throws UserException {
        Migrator migrator = this.getBimServer().getDatabase().getMigrator();
        ArrayList<SMigration> list = new ArrayList<SMigration>(this.getBimServer().getSConverter().convertToSSetMigration(migrator.getMigrations()));
        Collections.sort(list, new SMigrationComparator());
        return list;
    }

    public void migrateDatabase() throws ServerException, UserException {
        try {
            this.getBimServer().getDatabase().getMigrator().migrate();
            this.getBimServer().getServerInfoManager().update();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new ServerException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SLogAction> getLogs() throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetLogsDatabaseAction action = new GetLogsDatabaseAction(session, this.getInternalAccessMethod(), this.getAuthorization());
            List<LogAction> logs = session.executeAndCommitAction(action);
            List<SLogAction> convertToSListLogAction = this.getBimServer().getSConverter().convertToSListLogAction(logs);
            Collections.sort(convertToSListLogAction, new SLogComparator(true));
            List<SLogAction> list = convertToSListLogAction;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDatabaseInformation getDatabaseInformation() throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetDatabaseInformationAction action = new GetDatabaseInformationAction(session, this.getInternalAccessMethod());
            SDatabaseInformation sDatabaseInformation = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sDatabaseInformation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SPluginDescriptor> getAllPlugins() throws UserException, ServerException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            List<SPluginDescriptor> convertToSListPluginDescriptor = this.getBimServer().getSConverter().convertToSListPluginDescriptor(session.getAllOfType(StorePackage.eINSTANCE.getPluginDescriptor(), PluginDescriptor.class, (QueryInterface)OldQuery.getDefault()));
            Collections.sort(convertToSListPluginDescriptor, new SPluginDescriptorComparator());
            List<SPluginDescriptor> list = convertToSListPluginDescriptor;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regenerateGeometry(Long croid) throws ServerException, UserException {
        LOGGER.info("Regenerating geometry for concrete revision" + croid);
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            session.setOverwriteEnabled(true);
            ConcreteRevision concreteRevision = (ConcreteRevision)session.get(StorePackage.eINSTANCE.getConcreteRevision(), (long)croid, (QueryInterface)OldQuery.getDefault());
            PackageMetaData packageMetaData = this.getBimServer().getMetaDataManager().getPackageMetaData(concreteRevision.getProject().getSchema());
            BasicIfcModel model = new BasicIfcModel(packageMetaData, null);
            session.getMap((IfcModelInterface)model, new OldQuery(packageMetaData, concreteRevision.getProject().getId(), concreteRevision.getId(), -1L));
            User user = (User)session.get(this.getAuthorization().getUoid(), OldQuery.getDefault());
            UserSettings userSettings = user.getUserSettings();
            RenderEnginePluginConfiguration defaultRenderEngine = userSettings.getDefaultRenderEngine();
            if (defaultRenderEngine == null) {
                throw new BimBotsException("No default render engine has been selected for this user");
            }
            RenderEnginePool pool = this.getBimServer().getRenderEnginePools().getRenderEnginePool(model.getPackageMetaData().getSchema(), defaultRenderEngine.getPluginDescriptor().getPluginClassName(), new PluginConfiguration(defaultRenderEngine.getSettings()));
            new GeometryGenerator(this.getBimServer()).generateGeometry(pool, this.getBimServer().getPluginManager(), session, (IfcModelInterface)model, concreteRevision.getProject().getId(), concreteRevision.getId(), true, null);
            session.commit();
        }
    }

    public SMetrics getMetrics() {
        return this.getBimServer().getMetricsRegistry().getMetrics();
    }
}

