/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.ChangePasswordDatabaseAction;
import org.bimserver.database.actions.LoginDatabaseAction;
import org.bimserver.database.actions.LoginUserTokenDatabaseAction;
import org.bimserver.database.actions.RequestPasswordChangeDatabaseAction;
import org.bimserver.database.actions.ValidateUserDatabaseAction;
import org.bimserver.interfaces.objects.SAccessMethod;
import org.bimserver.interfaces.objects.SUser;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.AuthInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;

public class AuthServiceImpl
extends GenericServiceImpl
implements AuthInterface {
    public AuthServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String login(String username, String password) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            LoginDatabaseAction loginDatabaseAction = new LoginDatabaseAction(this.getBimServer(), session, this.getServiceMap(), super.getInternalAccessMethod(), username, password);
            String string = session.executeAndCommitAction(loginDatabaseAction);
            return string;
        }
    }

    public void logout() throws UserException {
        this.requireAuthenticationAndRunningServer();
        this.setAuthorization(null);
    }

    public Boolean isLoggedIn() {
        return this.getAuthorization() != null;
    }

    public SAccessMethod getAccessMethod() {
        return SAccessMethod.valueOf((String)this.getInternalAccessMethod().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loginUserToken(String token) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            LoginUserTokenDatabaseAction loginDatabaseAction = new LoginUserTokenDatabaseAction(this.getBimServer(), session, this.getServiceMap(), super.getInternalAccessMethod(), token);
            String string = session.executeAndCommitAction(loginDatabaseAction);
            return string;
        }
    }

    public SUser getLoggedInUser() throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        return this.getServiceMap().get(ServiceInterface.class).getUserByUoid(Long.valueOf(this.getAuthorization().getUoid()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean changePassword(Long uoid, String oldPassword, String newPassword) throws ServerException, UserException {
        this.requireRealUserAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ChangePasswordDatabaseAction action = new ChangePasswordDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), uoid, oldPassword, newPassword, this.getAuthorization());
            Boolean bl = session.executeAndCommitAction(action);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPasswordChange(String username, String resetUrl, Boolean includeSiteAddress) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            RequestPasswordChangeDatabaseAction action = new RequestPasswordChangeDatabaseAction(session, this.getInternalAccessMethod(), this.getBimServer(), username, resetUrl, includeSiteAddress);
            session.executeAndCommitAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SUser validateAccount(Long uoid, String token, String password) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ValidateUserDatabaseAction action = new ValidateUserDatabaseAction(session, this.getInternalAccessMethod(), uoid, token, password);
            SUser sUser = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sUser;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHash(Long uoid, byte[] hash, byte[] salt) throws ServerException, UserException {
        this.requireAdminAuthentication();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            User user = (User)session.get(uoid, OldQuery.getDefault());
            user.setPasswordHash(hash);
            user.setPasswordSalt(salt);
            session.commit();
        }
    }
}

