/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.changes.AddAttributeChange;
import org.bimserver.changes.AddReferenceChange;
import org.bimserver.changes.CreateObjectChange;
import org.bimserver.changes.RemoveAllReferencesChange;
import org.bimserver.changes.RemoveAttributeChange;
import org.bimserver.changes.RemoveObjectChange;
import org.bimserver.changes.RemoveReferenceChange;
import org.bimserver.changes.SetAttributeChange;
import org.bimserver.changes.SetAttributeChangeAtIndex;
import org.bimserver.changes.SetReferenceChange;
import org.bimserver.changes.SetWrappedAttributeChange;
import org.bimserver.database.Database;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.database.actions.CommitTransactionDatabaseAction;
import org.bimserver.database.actions.CountDatabaseAction;
import org.bimserver.database.actions.GetDataObjectByGuidDatabaseAction;
import org.bimserver.database.actions.GetDataObjectByOidDatabaseAction;
import org.bimserver.database.actions.GetDataObjectsByTypeDatabaseAction;
import org.bimserver.database.actions.GetDataObjectsDatabaseAction;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.QueryInterface;
import org.bimserver.interfaces.objects.SDataObject;
import org.bimserver.models.store.ConcreteRevision;
import org.bimserver.models.store.DataObject;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.LowLevelInterface;
import org.bimserver.webservices.LongTransaction;
import org.bimserver.webservices.NoTransactionException;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowLevelServiceImpl
extends GenericServiceImpl
implements LowLevelInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowLevelServiceImpl.class);

    public LowLevelServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long startTransaction(Long poid) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        DatabaseSession session = this.getBimServer().getDatabase().createSession();
        int pid = -1;
        int rid = -1;
        long roid = -1L;
        try {
            Project project = (Project)session.get(poid, OldQuery.getDefault());
            if (project == null) {
                throw new UserException("No project found with poid " + poid);
            }
            pid = project.getId();
            if (project.getLastRevision() != null) {
                Revision revision = project.getLastRevision();
                ConcreteRevision lastConcreteRevision = revision.getLastConcreteRevision();
                rid = lastConcreteRevision.getId();
                roid = revision.getOid();
            }
            LongTransaction longTransaction = this.getBimServer().getLongTransactionManager().newLongTransaction(this.getBimServer().getMetaDataManager().getPackageMetaData(project.getSchema()), poid, pid, rid, roid);
            Long l = longTransaction.getTid();
            return l;
        }
        catch (Exception e) {
            Long l = (Long)this.handleException(e);
            return l;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long commitTransaction(Long tid, String comment) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        DatabaseSession session = this.getBimServer().getDatabase().createSession();
        LongTransaction longTransaction = this.getBimServer().getLongTransactionManager().get(tid);
        if (longTransaction == null) {
            throw new UserException("No transaction with tid " + tid + " was found");
        }
        CommitTransactionDatabaseAction action = new CommitTransactionDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), this.getAuthorization(), longTransaction, comment);
        try {
            session.executeAndCommitAction(action);
            Long l = action.getRevision().getOid();
            session.close();
            return l;
        }
        catch (BimserverDatabaseException e) {
            try {
                try {
                    LOGGER.error("", (Throwable)e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    session.close();
                }
            }
            catch (NoTransactionException e2) {
                LOGGER.error("", (Throwable)e2);
            }
        }
        return -1L;
    }

    public void abortTransaction(Long tid) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).close();
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void addStringAttribute(Long tid, Long oid, String attributeName, String value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new AddAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void addIntegerAttribute(Long tid, Long oid, String attributeName, Integer value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new AddAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void addDoubleAttribute(Long tid, Long oid, String attributeName, Double value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new AddAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setDoubleAttributes(Long tid, Long oid, String attributeName, List<Double> values) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, values));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setDoubleAttributeAtIndex(Long tid, Long oid, String attributeName, Integer index, Double value) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChangeAtIndex(oid, attributeName, index, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setBooleanAttributeAtIndex(Long tid, Long oid, String attributeName, Integer index, Boolean value) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChangeAtIndex(oid, attributeName, index, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setIntegerAttributes(Long tid, Long oid, String attributeName, List<Integer> values) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, values));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setIntegerAttributeAtIndex(Long tid, Long oid, String attributeName, Integer index, Integer value) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChangeAtIndex(oid, attributeName, index, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setLongAttributes(Long tid, Long oid, String attributeName, List<Long> values) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, values));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setBooleanAttributes(Long tid, Long oid, String attributeName, List<Boolean> values) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, values));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void addBooleanAttribute(Long tid, Long oid, String attributeName, Boolean value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new AddAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void addReference(Long tid, Long oid, String referenceName, Long referenceOid) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new AddReferenceChange(oid, referenceName, referenceOid));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public Long createObject(Long tid, String className, Boolean generateGuid) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            LongTransaction longTransaction = this.getBimServer().getLongTransactionManager().get(tid);
            if (longTransaction == null) {
                throw new UserException("No transaction with tid " + tid + " was found");
            }
            try {
                EClass eClass = ((Database)this.getBimServer().getDatabase()).getEClass(longTransaction.getPackageMetaData().getEPackage().getName(), className);
                Long oid = this.getBimServer().getDatabase().newOid(eClass);
                CreateObjectChange createObject = new CreateObjectChange(className, oid, eClass, generateGuid);
                longTransaction.add(createObject);
                return oid;
            }
            catch (BimserverDatabaseException e) {
                throw new UserException("Unknown type: \"" + className + "\"");
            }
        }
        catch (Exception e) {
            return (Long)this.handleException(e);
        }
    }

    public void removeAttribute(Long tid, Long oid, String attributeName, Integer index) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new RemoveAttributeChange(oid, attributeName, index));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void removeObject(Long tid, Long oid) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new RemoveObjectChange(oid, this.getBimServer().getDatabase().getEClassForOid(oid)));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
        catch (BimserverDatabaseException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    public void removeReference(Long tid, Long oid, String referenceName, Integer index) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new RemoveReferenceChange((long)oid, referenceName, index));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void removeReferenceByOid(Long tid, Long oid, String referenceName, Long referencedOid) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new RemoveReferenceChange((long)oid, referenceName, referencedOid));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void removeAllReferences(Long tid, Long oid, String referenceName) throws ServerException, UserException {
        this.requireAdminAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new RemoveAllReferencesChange(oid, referenceName));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setStringAttribute(Long tid, Long oid, String attributeName, String value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setStringAttributeAtIndex(Long tid, Long oid, String attributeName, Integer index, String value) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChangeAtIndex(oid, attributeName, index, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setWrappedStringAttribute(Long tid, Long oid, String attributeName, String type, String value) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetWrappedAttributeChange(oid, attributeName, type, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public String getStringAttribute(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        return (String)this.getAttribute(tid, oid, attributeName);
    }

    public void setIntegerAttribute(Long tid, Long oid, String attributeName, Integer value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setWrappedIntegerAttribute(Long tid, Long oid, String attributeName, String type, Integer value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetWrappedAttributeChange(oid, attributeName, type, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setByteArrayAttribute(Long tid, Long oid, String attributeName, Byte[] value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setLongAttribute(Long tid, Long oid, String attributeName, Long value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setLongAttributeAtIndex(Long tid, Long oid, String attributeName, Integer index, Long value) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChangeAtIndex(oid, attributeName, index, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setWrappedLongAttribute(Long tid, Long oid, String attributeName, String type, Long value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetWrappedAttributeChange(oid, attributeName, type, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public Integer getIntegerAttribute(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (Integer)this.getAttribute(tid, oid, attributeName);
    }

    public Integer getIntegerAttributeAtIndex(Long tid, Long oid, String attributeName, Integer index) throws ServerException, UserException {
        return (Integer)this.getAttributeAtIndex(tid, oid, attributeName, index);
    }

    public Long getLongAttribute(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (Long)this.getAttribute(tid, oid, attributeName);
    }

    public Long getLongAttributeAtIndex(Long tid, Long oid, String attributeName, Integer index) throws ServerException, UserException {
        return (Long)this.getAttributeAtIndex(tid, oid, attributeName, index);
    }

    public void setBooleanAttribute(Long tid, Long oid, String attributeName, Boolean value) throws UserException, ServerException {
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setWrappedBooleanAttribute(Long tid, Long oid, String attributeName, String type, Boolean value) throws UserException, ServerException {
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetWrappedAttributeChange(oid, attributeName, type, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public Boolean getBooleanAttribute(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (Boolean)this.getAttribute(tid, oid, attributeName);
    }

    public Boolean getBooleanAttributeAtIndex(Long tid, Long oid, String attributeName, Integer index) throws ServerException, UserException {
        return (Boolean)this.getAttributeAtIndex(tid, oid, attributeName, index);
    }

    public void setDoubleAttribute(Long tid, Long oid, String attributeName, Double value) throws UserException, ServerException {
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void setWrappedDoubleAttribute(Long tid, Long oid, String attributeName, String type, Double value) throws UserException, ServerException {
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetWrappedAttributeChange(oid, attributeName, type, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public Double getDoubleAttribute(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (Double)this.getAttribute(tid, oid, attributeName);
    }

    public Double getDoubleAttributeAtIndex(Long tid, Long oid, String attributeName, Integer index) throws ServerException, UserException {
        return (Double)this.getAttributeAtIndex(tid, oid, attributeName, index);
    }

    public List<Double> getDoubleAttributes(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (List)this.getAttribute(tid, oid, attributeName);
    }

    public List<Boolean> getBooleanAttributes(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (List)this.getAttribute(tid, oid, attributeName);
    }

    public byte[] getByteArrayAttribute(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (byte[])this.getAttribute(tid, oid, attributeName);
    }

    public List<byte[]> getByteArrayAttributes(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (List)this.getAttribute(tid, oid, attributeName);
    }

    public List<Integer> getIntegerAttributes(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (List)this.getAttribute(tid, oid, attributeName);
    }

    public List<String> getStringAttributes(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        return (List)this.getAttribute(tid, oid, attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttribute(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            LongTransaction transaction = this.getBimServer().getLongTransactionManager().get(tid);
            EClass eClass = session.getEClassForOid(oid);
            Object object = session.get(eClass, (long)oid, (QueryInterface)new OldQuery(transaction.getPackageMetaData(), transaction.getPid(), transaction.getRid(), transaction.getRoid(), null, OldQuery.Deep.NO));
            if (object == null) {
                throw new UserException("No object of type " + eClass.getName() + " with oid " + oid + " found");
            }
            Object eGet = object.eGet(object.eClass().getEStructuralFeature(attributeName));
            if (eGet instanceof IdEObject) {
                IdEObject refObject = (IdEObject)eGet;
                Object object2 = refObject.eGet(refObject.eClass().getEStructuralFeature("wrappedValue"));
                return object2;
            }
            Object object3 = eGet;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttributeAtIndex(Long tid, Long oid, String attributeName, int index) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            LongTransaction transaction = this.getBimServer().getLongTransactionManager().get(tid);
            EClass eClass = session.getEClassForOid(oid);
            Object object = session.get(eClass, (long)oid, (QueryInterface)new OldQuery(transaction.getPackageMetaData(), transaction.getPid(), transaction.getRid(), transaction.getRoid(), null, OldQuery.Deep.NO));
            if (object == null) {
                throw new UserException("No object of type " + eClass.getName() + " with oid " + oid + " found");
            }
            Object eGet = object.eGet(object.eClass().getEStructuralFeature(attributeName));
            if (eGet instanceof List) {
                List list = (List)eGet;
                Object e = list.get(index);
                return e;
            }
            Object object2 = eGet;
            return object2;
        }
    }

    public void setEnumAttribute(Long tid, Long oid, String attributeName, String value) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, value));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public String getEnumAttribute(Long tid, Long oid, String attributeName) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        return (String)this.getAttribute(tid, oid, attributeName);
    }

    public void setReference(Long tid, Long oid, String referenceName, Long referenceOid) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetReferenceChange(oid, referenceName, referenceOid));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getReference(Long tid, Long oid, String referenceName) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            LongTransaction transaction = this.getBimServer().getLongTransactionManager().get(tid);
            EClass eClass = session.getEClassForOid(oid);
            Object object = session.get(eClass, (long)oid, (QueryInterface)new OldQuery(transaction.getPackageMetaData(), transaction.getPid(), transaction.getRid(), transaction.getRoid(), null, OldQuery.Deep.NO));
            if (object == null) {
                throw new UserException("No object of type " + eClass.getName() + " with oid " + oid + " found");
            }
            EStructuralFeature eStructuralFeature = object.eClass().getEStructuralFeature(referenceName);
            if (eStructuralFeature == null) {
                throw new UserException("No feature with name " + referenceName + " found on class " + object.eClass().getName());
            }
            IdEObject ref = (IdEObject)object.eGet(eStructuralFeature);
            if (ref == null) {
                Long l = -1L;
                return l;
            }
            Long l = ref.getOid();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getReferences(Long tid, Long oid, String referenceName) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            LongTransaction transaction = this.getBimServer().getLongTransactionManager().get(tid);
            EClass eClass = session.getEClassForOid(oid);
            Object object = session.get(eClass, (long)oid, (QueryInterface)new OldQuery(transaction.getPackageMetaData(), transaction.getPid(), transaction.getRid(), transaction.getRoid(), null, OldQuery.Deep.NO));
            if (object == null) {
                throw new UserException("No object of type " + eClass.getName() + " with oid " + oid + " found");
            }
            List list = (List)object.eGet(object.eClass().getEStructuralFeature(referenceName));
            ArrayList<Long> oidList = new ArrayList<Long>();
            for (IdEObject idEObject : list) {
                oidList.add(idEObject.getOid());
            }
            ArrayList<Long> arrayList = oidList;
            return arrayList;
        }
    }

    public void unsetAttribute(Long tid, Long oid, String attributeName) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetAttributeChange(oid, attributeName, null));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    public void unsetReference(Long tid, Long oid, String referenceName) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try {
            this.getBimServer().getLongTransactionManager().get(tid).add(new SetReferenceChange(oid, referenceName, -1L));
        }
        catch (NoTransactionException e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SDataObject> getDataObjects(Long roid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            GetDataObjectsDatabaseAction action = new GetDataObjectsDatabaseAction(session, this.getInternalAccessMethod(), this.getBimServer(), roid, this.getAuthorization());
            List<SDataObject> list = this.getBimServer().getSConverter().convertToSListDataObject((Collection<DataObject>)session.executeAndCommitAction(action));
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDataObject getDataObjectByGuid(Long roid, String guid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SDataObject dataObject;
            GetDataObjectByGuidDatabaseAction action = new GetDataObjectByGuidDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid, guid, this.getAuthorization());
            SDataObject sDataObject = dataObject = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sDataObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SDataObject> getDataObjectsByType(Long roid, String packageName, String className, Boolean flat) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        DatabaseSession session = this.getBimServer().getDatabase().createSession();
        GetDataObjectsByTypeDatabaseAction action = new GetDataObjectsByTypeDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid, packageName, className, this.getAuthorization(), flat);
        try {
            List<SDataObject> list = this.getBimServer().getSConverter().convertToSListDataObject((Collection<DataObject>)session.executeAndCommitAction(action));
            return list;
        }
        catch (Exception e) {
            List list = (List)this.handleException(e);
            return list;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDataObject getDataObjectByOid(Long roid, Long oid) throws ServerException, UserException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SDataObject dataObject;
            GetDataObjectByOidDatabaseAction action = new GetDataObjectByOidDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid, oid, this.getAuthorization());
            SDataObject sDataObject = dataObject = this.getBimServer().getSConverter().convertToSObject(session.executeAndCommitAction(action));
            return sDataObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer count(Long roid, String className) throws UserException, ServerException {
        this.requireAuthenticationAndRunningServer();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            CountDatabaseAction action = new CountDatabaseAction(this.getBimServer(), session, this.getInternalAccessMethod(), roid, className, this.getAuthorization());
            Integer n = session.executeAndCommitAction(action);
            return n;
        }
    }
}

