/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.Schema;
import org.bimserver.interfaces.objects.SFormatSerializerMap;
import org.bimserver.interfaces.objects.SNewServiceDescriptor;
import org.bimserver.interfaces.objects.SSerializerPluginConfiguration;
import org.bimserver.models.store.PluginDescriptor;
import org.bimserver.models.store.Project;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.NewServicesInterface;
import org.bimserver.shared.interfaces.PluginInterface;
import org.bimserver.utils.NetUtils;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewServicesImpl
extends GenericServiceImpl
implements NewServicesInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewServicesImpl.class);

    public NewServicesImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    public List<SNewServiceDescriptor> listAllServiceDescriptors() throws ServerException, UserException {
        try {
            String data = NetUtils.getContent((URL)new URL(this.getBimServer().getServerSettingsCache().getServerSettings().getServiceRepositoryUrl() + "/serviceproviders.json"), (int)5000);
            final ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode servicesJson = (ObjectNode)objectMapper.readValue(data, ObjectNode.class);
            ArrayNode activeServices = (ArrayNode)servicesJson.get("active");
            final List<SNewServiceDescriptor> list = Collections.synchronizedList(new ArrayList());
            ThreadPoolExecutor executor = new ThreadPoolExecutor(activeServices.size(), activeServices.size(), 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(activeServices.size()));
            for (JsonNode activeService : activeServices) {
                final String providerListUrl = activeService.get("listUrl").asText();
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String providerData = NetUtils.getContent((URL)new URL(providerListUrl), (int)5000);
                            ObjectNode provider = (ObjectNode)objectMapper.readValue(providerData, ObjectNode.class);
                            ArrayNode arryaNode = (ArrayNode)provider.get("services");
                            for (JsonNode jsonNode : arryaNode) {
                                SNewServiceDescriptor serviceDescriptor = new SNewServiceDescriptor();
                                if (jsonNode.has("oauth")) {
                                    ObjectNode oauth = (ObjectNode)jsonNode.get("oauth");
                                    serviceDescriptor.setRegisterUrl(oauth.get("registerUrl").asText());
                                    serviceDescriptor.setTokenUrl(oauth.get("tokenUrl").asText());
                                    serviceDescriptor.setAuthorizationUrl(oauth.get("authorizationUrl").asText());
                                }
                                serviceDescriptor.setOid(jsonNode.get("id").asLong());
                                serviceDescriptor.setDescription(jsonNode.get("description").asText());
                                serviceDescriptor.setName(jsonNode.get("name").asText());
                                serviceDescriptor.setProvider(jsonNode.get("provider").asText());
                                serviceDescriptor.setResourceUrl(jsonNode.get("resourceUrl").asText());
                                ArrayNode inputs = (ArrayNode)jsonNode.get("inputs");
                                ArrayNode outputs = (ArrayNode)jsonNode.get("outputs");
                                for (JsonNode inputNode : inputs) {
                                    serviceDescriptor.getInputs().add(inputNode.asText());
                                }
                                for (JsonNode outputNode : outputs) {
                                    serviceDescriptor.getOutputs().add(outputNode.asText());
                                }
                                list.add(serviceDescriptor);
                            }
                        }
                        catch (MalformedURLException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                        catch (ConnectException e) {
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
            return list;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new UserException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SFormatSerializerMap> listAvailableOutputFormats(Long poid) throws ServerException, UserException {
        HashMap<String, SFormatSerializerMap> outputs = new HashMap<String, SFormatSerializerMap>();
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            Project project = (Project)session.get(poid, OldQuery.getDefault());
            try {
                List allSerializersForPoids = this.getServiceMap().get(PluginInterface.class).getAllSerializersForPoids(Boolean.valueOf(true), Collections.singleton(poid));
                for (SSerializerPluginConfiguration pluginConfiguration : allSerializersForPoids) {
                    PluginDescriptor pluginDescriptor = (PluginDescriptor)session.get(pluginConfiguration.getPluginDescriptorId(), OldQuery.getDefault());
                    Plugin plugin = this.getBimServer().getPluginManager().getPlugin(pluginDescriptor.getIdentifier(), true);
                    String outputFormat = null;
                    if (plugin instanceof StreamingSerializerPlugin) {
                        outputFormat = ((StreamingSerializerPlugin)plugin).getOutputFormat(Schema.valueOf((String)project.getSchema().toUpperCase()));
                    }
                    if (outputFormat == null) continue;
                    SFormatSerializerMap map = (SFormatSerializerMap)outputs.get(outputFormat);
                    if (map == null) {
                        map = new SFormatSerializerMap();
                        map.setFormat(outputFormat);
                        outputs.put(outputFormat, map);
                    }
                    map.getSerializers().add(pluginConfiguration);
                }
            }
            catch (ServerException e) {
                e.printStackTrace();
            }
            catch (UserException e) {
                e.printStackTrace();
            }
            ArrayList<SFormatSerializerMap> arrayList = new ArrayList<SFormatSerializerMap>(outputs.values());
            return arrayList;
        }
        catch (BimserverDatabaseException e) {
            return (List)this.handleException((Exception)((Object)e));
        }
    }
}

