/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.QueryInterface;
import org.bimserver.endpoints.EndPoint;
import org.bimserver.interfaces.objects.SLongActionState;
import org.bimserver.interfaces.objects.SProgressTopicType;
import org.bimserver.models.store.ActionState;
import org.bimserver.models.store.LongActionState;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.Revision;
import org.bimserver.models.store.StorePackage;
import org.bimserver.notifications.ChangeProgressTopicOnProjectTopic;
import org.bimserver.notifications.ChangeProgressTopicOnRevisionTopic;
import org.bimserver.notifications.ChangeProgressTopicOnServerTopic;
import org.bimserver.notifications.NewExtendedDataOnRevisionTopic;
import org.bimserver.notifications.NewExtendedDataOnRevisionTopicKey;
import org.bimserver.notifications.NewRevisionOnSpecificProjectTopic;
import org.bimserver.notifications.NewRevisionOnSpecificProjectTopicKey;
import org.bimserver.notifications.NewRevisionTopic;
import org.bimserver.notifications.ProgressNotification;
import org.bimserver.notifications.ProgressOnRevisionTopic;
import org.bimserver.notifications.ProgressTopic;
import org.bimserver.notifications.TopicRegisterException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.NotificationRegistryInterface;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.impl.GenericServiceImpl;
import org.slf4j.LoggerFactory;

public class NotificationRegistryServiceImpl
extends GenericServiceImpl
implements NotificationRegistryInterface {
    public NotificationRegistryServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    public void registerProgressHandler(Long topicId, Long endPointId) throws UserException {
        if (endPointId == null) {
            throw new UserException("No EndpointId given");
        }
        EndPoint endPoint = this.getEndPoint(endPointId);
        if (endPoint == null) {
            throw new UserException("Endpoint with id " + endPointId + " not found");
        }
        ProgressTopic progressTopic = this.getBimServer().getNotificationsManager().getProgressTopic(topicId);
        if (progressTopic == null) {
            throw new UserException("Topic with id " + topicId + " not found");
        }
        try {
            progressTopic.register(endPoint);
            LongActionState lastProgress = progressTopic.getLastProgress();
            if (lastProgress != null && lastProgress.getState() == ActionState.FINISHED) {
                LoggerFactory.getLogger(NotificationRegistryInterface.class).debug("Sending update directly for topic " + progressTopic.getKey().getId());
            } else {
                LoggerFactory.getLogger(NotificationRegistryInterface.class).debug("NOT Sending update directly for topic " + progressTopic.getKey().getId());
            }
        }
        catch (TopicRegisterException e) {
            throw new UserException((Throwable)e);
        }
    }

    private EndPoint getEndPoint(long endPointId) throws UserException {
        EndPoint endPoint = this.getBimServer().getEndPointManager().get(endPointId);
        if (endPoint == null) {
            throw new UserException("Endpoint with id " + endPointId + " not found");
        }
        return endPoint;
    }

    public void unregisterProgressHandler(Long topicId, Long endPointId) throws UserException, ServerException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        ProgressTopic progressTopic = this.getBimServer().getNotificationsManager().getProgressTopic(topicId);
        if (progressTopic == null) {
            throw new UserException("Topic with id " + topicId + " not found");
        }
        try {
            progressTopic.unregister(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgressTopic(Long topicId, SLongActionState state) throws UserException, ServerException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ProgressTopic topic = this.getBimServer().getNotificationsManager().getProgressTopic(topicId);
            ProgressNotification progressNotification = new ProgressNotification(this.getBimServer(), topic, this.getBimServer().getSConverter().convertFromSObject(state));
            this.getBimServer().getNotificationsManager().addToQueue(progressNotification);
        }
    }

    public void registerNewRevisionOnSpecificProjectHandler(Long endPointId, Long poid) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        NewRevisionOnSpecificProjectTopic newRevisionOnSpecificProjectTopic = this.getBimServer().getNotificationsManager().getOrCreateNewRevisionOnSpecificProjectTopic(new NewRevisionOnSpecificProjectTopicKey(poid));
        try {
            newRevisionOnSpecificProjectTopic.register(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void registerNewRevisionHandler(Long endPointId) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        NewRevisionTopic newRevisionTopic = this.getBimServer().getNotificationsManager().getNewRevisionTopic();
        try {
            newRevisionTopic.register(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void registerNewExtendedDataOnRevisionHandler(Long endPointId, Long roid) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        NewExtendedDataOnRevisionTopic topic = this.getBimServer().getNotificationsManager().getOrCreateNewExtendedDataOnRevisionTopic(new NewExtendedDataOnRevisionTopicKey(roid));
        try {
            topic.register(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void unregisterNewRevisionOnSpecificProjectHandler(Long endPointId, Long poid) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            this.getBimServer().getNotificationsManager().getNewRevisionOnSpecificProjectTopic(new NewRevisionOnSpecificProjectTopicKey(poid)).unregister(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void unregisterNewRevisionHandler(Long endPointId) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            this.getBimServer().getNotificationsManager().getNewRevisionTopic().unregister(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void unregisterNewExtendedDataOnRevisionHandler(Long endPointId, Long roid) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            NewExtendedDataOnRevisionTopic newExtendedDataOnRevisionTopic = this.getBimServer().getNotificationsManager().getNewExtendedDataOnRevisionTopic(new NewExtendedDataOnRevisionTopicKey(roid));
            if (newExtendedDataOnRevisionTopic != null) {
                newExtendedDataOnRevisionTopic.unregister(endPoint);
            }
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public Long registerProgressTopic(SProgressTopicType type, String description) throws UserException, ServerException {
        return this.getBimServer().getNotificationsManager().createProgressTopic(type, description).getKey().getId();
    }

    public Long registerProgressOnRevisionTopic(SProgressTopicType type, Long poid, Long roid, String description) throws UserException, ServerException {
        return this.getBimServer().getNotificationsManager().createProgressOnRevisionTopic(poid, roid, type, description).getKey().getId();
    }

    public Long registerProgressOnProjectTopic(SProgressTopicType type, Long poid, String description) throws UserException, ServerException {
        return this.getBimServer().getNotificationsManager().createProgressOnProjectTopic(this.getCurrentUser().getOid(), poid, type, description).getKey().getId();
    }

    public void unregisterProgressTopic(Long topicId) {
        this.getBimServer().getNotificationsManager().unregister(topicId);
    }

    public void registerNewProjectHandler(Long endPointId) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            this.getBimServer().getNotificationsManager().getNewProjectTopic().register(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void unregisterNewProjectHandler(Long endPointId) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            this.getBimServer().getNotificationsManager().getNewProjectTopic().unregister(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void registerNewUserHandler(Long endPointId) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            this.getBimServer().getNotificationsManager().getNewUserTopic().register(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void unregisterNewUserHandler(Long endPointId) throws ServerException, UserException {
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            this.getBimServer().getNotificationsManager().getNewUserTopic().unregister(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getProgressTopicsOnProject(Long poid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            ArrayList<Long> list = new ArrayList<Long>();
            Project project = (Project)session.get(StorePackage.eINSTANCE.getProject(), (long)poid, (QueryInterface)OldQuery.getDefault());
            ArrayList<Long> revisionOids = new ArrayList<Long>();
            for (Revision revision : project.getRevisions()) {
                revisionOids.add(revision.getOid());
            }
            Set<ProgressTopic> progressOnProjectTopics = this.getBimServer().getNotificationsManager().getProgressOnProjectTopics(poid, revisionOids);
            if (progressOnProjectTopics != null) {
                for (ProgressTopic topic : progressOnProjectTopics) {
                    list.add(topic.getKey().getId());
                }
            }
            ArrayList<Long> arrayList = list;
            return arrayList;
        }
    }

    public List<Long> getProgressTopicsOnRevision(Long poid, Long roid) {
        ArrayList<Long> list = new ArrayList<Long>();
        Set<ProgressOnRevisionTopic> progressOnRevisionTopics = this.getBimServer().getNotificationsManager().getProgressOnRevisionTopics(poid, roid);
        if (progressOnRevisionTopics != null) {
            for (ProgressOnRevisionTopic topic : progressOnRevisionTopics) {
                list.add(topic.getKey().getId());
            }
        }
        return list;
    }

    public List<Long> getProgressTopicsOnServer() {
        ArrayList<Long> list = new ArrayList<Long>();
        for (ProgressTopic topic : this.getBimServer().getNotificationsManager().getProgressOnServerTopics()) {
            list.add(topic.getKey().getId());
        }
        return list;
    }

    public SLongActionState getProgress(Long topicId) throws UserException, ServerException {
        ProgressTopic progressTopic = this.getBimServer().getNotificationsManager().getProgressTopic(topicId);
        if (progressTopic != null) {
            return this.getBimServer().getSConverter().convertToSObject(progressTopic.getLastProgress());
        }
        throw new UserException("No topic found with topicId " + topicId);
    }

    public void registerChangeProgressOnProject(Long endPointId, Long poid) throws ServerException, UserException {
        if (endPointId == null) {
            throw new UserException("No endpoint given");
        }
        ChangeProgressTopicOnProjectTopic changeProgressOnProjectTopic = this.getBimServer().getNotificationsManager().getChangeProgressOnProjectTopic(poid);
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            changeProgressOnProjectTopic.register(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void registerChangeProgressOnServer(Long endPointId) throws ServerException, UserException {
        ChangeProgressTopicOnServerTopic changeProgressTopicOnServerTopic = this.getBimServer().getNotificationsManager().getChangeProgressTopicOnServerTopic();
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            changeProgressTopicOnServerTopic.register(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void unregisterChangeProgressOnServer(Long endPointId) throws ServerException, UserException {
        ChangeProgressTopicOnServerTopic changeProgressTopicOnServerTopic = this.getBimServer().getNotificationsManager().getChangeProgressTopicOnServerTopic();
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            changeProgressTopicOnServerTopic.unregister(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void registerChangeProgressOnRevision(Long endPointId, Long poid, Long roid) throws ServerException, UserException {
        ChangeProgressTopicOnRevisionTopic changeProgressOnProjectTopic = this.getBimServer().getNotificationsManager().getChangeProgressOnRevisionTopic(poid, roid);
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            changeProgressOnProjectTopic.register(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void unregisterChangeProgressOnProject(Long endPointId, Long poid) throws ServerException, UserException {
        ChangeProgressTopicOnProjectTopic changeProgressOnProjectTopic = this.getBimServer().getNotificationsManager().getChangeProgressOnProjectTopic(poid);
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            changeProgressOnProjectTopic.unregister(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }

    public void unregisterChangeProgressOnRevision(Long endPointId, Long poid, Long roid) throws ServerException, UserException {
        ChangeProgressTopicOnRevisionTopic changeProgressOnProjectTopic = this.getBimServer().getNotificationsManager().getChangeProgressOnRevisionTopic(poid, roid);
        EndPoint endPoint = this.getEndPoint(endPointId);
        try {
            changeProgressOnProjectTopic.unregister(endPoint);
        }
        catch (TopicRegisterException e) {
            this.handleException(e);
        }
    }
}

