/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.apache.oltu.oauth2.ext.dynamicreg.client.OAuthRegistrationClient;
import org.apache.oltu.oauth2.ext.dynamicreg.client.request.OAuthClientRegistrationRequest;
import org.apache.oltu.oauth2.ext.dynamicreg.client.response.OAuthClientRegistrationResponse;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseSession;
import org.bimserver.database.OldQuery;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.QueryInterface;
import org.bimserver.interfaces.objects.SAuthorization;
import org.bimserver.interfaces.objects.SOAuthAuthorizationCode;
import org.bimserver.interfaces.objects.SOAuthServer;
import org.bimserver.interfaces.objects.SRunServiceAuthorization;
import org.bimserver.interfaces.objects.SSingleProjectAuthorization;
import org.bimserver.models.store.Authorization;
import org.bimserver.models.store.InternalServicePluginConfiguration;
import org.bimserver.models.store.NewService;
import org.bimserver.models.store.OAuthAuthorizationCode;
import org.bimserver.models.store.OAuthServer;
import org.bimserver.models.store.Project;
import org.bimserver.models.store.ServerSettings;
import org.bimserver.models.store.ServiceStatus;
import org.bimserver.models.store.SingleProjectAuthorization;
import org.bimserver.models.store.StorePackage;
import org.bimserver.models.store.User;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.OAuthInterface;
import org.bimserver.utils.NetUtils;
import org.bimserver.webservices.ServiceMap;
import org.bimserver.webservices.authorization.RunServiceAuthorization;
import org.bimserver.webservices.impl.GenericServiceImpl;
import org.bimserver.webservices.impl.URLConnectionClient;

public class OAuthServiceImpl
extends GenericServiceImpl
implements OAuthInterface {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public OAuthServiceImpl(ServiceMap serviceMap) {
        super(serviceMap);
    }

    public SOAuthServer registerRemoteApplication(String redirectUrl, String name, String description) throws UserException {
        try {
            OAuthClientRequest request = OAuthClientRegistrationRequest.location((String)(this.getBimServer().getServerSettingsCache().getServerSettings().getSiteAddress() + "/oauth/register/"), (String)"push").setName(name).setUrl(redirectUrl).setDescription(description).setRedirectURL(redirectUrl).buildJSONMessage();
            OAuthRegistrationClient oauthclient = new OAuthRegistrationClient((HttpClient)new URLConnectionClient());
            OAuthClientRegistrationResponse response = oauthclient.clientInfo(request);
            SOAuthServer server = new SOAuthServer();
            server.setClientId(response.getClientId());
            server.setClientSecret(response.getClientSecret());
            return server;
        }
        catch (Exception e) {
            throw new UserException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long registerApplication(String registrationEndpoint, String apiUrl, String redirectUrl) throws UserException, ServerException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            OAuthServer oAuthServer = (OAuthServer)session.querySingle(StorePackage.eINSTANCE.getOAuthServer_RegistrationEndpoint(), registrationEndpoint);
            if (oAuthServer != null) {
                Long l2 = oAuthServer.getOid();
                return l2;
            }
            ServerSettings serverSettings = this.getBimServer().getServerSettingsCache().getServerSettings();
            OAuthClientRequest request = OAuthClientRegistrationRequest.location((String)registrationEndpoint, (String)"push").setName(serverSettings.getName()).setUrl(redirectUrl).setDescription(serverSettings.getDescription()).setIcon(serverSettings.getIcon()).setRedirectURL(redirectUrl).buildJSONMessage();
            OAuthRegistrationClient oauthclient = new OAuthRegistrationClient((HttpClient)new URLConnectionClient());
            OAuthClientRegistrationResponse response = oauthclient.clientInfo(request);
            oAuthServer = session.create(OAuthServer.class);
            oAuthServer.setApiUrl(apiUrl);
            oAuthServer.setClientId(response.getClientId());
            oAuthServer.setClientSecret(response.getClientSecret());
            oAuthServer.setIssuedAt(new Date(Long.parseLong(response.getIssuedAt())));
            GregorianCalendar expiresAt = new GregorianCalendar();
            expiresAt.setTimeInMillis(new GregorianCalendar().getTimeInMillis() + response.getExpiresIn());
            oAuthServer.setExpiresAt(expiresAt.getTime());
            oAuthServer.setRegistrationEndpoint(registrationEndpoint);
            oAuthServer.setClientDescription(serverSettings.getDescription());
            oAuthServer.setClientName(serverSettings.getName());
            if (serverSettings.getIcon() != null) {
                byte[] icon = NetUtils.getContentAsBytes((URL)new URL(serverSettings.getIcon()), (int)500);
                oAuthServer.setClientIcon(icon);
            }
            oAuthServer.setIncoming(false);
            oAuthServer.setRedirectUrl(redirectUrl);
            session.commit();
            Long l = oAuthServer.getOid();
            return l;
        }
        catch (Exception e) {
            return (Long)this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String generateForwardUrl(String registrationEndpoint, String authorizeUrl, String returnUrl) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            OAuthServer oAuthServer = (OAuthServer)session.querySingle(StorePackage.eINSTANCE.getOAuthServer_RegistrationEndpoint(), registrationEndpoint);
            if (oAuthServer == null) {
                throw new UserException("Application not registered");
            }
            OAuthClientRequest request2 = OAuthClientRequest.authorizationLocation((String)authorizeUrl).setParameter("auth_type", "service").setClientId(oAuthServer.getClientId()).setRedirectURI(returnUrl).setResponseType(ResponseType.CODE.toString()).setState("state").buildQueryMessage();
            String string = request2.getLocationUri();
            return string;
        }
        catch (Exception e) {
            return (String)this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SOAuthServer> listRegisteredServers() throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            List<OAuthServer> allOfType = session.getAllOfType(StorePackage.eINSTANCE.getOAuthServer(), OAuthServer.class, (QueryInterface)OldQuery.getDefault());
            Iterator<OAuthServer> iterator = allOfType.iterator();
            while (iterator.hasNext()) {
                OAuthServer next = iterator.next();
                if (!next.isIncoming()) continue;
                iterator.remove();
            }
            List<SOAuthServer> list = this.getBimServer().getSConverter().convertToSListOAuthServer(allOfType);
            return list;
        }
        catch (BimserverDatabaseException e) {
            return (List)this.handleException((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SOAuthServer> listRegisteredServersLocal() throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            List<OAuthServer> allOfType = session.getAllOfType(StorePackage.eINSTANCE.getOAuthServer(), OAuthServer.class, (QueryInterface)OldQuery.getDefault());
            Iterator<OAuthServer> iterator = allOfType.iterator();
            while (iterator.hasNext()) {
                OAuthServer next = iterator.next();
                if (next.isIncoming()) continue;
                iterator.remove();
            }
            List<SOAuthServer> list = this.getBimServer().getSConverter().convertToSListOAuthServer(allOfType);
            return list;
        }
        catch (BimserverDatabaseException e) {
            return (List)this.handleException((Exception)((Object)e));
        }
    }

    public void setAuthorizationCode(Long applicationId, String code) throws UserException, ServerException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            OAuthAuthorizationCode oAuthAuthorizationCode = session.create(OAuthAuthorizationCode.class);
            OAuthServer server = (OAuthServer)session.get(applicationId, OldQuery.getDefault());
            oAuthAuthorizationCode.setOauthServer(server);
            oAuthAuthorizationCode.setCode(code);
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            user.getOAuthAuthorizationCodes().add((Object)oAuthAuthorizationCode);
            session.store((IdEObject)user);
            session.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SOAuthAuthorizationCode> listAuthorizationCodes() throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            List<SOAuthAuthorizationCode> list = this.getBimServer().getSConverter().convertToSListOAuthAuthorizationCode((Collection<OAuthAuthorizationCode>)user.getOAuthAuthorizationCodes());
            return list;
        }
        catch (Exception e) {
            return (List)this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SOAuthAuthorizationCode> listIssuedAuthorizationCodes() throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            User user = (User)session.get(StorePackage.eINSTANCE.getUser(), this.getAuthorization().getUoid(), (QueryInterface)OldQuery.getDefault());
            List<SOAuthAuthorizationCode> list = this.getBimServer().getSConverter().convertToSListOAuthAuthorizationCode((Collection<OAuthAuthorizationCode>)user.getOAuthIssuedAuthorizationCodes());
            return list;
        }
        catch (Exception e) {
            return (List)this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SOAuthServer getOAuthServerById(Long oid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            OAuthServer oAuthServer = (OAuthServer)session.get(oid, OldQuery.getDefault());
            SOAuthServer sOAuthServer = this.getBimServer().getSConverter().convertToSObject(oAuthServer);
            return sOAuthServer;
        }
        catch (Exception e) {
            return (SOAuthServer)this.handleException(e);
        }
    }

    public void revokeApplication(Long oid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            OAuthServer oAuthServer = (OAuthServer)session.get(oid, OldQuery.getDefault());
            session.delete((IdEObject)oAuthServer, -1);
            session.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void revokeAuthorization(Long oid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            OAuthAuthorizationCode code = (OAuthAuthorizationCode)session.get(oid, OldQuery.getDefault());
            User user = (User)session.get(this.getCurrentUser().getOid(), OldQuery.getDefault());
            user.getOAuthIssuedAuthorizationCodes().remove((Object)code);
            session.store((IdEObject)user);
            session.delete((IdEObject)code, -1);
            session.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String authorize(Long oAuthServerOid, SAuthorization authorization) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            if (authorization instanceof SSingleProjectAuthorization) {
                User user = (User)session.get(this.getCurrentUser().getOid(), OldQuery.getDefault());
                SSingleProjectAuthorization sSingleProjectAuthorization = (SSingleProjectAuthorization)authorization;
                SingleProjectAuthorization singleProjectAuthorization = session.create(SingleProjectAuthorization.class);
                Project project = (Project)session.get(sSingleProjectAuthorization.getProjectId(), OldQuery.getDefault());
                if (project == null) {
                    throw new UserException("No project found with poid " + sSingleProjectAuthorization.getProjectId());
                }
                singleProjectAuthorization.setProject(project);
                OAuthAuthorizationCode code = session.create(OAuthAuthorizationCode.class);
                org.bimserver.webservices.authorization.SingleProjectAuthorization auth = new org.bimserver.webservices.authorization.SingleProjectAuthorization(this.getBimServer(), user.getOid(), project.getOid());
                String asHexToken = auth.asHexToken(this.getBimServer().getEncryptionKey());
                code.setCode(asHexToken);
                code.setOauthServer((OAuthServer)session.get(oAuthServerOid, OldQuery.getDefault()));
                code.setAuthorization((Authorization)singleProjectAuthorization);
                code.setUser(user);
                user.getOAuthIssuedAuthorizationCodes().add((Object)code);
                session.store((IdEObject)user);
                session.store((IdEObject)singleProjectAuthorization);
                session.commit();
                String string = code.getCode();
                return string;
            }
            if (authorization instanceof SRunServiceAuthorization) {
                SRunServiceAuthorization serviceAuthorization = (SRunServiceAuthorization)authorization;
                User user = (User)session.get(this.getCurrentUser().getOid(), OldQuery.getDefault());
                org.bimserver.models.store.RunServiceAuthorization runServiceAuth = session.create(org.bimserver.models.store.RunServiceAuthorization.class);
                InternalServicePluginConfiguration conf = (InternalServicePluginConfiguration)session.get(serviceAuthorization.getServiceId(), OldQuery.getDefault());
                if (conf == null) {
                    throw new UserException("No service found with soid " + serviceAuthorization.getServiceId());
                }
                runServiceAuth.setService(conf);
                OAuthAuthorizationCode code = session.create(OAuthAuthorizationCode.class);
                RunServiceAuthorization auth = new RunServiceAuthorization(this.getBimServer(), user.getOid(), conf.getOid());
                String asHexToken = auth.asHexToken(this.getBimServer().getEncryptionKey());
                code.setCode(asHexToken);
                code.setOauthServer((OAuthServer)session.get(oAuthServerOid, OldQuery.getDefault()));
                code.setAuthorization((Authorization)runServiceAuth);
                code.setUser(user);
                user.getOAuthIssuedAuthorizationCodes().add((Object)code);
                session.store((IdEObject)user);
                session.store((IdEObject)code);
                session.store((IdEObject)runServiceAuth);
                session.commit();
                String string = code.getCode();
                return string;
            }
            throw new UserException("Unimplemented type of authorization " + authorization.getClass().getSimpleName());
        }
        catch (Exception e) {
            return (String)this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SAuthorization getAuthorizationById(Long oid) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            SAuthorization sAuthorization = this.getBimServer().getSConverter().convertToSObject((Authorization)session.get(oid, OldQuery.getDefault()));
            return sAuthorization;
        }
        catch (Exception e) {
            return (SAuthorization)this.handleException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SOAuthServer getOAuthServerByClientId(String clientId) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            OAuthServer oAuthServer = (OAuthServer)session.querySingle(StorePackage.eINSTANCE.getOAuthServer_ClientId(), clientId);
            SOAuthServer sOAuthServer = this.getBimServer().getSConverter().convertToSObject(oAuthServer);
            return sOAuthServer;
        }
        catch (Exception e) {
            return (SOAuthServer)this.handleException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRemoteToken(Long soid, String code, Long serverId) throws ServerException, UserException {
        try (DatabaseSession session = this.getBimServer().getDatabase().createSession();){
            block18: {
                NewService newService = (NewService)session.get(soid, OldQuery.getDefault());
                ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
                objectNode.put("grant_type", "authorization_code");
                objectNode.put("code", code);
                OAuthServer oAuthServer = (OAuthServer)session.get(serverId, OldQuery.getDefault());
                objectNode.put("client_id", oAuthServer.getClientId());
                objectNode.put("client_secret", oAuthServer.getClientSecret());
                CloseableHttpClient httpclient = HttpClients.createDefault();
                HttpPost post = new HttpPost(newService.getTokenUrl());
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("grant_type", "authorization_code"));
                nvps.add(new BasicNameValuePair("code", code));
                nvps.add(new BasicNameValuePair("client_id", oAuthServer.getClientId()));
                nvps.add(new BasicNameValuePair("client_secret", oAuthServer.getClientSecret()));
                nvps.add(new BasicNameValuePair("redirect_uri", "crap"));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
                CloseableHttpResponse httpResponse = httpclient.execute((HttpUriRequest)post);
                ObjectNode response = (ObjectNode)OBJECT_MAPPER.readValue(httpResponse.getEntity().getContent(), ObjectNode.class);
                if (!response.has("access_token")) break block18;
                String accessToken = response.get("access_token").asText();
                newService.setAccessToken(accessToken);
                newService.setStatus(ServiceStatus.AUTHENTICATED);
                newService.setResourceUrl(response.get("resource_url").asText());
                session.store((IdEObject)newService);
                session.commit();
                String string = accessToken;
                {
                    catch (Throwable throwable2) {
                        httpclient.close();
                        throw throwable2;
                    }
                }
                httpclient.close();
                return string;
            }
            throw new UserException("No access_token received from oauth server");
        }
        catch (Exception e) {
            return (String)this.handleException(e);
        }
    }
}

