/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.webservices.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.bimserver.utils.MultiplexingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartableInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestartableInputStream.class);
    private Path cachingFile;
    private InputStream currentInputStream;
    private volatile boolean canRestart = false;
    private OutputStream outputStream;

    public RestartableInputStream(InputStream originalInputStream, Path file) {
        this.cachingFile = file;
        try {
            this.outputStream = Files.newOutputStream(file, new OpenOption[0]);
            this.currentInputStream = new MultiplexingInputStream(originalInputStream, this.outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.currentInputStream.read(b, off, len);
        if (read == -1) {
            this.canRestart = true;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        int read = this.currentInputStream.read();
        if (read == -1) {
            this.canRestart = true;
        }
        return read;
    }

    public void restartIfAtEnd() throws IOException {
        if (this.canRestart) {
            this.outputStream.close();
            LOGGER.info("Switching to reading from cached file");
            this.currentInputStream = Files.newInputStream(this.cachingFile, new OpenOption[0]);
            this.canRestart = false;
        }
    }
}

