/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.bimserver.client.AnonymousAuthentication;
import org.bimserver.client.Channel;
import org.bimserver.client.ClientIfcModel;
import org.bimserver.client.notifications.NotificationsManager;
import org.bimserver.database.queries.om.DefaultQueries;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.interfaces.objects.SActionState;
import org.bimserver.interfaces.objects.SLongActionState;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.interfaces.objects.SSerializerPluginConfiguration;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.plugins.services.Flow;
import org.bimserver.plugins.services.Geometry;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.AutologinAuthenticationInfo;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.ConnectDisconnectListener;
import org.bimserver.shared.ServiceHolder;
import org.bimserver.shared.SystemAuthentication;
import org.bimserver.shared.TokenAuthentication;
import org.bimserver.shared.TokenChangeListener;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.UserTokenAuthentication;
import org.bimserver.shared.UsernamePasswordAuthenticationInfo;
import org.bimserver.shared.exceptions.BimServerClientException;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.AuthInterface;
import org.bimserver.shared.interfaces.LowLevelInterface;
import org.bimserver.shared.interfaces.MetaInterface;
import org.bimserver.shared.interfaces.NewServicesInterface;
import org.bimserver.shared.interfaces.NotificationInterface;
import org.bimserver.shared.interfaces.NotificationRegistryInterface;
import org.bimserver.shared.interfaces.PluginInterface;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.interfaces.RemoteServiceInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BimServerClient
implements ConnectDisconnectListener,
TokenHolder,
ServiceHolder,
BimServerClientInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(BimServerClient.class);
    private final Set<ConnectDisconnectListener> connectDisconnectListeners = new HashSet<ConnectDisconnectListener>();
    private final Set<TokenChangeListener> tokenChangeListeners = new HashSet<TokenChangeListener>();
    private final Channel channel;
    private final SServicesMap servicesMap;
    private final NotificationsManager notificationsManager;
    private final String baseAddress;
    private AuthenticationInfo authenticationInfo = new AnonymousAuthentication();
    private String token;
    private MetaDataManager metaDataManager;
    private long binaryGeometryMessagingStreamingSerializer = -1L;

    public BimServerClient(MetaDataManager metaDataManager, String baseAddress, SServicesMap servicesMap, Channel channel) {
        this.metaDataManager = metaDataManager;
        this.baseAddress = baseAddress;
        this.servicesMap = servicesMap;
        this.channel = channel;
        this.notificationsManager = new NotificationsManager(this);
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public void setAuthentication(AuthenticationInfo authenticationInfo) throws ServerException, UserException, ChannelConnectionException {
        this.authenticationInfo = authenticationInfo;
        this.connect();
    }

    public void connect() throws ServerException, UserException, ChannelConnectionException {
        this.disconnect();
        this.channel.registerConnectDisconnectListener(this);
        this.channel.connect(this);
        this.authenticate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void authenticate() throws ServerException, UserException {
        try {
            AuthInterface authInterface = this.channel.get(AuthInterface.class);
            if (this.authenticationInfo instanceof UsernamePasswordAuthenticationInfo) {
                UsernamePasswordAuthenticationInfo usernamePasswordAuthenticationInfo = (UsernamePasswordAuthenticationInfo)this.authenticationInfo;
                this.setToken(authInterface.login(usernamePasswordAuthenticationInfo.getUsername(), usernamePasswordAuthenticationInfo.getPassword()));
                return;
            }
            if (this.authenticationInfo instanceof AutologinAuthenticationInfo) {
                AutologinAuthenticationInfo autologinAuthenticationInfo = (AutologinAuthenticationInfo)this.authenticationInfo;
                this.setToken(autologinAuthenticationInfo.getAutologinCode());
                return;
            }
            if (this.authenticationInfo instanceof TokenAuthentication) {
                TokenAuthentication tokenAuthentication = (TokenAuthentication)this.authenticationInfo;
                this.setToken(tokenAuthentication.getToken());
                return;
            }
            if (this.authenticationInfo instanceof UserTokenAuthentication) {
                UserTokenAuthentication tokenAuthentication = (UserTokenAuthentication)this.authenticationInfo;
                this.setToken(authInterface.loginUserToken(tokenAuthentication.getToken()));
                return;
            }
            if (!(this.authenticationInfo instanceof SystemAuthentication)) return;
        }
        catch (PublicInterfaceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void registerConnectDisconnectListener(ConnectDisconnectListener connectDisconnectListener) {
        this.connectDisconnectListeners.add(connectDisconnectListener);
    }

    public void notifyOfConnect() {
        for (ConnectDisconnectListener connectDisconnectListener : this.connectDisconnectListeners) {
            connectDisconnectListener.connected();
        }
    }

    public void notifyOfDisconnect() {
        for (ConnectDisconnectListener connectDisconnectListener : this.connectDisconnectListeners) {
            connectDisconnectListener.disconnected();
        }
    }

    public void disconnect() {
        if (this.notificationsManager != null) {
            this.notificationsManager.disconnect();
        }
        this.channel.disconnect();
    }

    public void connected() {
        try {
            this.authenticate();
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        if (this.token != null) {
            this.notifyOfConnect();
        }
    }

    public void disconnected() {
        this.notifyOfDisconnect();
    }

    public ClientIfcModel getModel(SProject project, long roid, boolean deep, boolean recordChanges) throws BimServerClientException, UserException, ServerException, PublicInterfaceNotFoundException {
        if (roid == -1L) {
            throw new UserException("Roid cannot be -1");
        }
        return new ClientIfcModel(this, project.getOid(), roid, deep, this.getMetaDataManager().getPackageMetaData(project.getSchema()), recordChanges, false);
    }

    public ClientIfcModel getModel(SProject project, long roid, boolean deep, boolean recordChanges, boolean includeGeometry) throws UserException, ServerException {
        if (roid == -1L) {
            throw new UserException("Roid cannot be -1");
        }
        return new ClientIfcModel(this, project.getOid(), roid, deep, this.getMetaDataManager().getPackageMetaData(project.getSchema()), recordChanges, includeGeometry);
    }

    public boolean isConnected() {
        return this.token != null;
    }

    public void unregisterNotificationListener(NotificationInterface notificationInterface) {
        this.notificationsManager.unregisterNotifictionListener(notificationInterface);
    }

    public NotificationInterface getNotificationInterface() throws PublicInterfaceNotFoundException {
        return this.get(NotificationInterface.class);
    }

    public RemoteServiceInterface getRemoteServiceInterface() throws PublicInterfaceNotFoundException {
        return this.get(RemoteServiceInterface.class);
    }

    public LowLevelInterface getLowLevelInterface() throws PublicInterfaceNotFoundException {
        return this.get(LowLevelInterface.class);
    }

    public ServiceInterface getServiceInterface() throws PublicInterfaceNotFoundException {
        return this.get(ServiceInterface.class);
    }

    public AdminInterface getAdminInterface() throws PublicInterfaceNotFoundException {
        return this.get(AdminInterface.class);
    }

    public AuthInterface getAuthInterface() throws PublicInterfaceNotFoundException {
        return this.get(AuthInterface.class);
    }

    public SettingsInterface getSettingsInterface() throws PublicInterfaceNotFoundException {
        return this.get(SettingsInterface.class);
    }

    public PluginInterface getPluginInterface() throws PublicInterfaceNotFoundException {
        return this.get(PluginInterface.class);
    }

    public SServicesMap getServicesMap() {
        return this.servicesMap;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
        for (TokenChangeListener tokenChangeListener : this.tokenChangeListeners) {
            tokenChangeListener.newToken(token);
        }
    }

    public void registerTokenChangeListener(TokenChangeListener tokenChangeListener) {
        this.tokenChangeListeners.add(tokenChangeListener);
    }

    public long checkin(long poid, String comment, long deserializerOid, boolean merge, Flow flow, Path file) throws IOException, UserException, ServerException {
        FileInputStream fis = new FileInputStream(file.toFile());
        long result = this.checkin(poid, comment, deserializerOid, merge, flow, file.toFile().length(), file.getFileName().toString(), fis);
        if (flow == Flow.SYNC) {
            fis.close();
        }
        return result;
    }

    public long checkin(long poid, String comment, long deserializerOid, boolean merge, Flow flow, long fileSize, String filename, InputStream inputStream) throws UserException, ServerException {
        return this.channel.checkin(this.baseAddress, this.token, poid, comment, deserializerOid, merge, flow, fileSize, filename, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long checkin(long poid, String comment, long deserializerOid, boolean merge, Flow flow, URL url) throws UserException, ServerException {
        long l;
        InputStream openStream = url.openStream();
        if (flow != Flow.SYNC) return this.channel.checkin(this.baseAddress, this.token, poid, comment, deserializerOid, merge, flow, -1L, url.toString(), openStream);
        try {
            long topicId = this.channel.checkin(this.baseAddress, this.token, poid, comment, deserializerOid, merge, flow, -1L, url.toString(), openStream);
            SLongActionState progress = this.getNotificationRegistryInterface().getProgress(Long.valueOf(topicId));
            if (progress.getState() == SActionState.AS_ERROR) {
                throw new UserException(Joiner.on((String)", ").join((Iterable)progress.getErrors()));
            }
            l = topicId;
        }
        catch (Throwable throwable) {
            try {
                openStream.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1L;
            }
        }
        openStream.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(long roid, long serializerOid, OutputStream outputStream) throws BimServerClientException {
        try {
            Long topicId = this.getServiceInterface().download(Collections.singleton(roid), DefaultQueries.allAsString(), Long.valueOf(serializerOid), Boolean.valueOf(false));
            SLongActionState progress = this.getNotificationRegistryInterface().getProgress(topicId);
            if (progress != null && progress.getState() == SActionState.AS_ERROR) {
                throw new BimServerClientException(Joiner.on((String)", ").join((Iterable)progress.getErrors()));
            }
            try (InputStream inputStream = this.getDownloadData(topicId);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                this.getServiceInterface().cleanupLongAction(topicId);
            }
        }
        catch (ServerException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UserException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (PublicInterfaceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(long roid, long serializerOid, Path file) throws IOException, BimServerClientException {
        try (FileOutputStream outputStream = new FileOutputStream(file.toFile());){
            this.download(roid, serializerOid, outputStream);
        }
    }

    public void download(long roid, Query query, long serializerOid, Path file) throws IOException, BimServerClientException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(long roid, String query, long serializerOid, Path file) throws ServerException, UserException, PublicInterfaceNotFoundException, IOException {
        Long topicId = this.getServiceInterface().download(Collections.singleton(roid), query, Long.valueOf(serializerOid), Boolean.valueOf(false));
        InputStream downloadData = this.getDownloadData(topicId);
        FileOutputStream fos = new FileOutputStream(file.toFile());
        try {
            IOUtils.copy((InputStream)downloadData, (OutputStream)fos);
        }
        finally {
            downloadData.close();
            fos.close();
        }
    }

    public InputStream getDownloadData(long topicId) throws IOException {
        return this.channel.getDownloadData(this.baseAddress, this.token, topicId);
    }

    public IfcModelInterface newModel(SProject project, boolean recordChanges) throws ServerException, UserException, BimServerClientException, PublicInterfaceNotFoundException {
        return new ClientIfcModel(this, project.getOid(), -1L, false, this.getMetaDataManager().getPackageMetaData(project.getSchema()), recordChanges, false);
    }

    public <T extends PublicInterface> T get(Class<T> clazz) throws PublicInterfaceNotFoundException {
        T t = this.channel.get(clazz);
        if (t == null) {
            throw new PublicInterfaceNotFoundException("No interface of type " + clazz.getSimpleName() + " registered on this channel");
        }
        return t;
    }

    public MetaInterface getMeta() throws PublicInterfaceNotFoundException {
        return this.channel.getMeta();
    }

    public NotificationRegistryInterface getRegistry() throws PublicInterfaceNotFoundException {
        return this.channel.getRegistry();
    }

    public AuthInterface getBimServerAuthInterface() throws PublicInterfaceNotFoundException {
        return this.channel.getBimServerAuthInterface();
    }

    public void commit(IfcModelInterface model, String comment) {
        if (model instanceof ClientIfcModel) {
            try {
                ((ClientIfcModel)model).commit(comment);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public NotificationsManager getNotificationsManager() {
        if (!this.notificationsManager.isRunning()) {
            this.notificationsManager.connect(this.servicesMap, StringUtils.stripHttps((String)this.baseAddress));
            this.notificationsManager.startAndWaitForInit();
        }
        return this.notificationsManager;
    }

    public Geometry getGeometry(long roid, IdEObject ifcProduct) {
        try {
            SSerializerPluginConfiguration serializerByPluginClassName = this.getPluginInterface().getSerializerByPluginClassName("org.bimserver.serializers.binarygeometry.BinaryGeometrySerializerPlugin");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.download(roid, serializerByPluginClassName.getOid(), outputStream);
            Files.write(Paths.get("bin.bin", new String[0]), outputStream.toByteArray(), new OpenOption[0]);
            ByteArrayInputStream bain = new ByteArrayInputStream(outputStream.toByteArray());
            return new Geometry((InputStream)bain, ifcProduct.getOid());
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (UserException e) {
            e.printStackTrace();
        }
        catch (PublicInterfaceNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BimServerClientException e) {
            e.printStackTrace();
        }
        return null;
    }

    public long getBinaryGeometryMessagingStreamingSerializerOid() throws ServerException, UserException, PublicInterfaceNotFoundException {
        if (this.binaryGeometryMessagingStreamingSerializer == -1L) {
            SSerializerPluginConfiguration serializerPluginConfiguration = this.getPluginInterface().getSerializerByPluginClassName("org.bimserver.serializers.binarygeometry.BinaryGeometryMessagingStreamingSerializerPlugin3NoSplits");
            if (serializerPluginConfiguration != null) {
                this.binaryGeometryMessagingStreamingSerializer = serializerPluginConfiguration.getOid();
            } else {
                throw new UserException("No binary geometry messaging serializer found");
            }
        }
        return this.binaryGeometryMessagingStreamingSerializer;
    }

    public long query(Query query, long roid, long serializerOid) throws ServerException, UserException, PublicInterfaceNotFoundException {
        ObjectNode queryNode = new JsonQueryObjectModelConverter(query.getPackageMetaData()).toJson(query);
        Long topicId = this.getServiceInterface().download(Collections.singleton(roid), queryNode.toString(), Long.valueOf(serializerOid), Boolean.valueOf(false));
        return topicId;
    }

    public void close() throws Exception {
    }

    public void downloadExtendedData(long edid, Path outputFile) throws IOException {
        try (InputStream downloadData = this.channel.getDownloadExtendedData(this.baseAddress, this.token, edid);){
            Files.copy(downloadData, outputFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void downloadExtendedData(long edid, OutputStream outputStream) throws IOException {
        try (InputStream downloadData = this.channel.getDownloadExtendedData(this.baseAddress, this.token, edid);){
            IOUtils.copy((InputStream)downloadData, (OutputStream)outputStream);
        }
    }

    public NewServicesInterface getNewServicesInterface() throws PublicInterfaceNotFoundException {
        return this.get(NewServicesInterface.class);
    }

    public NotificationRegistryInterface getNotificationRegistryInterface() throws PublicInterfaceNotFoundException {
        return this.get(NotificationRegistryInterface.class);
    }

    public void saveDownloadData(long topicId, Path path) throws IOException {
        try (InputStream inputStream = this.channel.getDownloadData(this.baseAddress, this.token, topicId);
             OutputStream newOutputStream = Files.newOutputStream(path, new OpenOption[0]);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)newOutputStream);
        }
    }
}

