/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.json;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.bimserver.client.BimServerClient;
import org.bimserver.client.json.JsonBimServerClientFactory;
import org.bimserver.client.json.JsonChannel;
import org.bimserver.client.json.JsonSSLSocketReflectorFactory;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.exceptions.BimServerClientException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.reflector.RealtimeReflectorFactoryBuilder;
import org.bimserver.shared.reflector.ReflectorFactory;

public class JsonBimServerSSLClientFactory
extends JsonBimServerClientFactory {
    private final JsonSSLSocketReflectorFactory jsonReflectorFactory;
    private final ReflectorFactory reflectorFactory;
    private final String address;
    private final SSLConnectionSocketFactory sslsf;
    private CloseableHttpClient sslHttpClient;

    public JsonBimServerSSLClientFactory(String address, URL trustedCertificate) throws BimServerClientException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        super(null, address);
        this.sslsf = new SSLConnectionSocketFactory(this.sslContext(trustedCertificate));
        this.jsonReflectorFactory = new JsonSSLSocketReflectorFactory(this.getServicesMap(), this.newConnectionManager());
        this.reflectorFactory = new RealtimeReflectorFactoryBuilder(this.getServicesMap()).newReflectorFactory();
        this.address = address;
        this.sslHttpClient = HttpClients.custom().setConnectionManager(this.newConnectionManager()).build();
    }

    @Override
    public CloseableHttpClient getHttpClient() {
        return this.sslHttpClient;
    }

    @Override
    public BimServerClient create(AuthenticationInfo authenticationInfo) throws ServiceException, ChannelConnectionException {
        JsonChannel jsonChannel = new JsonChannel(this.getHttpClient(), this.reflectorFactory, this.jsonReflectorFactory, this.address + "/json", this.getServicesMap());
        BimServerClient bimServerClient = new BimServerClient(this.getMetaDataManager(), this.address, this.getServicesMap(), jsonChannel);
        jsonChannel.connect(bimServerClient);
        bimServerClient.setAuthentication(authenticationInfo);
        bimServerClient.connect();
        return bimServerClient;
    }

    private HttpClientConnectionManager newConnectionManager() {
        Registry r = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)this.sslsf).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(r);
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(100);
        return connManager;
    }

    private SSLContext sslContext(URL trustedCertificate) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        if (trustedCertificate != null) {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(null);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = null;
            try (InputStream trustedCertStream = trustedCertificate.openStream();){
                cert = cf.generateCertificate(trustedCertStream);
            }
            if (cert != null) {
                keystore.setCertificateEntry("onlyentry", cert);
            }
            sslContextBuilder.loadTrustMaterial(keystore, null);
        }
        return sslContextBuilder.build();
    }
}

