/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.json;

import org.apache.http.impl.client.CloseableHttpClient;
import org.bimserver.client.Channel;
import org.bimserver.client.json.JsonReflectorFactory;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.json.JsonReflector;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.reflector.Reflector;
import org.bimserver.shared.reflector.ReflectorFactory;

public class JsonChannel
extends Channel {
    private final ReflectorFactory reflectorFactory;
    private final JsonReflectorFactory jsonReflectorFactory;
    private JsonReflector reflector;
    private String address;
    private SServicesMap sServicesMap;

    public JsonChannel(CloseableHttpClient closeableHttpClient, ReflectorFactory reflectorFactory, JsonReflectorFactory jsonReflectorFactory, String address, SServicesMap sServicesMap) {
        super(closeableHttpClient);
        this.reflectorFactory = reflectorFactory;
        this.jsonReflectorFactory = jsonReflectorFactory;
        this.address = address;
        this.sServicesMap = sServicesMap;
    }

    @Override
    public void disconnect() {
        this.reflector.close();
    }

    @Override
    public void connect(TokenHolder tokenHolder) throws ChannelConnectionException {
        this.reflector = this.jsonReflectorFactory.create(this.address, tokenHolder);
        for (Class interface1 : this.sServicesMap.getInterfaceClasses()) {
            PublicInterface createReflector = this.reflectorFactory.createReflector(interface1, (Reflector)this.reflector);
            this.add(interface1.getName(), createReflector);
        }
        this.finish((Reflector)this.reflector, this.reflectorFactory);
    }
}

