/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterInputStream;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.bimserver.interfaces.objects.SLongCheckinActionState;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.ConnectDisconnectListener;
import org.bimserver.shared.ServiceHolder;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.AuthInterface;
import org.bimserver.shared.interfaces.LowLevelInterface;
import org.bimserver.shared.interfaces.MetaInterface;
import org.bimserver.shared.interfaces.NewServicesInterface;
import org.bimserver.shared.interfaces.NotificationRegistryInterface;
import org.bimserver.shared.interfaces.PluginInterface;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.shared.json.ConvertException;
import org.bimserver.shared.json.JsonConverter;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.reflector.Reflector;
import org.bimserver.shared.reflector.ReflectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Channel
implements ServiceHolder {
    private final Map<String, PublicInterface> serviceInterfaces = new HashMap<String, PublicInterface>();
    private final Set<ConnectDisconnectListener> connectDisconnectListeners = new HashSet<ConnectDisconnectListener>();
    private static final Logger LOGGER = LoggerFactory.getLogger(Channel.class);
    private CloseableHttpClient closeableHttpClient;

    public Channel(CloseableHttpClient closeableHttpClient) {
        this.closeableHttpClient = closeableHttpClient;
    }

    public <T extends PublicInterface> T get(String interfaceClass) {
        return (T)this.serviceInterfaces.get(interfaceClass);
    }

    public void add(String interfaceClass, PublicInterface service) {
        this.serviceInterfaces.put(interfaceClass, service);
    }

    public Map<String, PublicInterface> getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public void registerConnectDisconnectListener(ConnectDisconnectListener connectDisconnectListener) {
        this.connectDisconnectListeners.add(connectDisconnectListener);
    }

    public void notifyOfConnect() {
        for (ConnectDisconnectListener connectDisconnectListener : this.connectDisconnectListeners) {
            connectDisconnectListener.connected();
        }
    }

    public void notifyOfDisconnect() {
        for (ConnectDisconnectListener connectDisconnectListener : this.connectDisconnectListeners) {
            connectDisconnectListener.disconnected();
        }
    }

    protected void finish(Reflector reflector, ReflectorFactory reflectorFactory) {
    }

    public abstract void disconnect();

    public abstract void connect(TokenHolder var1) throws ChannelConnectionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SLongCheckinActionState checkinSync(String baseAddress, String token, long poid, String comment, long deserializerOid, boolean merge, long fileSize, String filename, InputStream inputStream, Long topicId) throws ServerException, UserException {
        String address = baseAddress + "/upload";
        HttpPost httppost = new HttpPost(address);
        try {
            if (topicId == null) {
                topicId = this.getServiceInterface().initiateCheckin(Long.valueOf(poid), Long.valueOf(deserializerOid));
            }
            InputStreamBody data = new InputStreamBody((InputStream)new DeflaterInputStream(inputStream), filename);
            MultipartEntityBuilder multipartEntityBuilder = this.createMultiPart();
            multipartEntityBuilder.addPart("topicId", (ContentBody)new StringBody("" + topicId, ContentType.DEFAULT_TEXT));
            multipartEntityBuilder.addPart("token", (ContentBody)new StringBody(token, ContentType.DEFAULT_TEXT));
            multipartEntityBuilder.addPart("deserializerOid", (ContentBody)new StringBody("" + deserializerOid, ContentType.DEFAULT_TEXT));
            multipartEntityBuilder.addPart("merge", (ContentBody)new StringBody("" + merge, ContentType.DEFAULT_TEXT));
            multipartEntityBuilder.addPart("poid", (ContentBody)new StringBody("" + poid, ContentType.DEFAULT_TEXT));
            multipartEntityBuilder.addPart("comment", (ContentBody)new StringBody("" + comment, ContentType.DEFAULT_TEXT));
            multipartEntityBuilder.addPart("sync", (ContentBody)new StringBody("true", ContentType.DEFAULT_TEXT));
            multipartEntityBuilder.addPart("compression", (ContentBody)new StringBody("deflate", ContentType.DEFAULT_TEXT));
            multipartEntityBuilder.addPart("data", (ContentBody)data);
            httppost.setEntity(multipartEntityBuilder.build());
            CloseableHttpResponse httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httppost);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                ObjectMapper objectMapper = new ObjectMapper();
                try (InputStreamReader in = new InputStreamReader(httpResponse.getEntity().getContent());){
                    ObjectNode result = (ObjectNode)objectMapper.readValue((Reader)in, ObjectNode.class);
                    if (result.has("exception")) {
                        String message;
                        ObjectNode exceptionJson = (ObjectNode)result.get("exception");
                        String exceptionType = exceptionJson.get("__type").asText();
                        String string = message = exceptionJson.has("message") ? exceptionJson.get("message").asText() : "unknown";
                        if (exceptionType.equals(UserException.class.getSimpleName())) {
                            throw new UserException(message);
                        }
                        if (exceptionType.equals(ServerException.class.getSimpleName())) {
                            throw new ServerException(message);
                        }
                    } else {
                        SServicesMap sServicesMap = this.getSServicesMap();
                        try {
                            SLongCheckinActionState exceptionType = (SLongCheckinActionState)this.getJsonConverter().fromJson(sServicesMap.getSType("SLongCheckinState"), null, (Object)result);
                            return exceptionType;
                        }
                        catch (ConvertException e) {
                            throw new ServerException((Throwable)e);
                        }
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            throw new ServerException("HTTP Status Code " + httpResponse.getStatusLine().getStatusCode() + " " + httpResponse.getStatusLine().getReasonPhrase());
        }
        catch (ClientProtocolException e) {
            throw new ServerException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServerException((Throwable)e);
        }
        catch (PublicInterfaceNotFoundException e) {
            throw new ServerException((Throwable)e);
        }
        catch (Exception e) {
            throw new ServerException((Throwable)e);
        }
        finally {
            httppost.releaseConnection();
        }
    }

    private MultipartEntityBuilder createMultiPart() {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setCharset(Charsets.UTF_8);
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        return multipartEntityBuilder;
    }

    protected JsonConverter getJsonConverter() {
        return null;
    }

    protected SServicesMap getSServicesMap() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkinAsync(String baseAddress, String token, long poid, String comment, long deserializerOid, boolean merge, long fileSize, String filename, InputStream inputStream, long topicId) throws ServerException, UserException {
        block16: {
            String address = baseAddress + "/upload";
            HttpPost httppost = new HttpPost(address);
            try {
                InputStreamBody data = new InputStreamBody((InputStream)new DeflaterInputStream(inputStream), filename);
                MultipartEntityBuilder multipartEntityBuilder = this.createMultiPart();
                multipartEntityBuilder.addPart("topicId", (ContentBody)new StringBody("" + topicId, ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("token", (ContentBody)new StringBody(token, ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("deserializerOid", (ContentBody)new StringBody("" + deserializerOid, ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("merge", (ContentBody)new StringBody("" + merge, ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("poid", (ContentBody)new StringBody("" + poid, ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("comment", (ContentBody)new StringBody("" + comment, ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("sync", (ContentBody)new StringBody("false", ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("compression", (ContentBody)new StringBody("deflate", ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("data", (ContentBody)data);
                httppost.setEntity(multipartEntityBuilder.build());
                CloseableHttpResponse httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httppost);
                if (httpResponse.getStatusLine().getStatusCode() != 200) break block16;
                ObjectMapper objectMapper = new ObjectMapper();
                try (InputStreamReader in = new InputStreamReader(httpResponse.getEntity().getContent());){
                    ObjectNode result = (ObjectNode)objectMapper.readValue((Reader)in, ObjectNode.class);
                    if (result.has("exception")) {
                        String message;
                        ObjectNode exceptionJson = (ObjectNode)result.get("exception");
                        String exceptionType = exceptionJson.get("__type").asText();
                        String string = message = exceptionJson.has("message") ? exceptionJson.get("message").asText() : "unknown";
                        if (exceptionType.equals(UserException.class.getSimpleName())) {
                            throw new UserException(message);
                        }
                        if (exceptionType.equals(ServerException.class.getSimpleName())) {
                            throw new ServerException(message);
                        }
                        break block16;
                    }
                    if (result.has("topicId")) {
                        long l = result.get("topicId").asLong();
                        return l;
                    }
                    throw new ServerException("No topicId found in response: " + result.toString());
                }
            }
            catch (ClientProtocolException e) {
                throw new ServerException((Throwable)e);
            }
            catch (IOException e) {
                throw new ServerException((Throwable)e);
            }
            catch (PublicInterfaceNotFoundException e) {
                throw new ServerException((Throwable)e);
            }
            finally {
                httppost.releaseConnection();
            }
        }
        return -1L;
    }

    public InputStream getDownloadData(String baseAddress, String token, long topicId) throws IOException {
        String address = baseAddress + "/download?token=" + token + "&topicId=" + topicId;
        HttpPost httppost = new HttpPost(address);
        try {
            CloseableHttpResponse httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httppost);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                return httpResponse.getEntity().getContent();
            }
            LOGGER.error(httpResponse.getStatusLine().getStatusCode() + " - " + httpResponse.getStatusLine().getReasonPhrase());
            httppost.releaseConnection();
        }
        catch (ClientProtocolException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    public InputStream getDownloadExtendedData(String baseAddress, String token, long edid) throws IOException {
        String address = baseAddress + "/download?token=" + token + "&action=extendeddata&edid=" + edid;
        HttpPost httppost = new HttpPost(address);
        try {
            CloseableHttpResponse httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httppost);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                return httpResponse.getEntity().getContent();
            }
            LOGGER.error(httpResponse.getStatusLine().getStatusCode() + " - " + httpResponse.getStatusLine().getReasonPhrase());
            httppost.releaseConnection();
        }
        catch (ClientProtocolException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    public <T extends PublicInterface> T get(Class<T> class1) throws PublicInterfaceNotFoundException {
        T t = this.get(class1.getName());
        if (t == null) {
            throw new PublicInterfaceNotFoundException("Interface " + class1.getSimpleName() + " not registered on channel " + this);
        }
        return t;
    }

    public AdminInterface getAdminInterface() throws PublicInterfaceNotFoundException {
        return this.get(AdminInterface.class);
    }

    public AuthInterface getAuthInterface() throws PublicInterfaceNotFoundException {
        return this.get(AuthInterface.class);
    }

    public LowLevelInterface getLowLevelInterface() throws PublicInterfaceNotFoundException {
        return this.get(LowLevelInterface.class);
    }

    public MetaInterface getMeta() throws PublicInterfaceNotFoundException {
        return this.get(MetaInterface.class);
    }

    public PluginInterface getPluginInterface() throws PublicInterfaceNotFoundException {
        return this.get(PluginInterface.class);
    }

    public NotificationRegistryInterface getRegistry() throws PublicInterfaceNotFoundException {
        return this.get(NotificationRegistryInterface.class);
    }

    public SettingsInterface getSettingsInterface() throws PublicInterfaceNotFoundException {
        return this.get(SettingsInterface.class);
    }

    public ServiceInterface getServiceInterface() throws PublicInterfaceNotFoundException {
        return this.get(ServiceInterface.class);
    }

    public NewServicesInterface getNewServicesInterface() throws PublicInterfaceNotFoundException {
        return this.get(NewServicesInterface.class);
    }

    protected boolean has(Class<? extends PublicInterface> interface1) {
        return this.serviceInterfaces.containsKey(interface1.getName());
    }

    public AuthInterface getBimServerAuthInterface() throws PublicInterfaceNotFoundException {
        return this.get(AuthInterface.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkCheckin(String baseAddress, String token, long poid, String comment, Path file) throws UserException, ServerException {
        block25: {
            String address = baseAddress + "/bulkupload";
            HttpPost httppost = new HttpPost(address);
            try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                InputStreamBody data = new InputStreamBody(inputStream, file.getFileName().toString());
                MultipartEntityBuilder multipartEntityBuilder = this.createMultiPart();
                multipartEntityBuilder.addPart("token", (ContentBody)new StringBody(token, ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("poid", (ContentBody)new StringBody("" + poid, ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("comment", (ContentBody)new StringBody("" + comment, ContentType.DEFAULT_TEXT));
                multipartEntityBuilder.addPart("data", (ContentBody)data);
                httppost.setEntity(multipartEntityBuilder.build());
                CloseableHttpResponse httpResponse = this.closeableHttpClient.execute((HttpUriRequest)httppost);
                if (httpResponse.getStatusLine().getStatusCode() != 200) break block25;
                ObjectMapper objectMapper = new ObjectMapper();
                try (InputStreamReader in = new InputStreamReader(httpResponse.getEntity().getContent());){
                    ObjectNode result = (ObjectNode)objectMapper.readValue((Reader)in, ObjectNode.class);
                    if (result.has("exception")) {
                        String message;
                        ObjectNode exceptionJson = (ObjectNode)result.get("exception");
                        String exceptionType = exceptionJson.get("__type").asText();
                        String string = message = exceptionJson.has("message") ? exceptionJson.get("message").asText() : "unknown";
                        if (exceptionType.equals(UserException.class.getSimpleName())) {
                            throw new UserException(message);
                        }
                        if (exceptionType.equals(ServerException.class.getSimpleName())) {
                            throw new ServerException(message);
                        }
                    }
                }
            }
            catch (ClientProtocolException e) {
                throw new ServerException((Throwable)e);
            }
            catch (IOException e) {
                throw new ServerException((Throwable)e);
            }
            catch (PublicInterfaceNotFoundException e) {
                throw new ServerException((Throwable)e);
            }
            finally {
                httppost.releaseConnection();
            }
        }
    }
}

