/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CountingLittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    private int pos = 0;

    protected CountingLittleEndianDataInputStream(InputStream in) {
        super(in);
    }

    public void align8() throws IOException {
        int skip = 8 - this.pos % 8;
        if (skip > 0 && skip != 8) {
            this.readFully(new byte[skip]);
        }
    }

    public void align4() throws IOException {
        int skip = 4 - this.pos % 4;
        if (skip > 0 && skip != 4) {
            this.readFully(new byte[skip]);
        }
    }

    public int getPos() {
        return this.pos;
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException("readLine is not supported");
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        ByteStreams.readFully((InputStream)this, (byte[])b);
        this.pos += b.length;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        ByteStreams.readFully((InputStream)this, (byte[])b, (int)off, (int)len);
        this.pos += len;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skip = (int)this.in.skip(n);
        this.pos += skip;
        return skip;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int b1 = this.in.read();
        if (0 > b1) {
            throw new EOFException();
        }
        ++this.pos;
        return b1;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte b1 = this.readAndCheckByte();
        byte b2 = this.readAndCheckByte();
        return Ints.fromBytes((byte)0, (byte)0, (byte)b2, (byte)b1);
    }

    @Override
    public int readInt() throws IOException {
        byte b1 = this.readAndCheckByte();
        byte b2 = this.readAndCheckByte();
        byte b3 = this.readAndCheckByte();
        byte b4 = this.readAndCheckByte();
        return Ints.fromBytes((byte)b4, (byte)b3, (byte)b2, (byte)b1);
    }

    @Override
    public long readLong() throws IOException {
        byte b1 = this.readAndCheckByte();
        byte b2 = this.readAndCheckByte();
        byte b3 = this.readAndCheckByte();
        byte b4 = this.readAndCheckByte();
        byte b5 = this.readAndCheckByte();
        byte b6 = this.readAndCheckByte();
        byte b7 = this.readAndCheckByte();
        byte b8 = this.readAndCheckByte();
        return Longs.fromBytes((byte)b8, (byte)b7, (byte)b6, (byte)b5, (byte)b4, (byte)b3, (byte)b2, (byte)b1);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readUTF() throws IOException {
        String readUTF = new DataInputStream(this.in).readUTF();
        this.pos += 2 + readUTF.getBytes(Charsets.UTF_8).length;
        return readUTF;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    private byte readAndCheckByte() throws IOException, EOFException {
        int b1 = this.in.read();
        ++this.pos;
        if (-1 == b1) {
            throw new EOFException();
        }
        return (byte)b1;
    }
}

