/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.bimserver.client.BimServerClient;
import org.bimserver.client.CountingLittleEndianDataInputStream;
import org.bimserver.client.GeometryException;
import org.bimserver.client.GeometryTarget;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryException;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.geometry.Bounds;
import org.bimserver.models.geometry.Buffer;
import org.bimserver.models.geometry.GeometryData;
import org.bimserver.models.geometry.GeometryFactory;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.geometry.Vector3f;
import org.bimserver.plugins.ObjectAlreadyExistsException;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeometryLoader.class);
    private PackageMetaData packageMetaData;
    private int bytesRead;
    private GeometryTarget geometryTarget;
    private BimServerClient bimServerClient;

    public GeometryLoader(BimServerClient bimServerClient, PackageMetaData packageMetaData, GeometryTarget geometryTarget) {
        this.bimServerClient = bimServerClient;
        this.packageMetaData = packageMetaData;
        this.geometryTarget = geometryTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream inputStream) throws GeometryException, IOException, ObjectAlreadyExistsException, IfcModelInterfaceException {
        int t = 0;
        CountingLittleEndianDataInputStream dataInputStream = new CountingLittleEndianDataInputStream(inputStream);
        try {
            boolean done = false;
            while (true) {
                byte geometryType;
                if ((geometryType = dataInputStream.readByte()) == 0) {
                    String protocol = dataInputStream.readUTF();
                    if (!protocol.equals("BGS")) {
                        throw new GeometryException("Protocol != BGS (" + protocol + ")");
                    }
                    byte formatVersion = dataInputStream.readByte();
                    if (formatVersion != 19) {
                        throw new GeometryException("Unsupported version " + formatVersion + " / 19");
                    }
                    float multiplierToMm = dataInputStream.readFloat();
                    dataInputStream.align8();
                    for (int i = 0; i < 6; ++i) {
                        dataInputStream.readDouble();
                    }
                } else if (geometryType == 5) {
                    boolean isInPreparedBuffer = dataInputStream.readByte() == 1;
                    long ifcProductOid = dataInputStream.readLong();
                    String type = dataInputStream.readUTF();
                    int nrColors = dataInputStream.readInt();
                    dataInputStream.align8();
                    long roid = dataInputStream.readLong();
                    long geometryInfoOid = dataInputStream.readLong();
                    boolean hasTransparency = dataInputStream.readLong() == 1L;
                    GeometryInfo geometryInfo = (GeometryInfo)this.geometryTarget.get(geometryInfoOid);
                    if (geometryInfo == null) {
                        geometryInfo = this.geometryTarget.create(GeometryInfo.class);
                    }
                    ((IdEObjectImpl)geometryInfo).setOid(geometryInfoOid);
                    ((IdEObjectImpl)geometryInfo).setLoadingState(IdEObjectImpl.State.LOADING);
                    this.geometryTarget.add(geometryInfoOid, (IdEObject)geometryInfo);
                    IdEObject ifcProduct = this.geometryTarget.get(ifcProductOid);
                    EStructuralFeature geometryFeature = this.packageMetaData.getEClass("IfcProduct").getEStructuralFeature("geometry");
                    if (ifcProduct != null) {
                        ifcProduct.eSet(geometryFeature, (Object)geometryInfo);
                    }
                    Vector3f minBounds = GeometryFactory.eINSTANCE.createVector3f();
                    minBounds.setX(dataInputStream.readDouble());
                    minBounds.setY(dataInputStream.readDouble());
                    minBounds.setZ(dataInputStream.readDouble());
                    Vector3f maxBounds = GeometryFactory.eINSTANCE.createVector3f();
                    maxBounds.setX(dataInputStream.readDouble());
                    maxBounds.setY(dataInputStream.readDouble());
                    maxBounds.setZ(dataInputStream.readDouble());
                    Bounds bounds = GeometryFactory.eINSTANCE.createBounds();
                    bounds.setMin(minBounds);
                    bounds.setMax(maxBounds);
                    geometryInfo.setBounds(bounds);
                    byte[] transformation = new byte[128];
                    dataInputStream.readFully(transformation);
                    geometryInfo.setTransformation(transformation);
                    long geometryDataOid = dataInputStream.readLong();
                    GeometryData geometryData = (GeometryData)this.geometryTarget.get(geometryDataOid);
                    if (geometryData == null) {
                        geometryData = GeometryFactory.eINSTANCE.createGeometryData();
                        this.geometryTarget.add(geometryDataOid, (IdEObject)geometryData);
                    } else {
                        geometryInfo.setNrVertices(geometryData.getNrVertices());
                        geometryInfo.setNrColors(geometryData.getNrColors());
                        geometryInfo.setPrimitiveCount(Integer.valueOf(geometryData.getNrIndices() / 3));
                    }
                    geometryInfo.setData(geometryData);
                    ((IdEObjectImpl)geometryData).setLoadingState(IdEObjectImpl.State.LOADED);
                } else {
                    if (geometryType == 3) {
                        throw new GeometryException("Parts not supported");
                    }
                    if (geometryType == 1) {
                        int reused = dataInputStream.readInt();
                        String type = dataInputStream.readUTF();
                        dataInputStream.align8();
                        long roid = dataInputStream.readLong();
                        long croid = dataInputStream.readLong();
                        boolean hasTransparency = dataInputStream.readLong() == 1L;
                        long geometryDataOid = dataInputStream.readLong();
                        GeometryData geometryData = (GeometryData)this.geometryTarget.get(geometryDataOid);
                        if (geometryData == null) {
                            geometryData = GeometryFactory.eINSTANCE.createGeometryData();
                            this.geometryTarget.add(geometryDataOid, (IdEObject)geometryData);
                        }
                        ((IdEObjectImpl)geometryData).setOid(geometryDataOid);
                        ((IdEObjectImpl)geometryData).setLoadingState(IdEObjectImpl.State.LOADING);
                        int nrIndices = dataInputStream.readInt();
                        byte[] indices = new byte[nrIndices * 4];
                        dataInputStream.readFully(indices);
                        Buffer buffer = GeometryFactory.eINSTANCE.createBuffer();
                        buffer.setData(indices);
                        geometryData.setIndices(buffer);
                        geometryData.setNrIndices(indices.length / 4);
                        int colorType = dataInputStream.readInt();
                        if (colorType == 1) {
                            dataInputStream.readFloat();
                            dataInputStream.readFloat();
                            dataInputStream.readFloat();
                            dataInputStream.readFloat();
                        }
                        int nrVertices = dataInputStream.readInt();
                        byte[] vertices = new byte[nrVertices * 4];
                        dataInputStream.readFully(vertices);
                        Buffer verticesBuffer = GeometryFactory.eINSTANCE.createBuffer();
                        verticesBuffer.setData(vertices);
                        geometryData.setVertices(verticesBuffer);
                        geometryData.setNrVertices(vertices.length / 4);
                        int nrNormals = dataInputStream.readInt();
                        byte[] normals = new byte[nrNormals * 4];
                        dataInputStream.readFully(normals);
                        Buffer normalsBuffer = GeometryFactory.eINSTANCE.createBuffer();
                        normalsBuffer.setData(normals);
                        geometryData.setNormals(normalsBuffer);
                        geometryData.setNrNormals(normals.length / 4);
                        int nrMaterials = dataInputStream.readInt();
                        byte[] materials = new byte[nrMaterials];
                        dataInputStream.readFully(materials);
                        Buffer colorsBuffer = GeometryFactory.eINSTANCE.createBuffer();
                        colorsBuffer.setData(materials);
                        geometryData.setColorsQuantized(colorsBuffer);
                        geometryData.setNrColors(materials.length);
                        ((IdEObjectImpl)geometryData).setLoadingState(IdEObjectImpl.State.LOADED);
                    } else if (geometryType == 6) {
                        done = true;
                    } else {
                        throw new GeometryException("Unimplemented geometryType: " + geometryType);
                    }
                }
                ++t;
                dataInputStream.align8();
            }
        }
        catch (EOFException done) {
            dataInputStream.close();
            this.bytesRead += dataInputStream.getPos();
        }
        catch (IOException e) {
            try {
                System.out.println("T: " + t);
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                dataInputStream.close();
                this.bytesRead += dataInputStream.getPos();
            }
        }
    }

    public void loadProducts(long roid, Set<Long> oids) throws QueryException, ServerException, UserException, PublicInterfaceNotFoundException, IOException {
        Query query = new Query("test", this.packageMetaData);
        ObjectNode settings = new ObjectMapper().createObjectNode();
        query.setGeometrySettings(settings);
        query.getGeometrySettings().put("useSmallInts", false);
        query.getGeometrySettings().put("splitGeometry", false);
        query.getGeometrySettings().put("quantizeColors", true);
        QueryPart queryPart = query.createQueryPart();
        queryPart.addOids(oids);
        if (queryPart.getOids() == null) {
            return;
        }
        LOGGER.info("Loading geometry for " + queryPart.getOids().size() + " objects");
        Include productInclude = queryPart.createInclude();
        productInclude.addType(this.packageMetaData.getEClass("IfcProduct"), true);
        productInclude.addField("geometry");
        EClass geometryInfoClass = this.packageMetaData.getEClassIncludingDependencies("GeometryInfo");
        Include include = productInclude.createInclude();
        include.addType(geometryInfoClass, false);
        include.addField("data");
        Include geometryData = include.createInclude();
        geometryData.addType(this.packageMetaData.getEClassIncludingDependencies("GeometryData"), false);
        geometryData.addFieldDirect("indices");
        geometryData.addFieldDirect("normals");
        geometryData.addFieldDirect("vertices");
        geometryData.addFieldDirect("colorsQuantized");
        long serializerOid = this.bimServerClient.getBinaryGeometryMessagingStreamingSerializerOid();
        this.fetch(roid, query, serializerOid);
    }

    public void loadGeometryData(long roid, Set<Long> oids) throws QueryException, ServerException, UserException, PublicInterfaceNotFoundException, IOException {
        Query query = new Query("test", this.packageMetaData);
        ObjectNode settings = new ObjectMapper().createObjectNode();
        query.setGeometrySettings(settings);
        query.getGeometrySettings().put("useSmallInts", false);
        query.getGeometrySettings().put("splitGeometry", false);
        query.getGeometrySettings().put("quantizeColors", true);
        QueryPart queryPart = query.createQueryPart();
        queryPart.addOids(oids);
        if (queryPart.getOids() == null) {
            return;
        }
        LOGGER.info("Loading geometry for " + queryPart.getOids().size() + " objects");
        Include geometryData = queryPart.createInclude();
        geometryData.addType(this.packageMetaData.getEClassIncludingDependencies("GeometryData"), false);
        geometryData.addFieldDirect("indices");
        geometryData.addFieldDirect("normals");
        geometryData.addFieldDirect("vertices");
        geometryData.addFieldDirect("colorsQuantized");
        long serializerOid = this.bimServerClient.getBinaryGeometryMessagingStreamingSerializerOid();
        this.fetch(roid, query, serializerOid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch(long roid, Query query, long serializerOid) throws ServerException, UserException, IOException {
        long topicId = this.bimServerClient.query(query, roid, serializerOid);
        this.bimServerClient.waitForDonePreparing(topicId);
        InputStream inputStream = this.bimServerClient.getDownloadData(topicId);
        try {
            this.load(inputStream);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.bimServerClient.getServiceInterface().cleanupLongAction(Long.valueOf(topicId));
        }
    }

    public GeometryTarget getGeometryTarget() {
        return this.geometryTarget;
    }
}

