/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bimserver.client.GeometryTarget;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.plugins.ObjectAlreadyExistsException;

public class GeometryTargetImpl
implements GeometryTarget {
    private PackageMetaData packageMetaData;
    private final Map<Long, IdEObject> objects = new HashMap<Long, IdEObject>();

    public GeometryTargetImpl(PackageMetaData packageMetaData) {
        this.packageMetaData = packageMetaData;
    }

    @Override
    public <T extends IdEObject> T create(Class<T> clazz) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        IdEObject object = this.packageMetaData.create(clazz);
        return (T)object;
    }

    @Override
    public IdEObject get(long oid) {
        return this.objects.get(oid);
    }

    @Override
    public void add(long oid, IdEObject idEObject) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        this.objects.put(oid, idEObject);
    }

    public Set<GeometryInfo> getAllGeometryInfo() {
        HashSet<GeometryInfo> result = new HashSet<GeometryInfo>();
        for (IdEObject idEObject : this.objects.values()) {
            if (!(idEObject instanceof GeometryInfo)) continue;
            result.add((GeometryInfo)idEObject);
        }
        return result;
    }

    public String toString() {
        return "GeometryTargetImpl " + this.objects.size();
    }
}

