/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.bimserver.client.BimServerClient;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.CountingInputStream;

public class StreamingModel {
    private BimServerClient bimServerClient;
    private long roid;

    public StreamingModel(BimServerClient bimServerClient, PackageMetaData packageMetaData, long roid) {
        this.bimServerClient = bimServerClient;
        this.roid = roid;
        Query query = new Query("test", packageMetaData);
        QueryPart queryPart = query.createQueryPart();
        queryPart.setIncludeAllFields(true);
        ObjectNode queryNode = new JsonQueryObjectModelConverter(query.getPackageMetaData()).toJson(query);
        try {
            Long topicId = bimServerClient.getServiceInterface().download(Collections.singleton(roid), queryNode.toString(), Long.valueOf(bimServerClient.getJsonSerializerOid()), Boolean.valueOf(false));
            bimServerClient.waitForDonePreparing(topicId);
            this.processDownload(topicId);
            bimServerClient.getServiceInterface().cleanupLongAction(topicId);
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (UserException e) {
            e.printStackTrace();
        }
        catch (PublicInterfaceNotFoundException e) {
            e.printStackTrace();
        }
        catch (IfcModelInterfaceException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processDownload(Long topicId) throws UserException, ServerException, PublicInterfaceNotFoundException, IfcModelInterfaceException, IOException {
        InputStream inputStream = this.bimServerClient.getDownloadData(topicId);
        if (inputStream == null) {
            throw new IfcModelInterfaceException("No InputStream to read from for topicId " + topicId);
        }
        try (CountingInputStream downloadData = new CountingInputStream(inputStream){};){
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jsonParser = jsonFactory.createParser((InputStream)downloadData);
        }
    }

    public ObjectNode getNext() {
        return null;
    }
}

