/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.notifications;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bimserver.client.BimServerClient;
import org.bimserver.client.ProgressHandler;
import org.bimserver.client.notifications.BinaryMessageListener;
import org.bimserver.client.notifications.NotificationsClient;
import org.bimserver.client.notifications.WebSocketHeartbeat;
import org.bimserver.client.notifications.WebSocketImpl;
import org.bimserver.interfaces.objects.SLongActionState;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.NotificationInterface;
import org.bimserver.shared.interfaces.NotificationInterfaceAdaptor;
import org.bimserver.shared.interfaces.PublicInterface;
import org.bimserver.shared.json.ConvertException;
import org.bimserver.shared.json.JsonConverter;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SParameter;
import org.bimserver.shared.meta.SService;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.reflector.KeyValuePair;
import org.bimserver.shared.reflector.ReflectorException;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationsManager
extends NotificationsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationsManager.class);
    private final Map<Long, Set<ProgressHandler>> progressListeners = new HashMap<Long, Set<ProgressHandler>>();
    private String address;
    private SServicesMap servicesMap;
    private volatile boolean running;
    private BimServerClient bimServerClient;
    private long endpointid;
    private JsonConverter converter;
    private NotificationInterface service;
    private WebSocketClient webSocketClient;
    private WebSocketImpl webSocketImpl;
    private WebSocketHeartbeat heartbeat;

    public NotificationsManager(BimServerClient bimServerClient) {
        this.bimServerClient = bimServerClient;
        this.service = new NotificationInterfaceAdaptor(){

            public void progress(Long topicId, SLongActionState state) throws UserException, ServerException {
                Set set = (Set)NotificationsManager.this.progressListeners.get(topicId);
                if (set != null) {
                    for (ProgressHandler progressHandler : set) {
                        progressHandler.progress(state);
                    }
                }
            }
        };
    }

    public void setBinaryMessageListener(BinaryMessageListener binaryMessageListener) {
        this.webSocketImpl.setBinaryMessageListener(binaryMessageListener);
    }

    public void start() {
        this.webSocketClient = new WebSocketClient();
        try {
            this.webSocketClient.start();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        try {
            URI uri = URI.create("ws://" + this.address + "/stream");
            this.webSocketImpl = new WebSocketImpl(this);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            this.webSocketClient.connect((Object)this.webSocketImpl, uri, request);
            this.webSocketImpl.waitForEndpointId();
            this.heartbeat = new WebSocketHeartbeat(this.webSocketImpl);
            this.heartbeat.start();
            this.running = true;
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void connect(SServicesMap servicesMap, String address) {
        this.servicesMap = servicesMap;
        this.address = address;
        this.converter = new JsonConverter(servicesMap);
    }

    public void send(JsonNode jsonNode) {
        this.webSocketImpl.send(jsonNode);
    }

    public void disconnect() {
        this.running = false;
        if (this.heartbeat != null) {
            try {
                this.heartbeat.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.webSocketImpl != null) {
            this.webSocketImpl.close();
        }
        if (this.webSocketClient != null) {
            try {
                this.webSocketClient.stop();
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            this.webSocketClient.destroy();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startAndWaitForInit() {
        this.running = true;
        this.start();
    }

    public void unregisterNotifictionListener(NotificationInterface notificationInterface) {
    }

    public BimServerClient getBimServerClient() {
        return this.bimServerClient;
    }

    public long getEndpointid() {
        return this.endpointid;
    }

    public void setEndpointId(long endpointid) {
        this.endpointid = endpointid;
    }

    public void unregisterProgressHandler(Long topicId, ProgressHandler progressHandler) {
        try {
            if (!this.progressListeners.containsKey(topicId)) {
                this.progressListeners.put(topicId, new HashSet());
            }
            this.progressListeners.get(topicId).remove(progressHandler);
            this.bimServerClient.getRegistry().unregisterProgressHandler(topicId, Long.valueOf(this.getEndpointid()));
        }
        catch (UserException userException) {
        }
        catch (ServerException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (PublicInterfaceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void registerProgressHandler(Long topicId, ProgressHandler progressHandler) {
        try {
            if (!this.progressListeners.containsKey(topicId)) {
                this.progressListeners.put(topicId, new HashSet());
            }
            this.progressListeners.get(topicId).add(progressHandler);
            this.bimServerClient.getRegistry().registerProgressHandler(topicId, Long.valueOf(this.getEndpointid()));
        }
        catch (UserException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ServerException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (PublicInterfaceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void handleIncoming(ObjectNode request) throws UserException, ConvertException, IOException {
        String interfaceName = request.get("interface").asText();
        String methodName = request.get("method").asText();
        SService sService = this.servicesMap.getByName(interfaceName);
        if (sService == null) {
            sService = this.servicesMap.getBySimpleName(interfaceName);
        }
        if (sService == null) {
            throw new UserException("No service found with name " + interfaceName);
        }
        SMethod method = sService.getSMethod(methodName);
        if (method == null) {
            SMethod alternative = this.servicesMap.findMethod(methodName);
            if (alternative == null) {
                throw new UserException("Method " + methodName + " not found on " + interfaceName);
            }
            throw new UserException("Method " + methodName + " not found on " + interfaceName + " (suggestion: " + alternative.getService().getSimpleName() + ")");
        }
        KeyValuePair[] parameters = new KeyValuePair[method.getParameters().size()];
        if (request.has("parameters")) {
            ObjectNode parametersJson = (ObjectNode)request.get("parameters");
            for (int i = 0; i < method.getParameters().size(); ++i) {
                SParameter parameter = method.getParameter(i);
                if (parametersJson.has(parameter.getName())) {
                    parameters[i] = new KeyValuePair(parameter.getName(), this.converter.fromJson(parameter.getType(), parameter.getGenericType(), (Object)parametersJson.get(parameter.getName())));
                    continue;
                }
                LOGGER.error("Missing parameters: " + method.getName() + " -> " + parameter.getName());
            }
        } else {
            throw new UserException("Missing 'parameters' field");
        }
        try {
            method.invoke(sService.getInterfaceClass(), (PublicInterface)this.service, parameters);
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ReflectorException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

