/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.notifications;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.bimserver.client.notifications.WebSocketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHeartbeat
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketHeartbeat.class);
    private WebSocketImpl webSocketImpl;
    private volatile boolean running = true;

    public WebSocketHeartbeat(WebSocketImpl webSocketImpl) {
        this.webSocketImpl = webSocketImpl;
    }

    public void shutdown() {
        this.running = false;
        this.interrupt();
    }

    @Override
    public void run() {
        ObjectNode message = new ObjectMapper().createObjectNode();
        message.put("hb", true);
        while (this.running) {
            this.webSocketImpl.send((JsonNode)message);
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                if (!this.running) continue;
                LOGGER.error("", (Throwable)e);
            }
        }
    }
}

