/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.notifications;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.bimserver.client.notifications.BinaryMessageListener;
import org.bimserver.client.notifications.NotificationsManager;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.json.ConvertException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxBinaryMessageSize=0x6400000)
public class WebSocketImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketImpl.class);
    private Session session;
    private NotificationsManager socketNotificationsClient;
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private BinaryMessageListener binaryMessageListener;

    public WebSocketImpl(NotificationsManager socketNotificationsClient) {
        this.socketNotificationsClient = socketNotificationsClient;
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
        }
    }

    public void waitForEndpointId() {
        try {
            if (!this.countDownLatch.await(1L, TimeUnit.MINUTES)) {
                LOGGER.warn("Did not get an EndpointId within 1 minute");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.session = null;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
    }

    public void send(JsonNode jsonNode) {
        try {
            this.session.getRemote().sendString(jsonNode.toString());
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @OnWebSocketMessage
    public void onBinary(byte[] bytes, int start, int length) {
        this.binaryMessageListener.newData(bytes, start, length);
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        try {
            ObjectNode parse = (ObjectNode)new ObjectMapper().readValue(msg, ObjectNode.class);
            if (parse instanceof ObjectNode) {
                ObjectNode object = parse;
                if (object.has("welcome")) {
                    String token = this.socketNotificationsClient.getBimServerClient().getToken();
                    this.session.getRemote().sendString("{\"token\":\"" + token + "\"}");
                } else if (object.has("endpointid")) {
                    this.socketNotificationsClient.setEndpointId(object.get("endpointid").asLong());
                    this.countDownLatch.countDown();
                } else {
                    try {
                        this.socketNotificationsClient.handleIncoming((ObjectNode)object.get("request"));
                    }
                    catch (UserException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                    catch (ConvertException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @OnWebSocketError
    public void onError(Session session, Throwable error) {
        LOGGER.error("", error);
    }

    public void setBinaryMessageListener(BinaryMessageListener messageListener) {
        this.binaryMessageListener = messageListener;
    }
}

