/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bimserver.client.BimServerClient;
import org.bimserver.client.GeometryException;
import org.bimserver.database.queries.om.Include;
import org.bimserver.database.queries.om.JsonQueryObjectModelConverter;
import org.bimserver.database.queries.om.Query;
import org.bimserver.database.queries.om.QueryPart;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.OidProvider;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.SharedJsonDeserializer;
import org.bimserver.emf.SharedJsonSerializer;
import org.bimserver.ifc.IfcModel;
import org.bimserver.interfaces.objects.SDeserializerPluginConfiguration;
import org.bimserver.interfaces.objects.SLongActionState;
import org.bimserver.interfaces.objects.SSerializerPluginConfiguration;
import org.bimserver.models.geometry.GeometryData;
import org.bimserver.models.geometry.GeometryFactory;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.geometry.Vector3f;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.plugins.serializers.SerializerInputstream;
import org.bimserver.plugins.serializers.StreamingReader;
import org.bimserver.shared.QueryException;
import org.bimserver.shared.exceptions.BimServerClientException;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1LowLevelInterface;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientIfcModel
extends IfcModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientIfcModel.class);
    private BimServerClient bimServerClient;
    private ModelState modelState = ModelState.NONE;
    private long tid = -1L;
    private long roid;
    private final Set<String> loadedClasses = new HashSet<String>();
    private long ifcSerializerOid = -1L;
    private long binaryGeometrySerializerOid = -1L;
    private boolean recordChanges;
    private boolean includeGeometry;
    private EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            block20: {
                super.notifyChanged(notification);
                IdEObject idEObject = (IdEObject)notification.getNotifier();
                EStructuralFeature eFeature = (EStructuralFeature)notification.getFeature();
                if (notification.getEventType() == 3) {
                    if (ClientIfcModel.this.getModelState() != ModelState.LOADING) {
                        try {
                            if (eFeature.getEType() == EcorePackage.eINSTANCE.getEString()) {
                                ClientIfcModel.this.bimServerClient.getBimsie1LowLevelInterface().addStringAttribute(ClientIfcModel.this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), notification.getNewStringValue());
                                break block20;
                            }
                            if (eFeature.getEType() == EcorePackage.eINSTANCE.getELong() || eFeature.getEType() == EcorePackage.eINSTANCE.getELongObject()) {
                                throw new UnsupportedOperationException();
                            }
                            if (eFeature.getEType() == EcorePackage.eINSTANCE.getEDouble() || eFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject()) {
                                ClientIfcModel.this.bimServerClient.getBimsie1LowLevelInterface().addDoubleAttribute(ClientIfcModel.this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), Double.valueOf(notification.getNewDoubleValue()));
                                break block20;
                            }
                            if (eFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean() || eFeature.getEType() == EcorePackage.eINSTANCE.getEBooleanObject()) {
                                ClientIfcModel.this.bimServerClient.getBimsie1LowLevelInterface().addBooleanAttribute(ClientIfcModel.this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), Boolean.valueOf(notification.getNewBooleanValue()));
                                break block20;
                            }
                            if (eFeature.getEType() == EcorePackage.eINSTANCE.getEInt() || eFeature.getEType() == EcorePackage.eINSTANCE.getEIntegerObject()) {
                                ClientIfcModel.this.bimServerClient.getBimsie1LowLevelInterface().addIntegerAttribute(ClientIfcModel.this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), Integer.valueOf(notification.getNewIntValue()));
                                break block20;
                            }
                            if (eFeature.getEType() == EcorePackage.eINSTANCE.getEByteArray()) {
                                throw new UnsupportedOperationException();
                            }
                            if (eFeature.getEType() instanceof EEnum) {
                                throw new UnsupportedOperationException();
                            }
                            if (eFeature instanceof EReference) {
                                if (notification.getNewValue() != null) {
                                    ClientIfcModel.this.bimServerClient.getBimsie1LowLevelInterface().addReference(ClientIfcModel.this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), Long.valueOf(((IdEObject)notification.getNewValue()).getOid()));
                                }
                                break block20;
                            }
                            throw new RuntimeException("Unimplemented " + eFeature.getEType().getName() + " " + notification.getNewValue());
                        }
                        catch (ServiceException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                        catch (PublicInterfaceNotFoundException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                    }
                } else if (notification.getEventType() == 4 && ClientIfcModel.this.getModelState() != ModelState.LOADING) {
                    try {
                        if (!(eFeature instanceof EReference)) {
                            throw new RuntimeException("Unimplemented " + eFeature.getEType().getName() + " " + notification.getNewValue());
                        }
                        IdEObject oldValue = (IdEObject)notification.getOldValue();
                        ClientIfcModel.this.bimServerClient.getBimsie1LowLevelInterface().removeReferenceByOid(ClientIfcModel.this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), Long.valueOf(oldValue.getOid()));
                    }
                    catch (ServiceException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                    catch (PublicInterfaceNotFoundException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
            }
        }
    };

    public ClientIfcModel(BimServerClient bimServerClient, long poid, long roid, boolean deep, PackageMetaData packageMetaData, boolean recordChanges, boolean includeGeometry) throws ServerException, UserException, BimServerClientException, PublicInterfaceNotFoundException {
        super(packageMetaData, null);
        this.recordChanges = recordChanges;
        this.bimServerClient = bimServerClient;
        this.roid = roid;
        this.includeGeometry = includeGeometry;
        if (recordChanges) {
            try {
                this.tid = bimServerClient.getBimsie1LowLevelInterface().startTransaction(Long.valueOf(poid));
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        if (deep) {
            try {
                this.loadDeep();
            }
            catch (QueryException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    private ClientIfcModel(BimServerClient bimServerClient, PackageMetaData packageMetaData, long poid, boolean recordChanges) {
        super(packageMetaData, null);
        this.bimServerClient = bimServerClient;
        this.recordChanges = recordChanges;
        if (recordChanges) {
            try {
                this.tid = bimServerClient.getBimsie1LowLevelInterface().startTransaction(Long.valueOf(poid));
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public ClientIfcModel branch(long poid, boolean recordChanges) {
        IdEObjectImpl targetObject;
        ClientIfcModel branch = new ClientIfcModel(this.bimServerClient, this.getPackageMetaData(), poid, recordChanges);
        try {
            this.loadDeep();
        }
        catch (ServerException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UserException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimServerClientException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (PublicInterfaceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (QueryException e) {
            LOGGER.error("", (Throwable)e);
        }
        HashMap<IdEObject, IdEObjectImpl> map = new HashMap<IdEObject, IdEObjectImpl>();
        for (IdEObject sourceObject : this.getValues()) {
            try {
                targetObject = (IdEObjectImpl)branch.create(sourceObject.eClass());
                targetObject.setLoadingState(IdEObjectImpl.State.LOADED);
                map.put(sourceObject, targetObject);
            }
            catch (IfcModelInterfaceException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        for (IdEObject sourceObject : this.getObjects().values()) {
            targetObject = (IdEObject)map.get(sourceObject);
            for (EStructuralFeature eStructuralFeature : sourceObject.eClass().getEAllStructuralFeatures()) {
                List targetList;
                List sourceList;
                Object sourceValue = sourceObject.eGet(eStructuralFeature);
                if (eStructuralFeature instanceof EReference) {
                    if (eStructuralFeature.isMany()) {
                        sourceList = (List)sourceValue;
                        targetList = (List)targetObject.eGet(eStructuralFeature);
                        for (Object sourceItem : sourceList) {
                            IdEObject e = (IdEObject)map.get(sourceItem);
                            if (e == null) continue;
                            targetList.add(e);
                        }
                        continue;
                    }
                    targetObject.eSet(eStructuralFeature, map.get(sourceValue));
                    continue;
                }
                if (eStructuralFeature.isMany()) {
                    sourceList = (List)sourceValue;
                    targetList = (List)targetObject.eGet(eStructuralFeature);
                    for (Object sourceItem : sourceList) {
                        targetList.add(sourceItem);
                    }
                    continue;
                }
                targetObject.eSet(eStructuralFeature, sourceValue);
            }
        }
        branch.setModelState(ModelState.FULLY_LOADED);
        return branch;
    }

    private void setModelState(ModelState modelState) {
        this.modelState = modelState;
    }

    public BimServerClient getBimServerClient() {
        return this.bimServerClient;
    }

    public long commit(String comment) throws ServerException, UserException, PublicInterfaceNotFoundException {
        return this.bimServerClient.getBimsie1LowLevelInterface().commitTransaction(Long.valueOf(this.tid), comment);
    }

    public long getJsonSerializerOid() throws ServerException, UserException, PublicInterfaceNotFoundException {
        if (this.ifcSerializerOid == -1L) {
            SSerializerPluginConfiguration serializerPluginConfiguration = this.bimServerClient.getPluginInterface().getSerializerByPluginClassName("org.bimserver.serializers.JsonStreamingSerializerPlugin");
            if (serializerPluginConfiguration != null) {
                this.ifcSerializerOid = serializerPluginConfiguration.getOid();
            } else {
                throw new UserException("No JSON streaming serializer found");
            }
        }
        return this.ifcSerializerOid;
    }

    public long getBinaryGeometrySerializerOid() throws ServerException, UserException, PublicInterfaceNotFoundException {
        if (this.binaryGeometrySerializerOid == -1L) {
            SSerializerPluginConfiguration serializerPluginConfiguration = this.bimServerClient.getPluginInterface().getSerializerByPluginClassName("org.bimserver.serializers.binarygeometry.BinaryGeometrySerializerPlugin");
            if (serializerPluginConfiguration != null) {
                this.binaryGeometrySerializerOid = serializerPluginConfiguration.getOid();
            } else {
                throw new UserException("No binary geometry serializer found");
            }
        }
        return this.binaryGeometrySerializerOid;
    }

    private void loadDeep() throws ServerException, UserException, BimServerClientException, PublicInterfaceNotFoundException, QueryException {
        if (this.modelState != ModelState.FULLY_LOADED && this.modelState != ModelState.LOADING) {
            this.modelState = ModelState.LOADING;
            Query query = new Query("test", this.getPackageMetaData());
            QueryPart queryPart = query.createQueryPart();
            queryPart.setIncludeAllFields(true);
            ObjectNode queryNode = new JsonQueryObjectModelConverter(query.getPackageMetaData()).toJson(query);
            Long topicId = this.bimServerClient.getBimsie1ServiceInterface().downloadByNewJsonQuery(Collections.singleton(this.roid), queryNode.toString(), Long.valueOf(this.getJsonSerializerOid()), Boolean.valueOf(false));
            this.waitForDonePreparing(topicId);
            try {
                this.processDownload(topicId);
                this.modelState = ModelState.FULLY_LOADED;
                this.loadGeometry();
            }
            catch (IOException | IfcModelInterfaceException e) {
                LOGGER.error("", e);
            }
            catch (QueryException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (GeometryException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGeometry() throws QueryException, ServerException, UserException, PublicInterfaceNotFoundException, IOException, GeometryException, IfcModelInterfaceException {
        if (this.includeGeometry) {
            Query query = new Query("test", this.getPackageMetaData());
            QueryPart queryPart = query.createQueryPart();
            EClass geometryInfoClass = this.getPackageMetaData().getEClassIncludingDependencies("GeometryInfo");
            queryPart.addType(geometryInfoClass, false);
            Include include = queryPart.createInclude();
            include.addType(geometryInfoClass, false);
            include.addField("data");
            for (IfcProduct ifcProduct : this.getAllWithSubTypes(IfcProduct.class)) {
                GeometryInfo geometry = ifcProduct.getGeometry();
                if (geometry == null) continue;
                queryPart.addOid(geometry.getOid());
            }
            long serializerOid = this.bimServerClient.getBinaryGeometryMessagingStreamingSerializerOid();
            long topicId = this.bimServerClient.query(query, this.roid, serializerOid);
            this.waitForDonePreparing(topicId);
            try (InputStream inputStream = this.bimServerClient.getDownloadData(topicId, serializerOid);){
                this.processGeometryInputStream(inputStream);
            }
        }
    }

    private void waitForDonePreparing(long topicId) throws UserException, ServerException, PublicInterfaceNotFoundException {
        SLongActionState progress;
        for (int i = 0; !(i >= 10 || (progress = this.bimServerClient.getRegistry().getProgress(Long.valueOf(topicId))) != null && progress.getTitle() != null && progress.getTitle().equals("Done preparing")); ++i) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void processGeometryInputStream(InputStream inputStream) throws IOException, GeometryException, IfcModelInterfaceException {
        try (LittleEndianDataInputStream dataInputStream = new LittleEndianDataInputStream(inputStream);){
            boolean done = false;
            while (!done) {
                byte type = dataInputStream.readByte();
                if (type == 0) {
                    String protocol = dataInputStream.readUTF();
                    if (!protocol.equals("BGS")) {
                        throw new GeometryException("Protocol != BGS (" + protocol + ")");
                    }
                    byte formatVersion = dataInputStream.readByte();
                    if (formatVersion != 7) {
                        throw new GeometryException("Unsupported version " + formatVersion + " / 7");
                    }
                    int skip = 1;
                    if (skip != 0 && skip != 4) {
                        dataInputStream.read(new byte[skip]);
                    }
                    for (int i = 0; i < 6; ++i) {
                        dataInputStream.readFloat();
                    }
                    continue;
                }
                if (type == 5) {
                    dataInputStream.read(new byte[3]);
                    dataInputStream.readLong();
                    long geometryInfoOid = dataInputStream.readLong();
                    GeometryInfo geometryInfo = (GeometryInfo)this.get(geometryInfoOid);
                    this.add(geometryInfoOid, (IdEObject)geometryInfo);
                    Vector3f minBounds = GeometryFactory.eINSTANCE.createVector3f();
                    minBounds.setX((double)dataInputStream.readFloat());
                    minBounds.setY((double)dataInputStream.readFloat());
                    minBounds.setZ((double)dataInputStream.readFloat());
                    Vector3f maxBounds = GeometryFactory.eINSTANCE.createVector3f();
                    maxBounds.setX((double)dataInputStream.readFloat());
                    maxBounds.setY((double)dataInputStream.readFloat());
                    maxBounds.setZ((double)dataInputStream.readFloat());
                    geometryInfo.setMinBounds(minBounds);
                    geometryInfo.setMaxBounds(maxBounds);
                    byte[] transformation = new byte[128];
                    dataInputStream.readFully(transformation);
                    geometryInfo.setTransformation(transformation);
                    long geometryDataOid = dataInputStream.readLong();
                    GeometryData geometryData = (GeometryData)this.get(geometryDataOid);
                    if (geometryData == null) {
                        geometryData = GeometryFactory.eINSTANCE.createGeometryData();
                        this.add(geometryDataOid, (IdEObject)geometryData);
                    }
                    geometryInfo.setData(geometryData);
                    continue;
                }
                if (type == 3) {
                    throw new GeometryException("Parts not supported");
                }
                if (type == 1) {
                    dataInputStream.read(new byte[3]);
                    long geometryDataOid = dataInputStream.readLong();
                    GeometryData geometryData = (GeometryData)this.get(geometryDataOid);
                    if (geometryData == null) {
                        geometryData = GeometryFactory.eINSTANCE.createGeometryData();
                        this.add(geometryDataOid, (IdEObject)geometryData);
                    }
                    int nrIndices = dataInputStream.readInt();
                    byte[] indices = new byte[nrIndices * 4];
                    dataInputStream.read(indices);
                    geometryData.setIndices(indices);
                    int nrVertices = dataInputStream.readInt();
                    byte[] vertices = new byte[nrVertices * 4];
                    dataInputStream.read(vertices);
                    geometryData.setVertices(vertices);
                    int nrNormals = dataInputStream.readInt();
                    byte[] normals = new byte[nrNormals * 4];
                    dataInputStream.read(normals);
                    geometryData.setNormals(normals);
                    int nrMaterials = dataInputStream.readInt();
                    byte[] materials = new byte[nrMaterials * 4];
                    dataInputStream.read(materials);
                    geometryData.setNormals(materials);
                    continue;
                }
                if (type != 6) continue;
                done = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDownload(Long download) throws BimServerClientException, UserException, ServerException, PublicInterfaceNotFoundException, IfcModelInterfaceException, IOException {
        try (InputStream downloadData = this.bimServerClient.getDownloadData(download, this.getJsonSerializerOid());){
            new SharedJsonDeserializer(true).read(downloadData, (IfcModelInterface)this);
        }
    }

    public <T extends IdEObject> List<T> getAll(EClass eClass) {
        if (!this.loadedClasses.contains(eClass.getName()) && this.modelState != ModelState.FULLY_LOADED) {
            LOGGER.info("Loading all " + eClass.getName());
            try {
                this.modelState = ModelState.LOADING;
                Long downloadByTypes = this.bimServerClient.getBimsie1ServiceInterface().downloadByTypes(Collections.singleton(this.roid), "ifc2x3tc1", Collections.singleton(eClass.getName()), Long.valueOf(this.getJsonSerializerOid()), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
                this.processDownload(downloadByTypes);
                this.loadedClasses.add(eClass.getName());
                this.rebuildIndexPerClass(eClass);
                this.modelState = ModelState.NONE;
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return super.getAll(eClass);
    }

    public Set<String> getGuids(EClass eClass) {
        this.getAllWithSubTypes(eClass);
        return super.getGuids(eClass);
    }

    public Set<String> getNames(EClass eClass) {
        this.getAllWithSubTypes(eClass);
        return super.getNames(eClass);
    }

    public IdEObject getByName(EClass eClass, String name) {
        return super.getByName(eClass, name);
    }

    public long size() {
        try {
            this.loadDeep();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return super.size();
    }

    public Set<Long> keySet() {
        try {
            this.loadDeep();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return super.keySet();
    }

    public IdEObject get(long oid) {
        IdEObject idEObject = super.get(oid);
        if (idEObject == null) {
            this.loadExplicit(oid);
            return super.get(oid);
        }
        return idEObject;
    }

    public void loadExplicit(long oid) {
        try {
            IdEObjectImpl idEObjectImpl = (IdEObjectImpl)super.get(oid);
            if (idEObjectImpl != null && !idEObjectImpl.isLoadedOrLoading()) {
                idEObjectImpl.setLoadingState(IdEObjectImpl.State.LOADING);
                this.modelState = ModelState.LOADING;
                Long downloadByOids = this.bimServerClient.getBimsie1ServiceInterface().downloadByOids(Collections.singleton(this.roid), Collections.singleton(oid), Long.valueOf(this.getJsonSerializerOid()), Boolean.valueOf(true), Boolean.valueOf(false));
                this.processDownload(downloadByOids);
                idEObjectImpl.setLoadingState(IdEObjectImpl.State.LOADED);
                this.modelState = ModelState.NONE;
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public IdEObject getNoFetch(long oid) {
        return super.get(oid);
    }

    public Collection<IdEObject> getValues() {
        try {
            this.loadDeep();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return super.getValues();
    }

    public <T extends IdEObject> List<T> getAllWithSubTypes(EClass eClass) {
        if (!this.loadedClasses.contains(eClass.getName()) && this.modelState != ModelState.FULLY_LOADED) {
            try {
                this.modelState = ModelState.LOADING;
                Long downloadByTypes = this.bimServerClient.getBimsie1ServiceInterface().downloadByTypes(Collections.singleton(this.roid), "ifc2x3tc1", Collections.singleton(eClass.getName()), Long.valueOf(this.getJsonSerializerOid()), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
                this.processDownload(downloadByTypes);
                for (EClass subClass : this.bimServerClient.getMetaDataManager().getPackageMetaData(eClass.getEPackage().getName()).getAllSubClasses(eClass)) {
                    this.loadedClasses.add(subClass.getName());
                    this.rebuildIndexPerClass(eClass);
                }
                this.loadedClasses.add(eClass.getName());
                this.modelState = ModelState.NONE;
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return super.getAllWithSubTypes(eClass);
    }

    public Long getTransactionId() {
        return this.tid;
    }

    public ModelState getModelState() {
        return this.modelState;
    }

    public boolean contains(long oid) {
        this.get(oid);
        return super.contains(oid);
    }

    public boolean containsNoFetch(long oid) {
        return super.contains(oid);
    }

    public boolean containsGuid(String guid) {
        this.getByGuid(guid);
        return super.containsGuid(guid);
    }

    public int count(EClass eClass) {
        return super.count(eClass);
    }

    public IfcRoot getByGuid(String guid) {
        IfcRoot idEObject = super.getByGuid(guid);
        if (idEObject == null) {
            try {
                this.modelState = ModelState.LOADING;
                Long downloadByGuids = this.bimServerClient.getBimsie1ServiceInterface().downloadByGuids(Collections.singleton(this.roid), Collections.singleton(guid), Long.valueOf(this.getJsonSerializerOid()), Boolean.valueOf(false), Boolean.valueOf(false));
                this.processDownload(downloadByGuids);
                this.modelState = ModelState.NONE;
                return super.getByGuid(guid);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return idEObject;
    }

    public <T extends IdEObject> T create(Class<T> clazz) throws IfcModelInterfaceException {
        return this.create((EClass)Ifc2x3tc1Package.eINSTANCE.getEClassifier(clazz.getSimpleName()));
    }

    public <T extends IdEObject> T create(EClass eClass, long oid) throws IfcModelInterfaceException {
        IdEObjectImpl object = (IdEObjectImpl)super.create(eClass, oid);
        if (this.recordChanges) {
            object.eAdapters().add((Object)this.adapter);
        }
        return (T)object;
    }

    public <T extends IdEObject> T create(EClass eClass) throws IfcModelInterfaceException {
        IdEObjectImpl idEObject = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        idEObject.setModel((IfcModelInterface)this);
        if (this.recordChanges) {
            idEObject.eAdapters().add((Object)this.adapter);
            try {
                Long oid = this.bimServerClient.getBimsie1LowLevelInterface().createObject(Long.valueOf(this.tid), eClass.getName(), Boolean.valueOf(true));
                idEObject.setOid(oid.longValue());
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            this.add(idEObject.getOid(), (IdEObject)idEObject);
        }
        return (T)idEObject;
    }

    public void set(IdEObject idEObject, EStructuralFeature eFeature, Object newValue) {
        block39: {
            if (!this.recordChanges) {
                return;
            }
            if (!eFeature.isMany() && this.getModelState() != ModelState.LOADING) {
                try {
                    if (newValue == EStructuralFeature.Internal.DynamicValueHolder.NIL) break block39;
                    Bimsie1LowLevelInterface lowLevelInterface = this.getBimServerClient().getBimsie1LowLevelInterface();
                    if (eFeature.getName().equals("wrappedValue")) {
                        EReference foundReference = null;
                        if (this.contains(idEObject.getOid())) {
                            IdEObject parentObject = this.get(idEObject.getOid());
                            int found = 0;
                            foundReference = null;
                            for (EReference testReference : parentObject.eClass().getEAllReferences()) {
                                if (!((EClass)testReference.getEType()).isSuperTypeOf(idEObject.eClass())) continue;
                                foundReference = testReference;
                                if (++found <= 1) continue;
                                throw new RuntimeException("Sorry, crazy hack could not resolve the right field, please let BIMserver developer know (debug info: " + parentObject.eClass().getName() + ", " + idEObject.eClass().getName() + ")");
                            }
                            if (eFeature.getEType() == EcorePackage.eINSTANCE.getEString()) {
                                lowLevelInterface.setWrappedStringAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), foundReference.getName(), idEObject.eClass().getName(), (String)newValue);
                            } else if (eFeature.getEType() == EcorePackage.eINSTANCE.getELong() || eFeature.getEType() == EcorePackage.eINSTANCE.getELongObject()) {
                                lowLevelInterface.setWrappedLongAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), foundReference.getName(), idEObject.eClass().getName(), (Long)newValue);
                            } else if (eFeature.getEType() == EcorePackage.eINSTANCE.getEDouble() || eFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject()) {
                                lowLevelInterface.setWrappedDoubleAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), foundReference.getName(), idEObject.eClass().getName(), (Double)newValue);
                            } else if (eFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean() || eFeature.getEType() == EcorePackage.eINSTANCE.getEBooleanObject()) {
                                lowLevelInterface.setWrappedBooleanAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), foundReference.getName(), idEObject.eClass().getName(), (Boolean)newValue);
                            } else if (eFeature.getEType() == EcorePackage.eINSTANCE.getEInt() || eFeature.getEType() == EcorePackage.eINSTANCE.getEIntegerObject()) {
                                lowLevelInterface.setWrappedIntegerAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), foundReference.getName(), idEObject.eClass().getName(), (Integer)newValue);
                            } else if (eFeature.getEType() == EcorePackage.eINSTANCE.getEByteArray()) {
                                throw new RuntimeException("Unimplemented " + eFeature.getEType().getName() + " " + newValue);
                            }
                            break block39;
                        }
                        if (eFeature.getEType() == EcorePackage.eINSTANCE.getEString()) {
                            lowLevelInterface.setStringAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (String)newValue);
                            break block39;
                        }
                        if (eFeature.getEType() == EcorePackage.eINSTANCE.getELong() || eFeature.getEType() == EcorePackage.eINSTANCE.getELongObject()) {
                            lowLevelInterface.setLongAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Long)newValue);
                            break block39;
                        }
                        if (eFeature.getEType() == EcorePackage.eINSTANCE.getEDouble() || eFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject()) {
                            lowLevelInterface.setDoubleAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Double)newValue);
                            break block39;
                        }
                        if (eFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean() || eFeature.getEType() == EcorePackage.eINSTANCE.getEBooleanObject()) {
                            lowLevelInterface.setBooleanAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Boolean)newValue);
                            break block39;
                        }
                        if (eFeature.getEType() == EcorePackage.eINSTANCE.getEInt() || eFeature.getEType() == EcorePackage.eINSTANCE.getEIntegerObject()) {
                            lowLevelInterface.setIntegerAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Integer)newValue);
                            break block39;
                        }
                        if (eFeature.getEType() == EcorePackage.eINSTANCE.getEByteArray()) {
                            lowLevelInterface.setByteArrayAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Byte[])newValue);
                            break block39;
                        }
                        if (eFeature.getEType() instanceof EEnum) {
                            lowLevelInterface.setEnumAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), ((Enum)newValue).toString());
                            break block39;
                        }
                        if (eFeature instanceof EReference) {
                            if (newValue == null) {
                                lowLevelInterface.setReference(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), Long.valueOf(-1L));
                            } else {
                                lowLevelInterface.setReference(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), Long.valueOf(((IdEObject)newValue).getOid()));
                            }
                            break block39;
                        }
                        throw new RuntimeException("Unimplemented " + eFeature.getEType().getName() + " " + newValue);
                    }
                    if (eFeature.getEType() == EcorePackage.eINSTANCE.getEString()) {
                        lowLevelInterface.setStringAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (String)newValue);
                        break block39;
                    }
                    if (eFeature.getEType() == EcorePackage.eINSTANCE.getELong() || eFeature.getEType() == EcorePackage.eINSTANCE.getELongObject()) {
                        lowLevelInterface.setLongAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Long)newValue);
                        break block39;
                    }
                    if (eFeature.getEType() == EcorePackage.eINSTANCE.getEDouble() || eFeature.getEType() == EcorePackage.eINSTANCE.getEDoubleObject()) {
                        lowLevelInterface.setDoubleAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Double)newValue);
                        break block39;
                    }
                    if (eFeature.getEType() == EcorePackage.eINSTANCE.getEBoolean() || eFeature.getEType() == EcorePackage.eINSTANCE.getEBooleanObject()) {
                        lowLevelInterface.setBooleanAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Boolean)newValue);
                        break block39;
                    }
                    if (eFeature.getEType() == EcorePackage.eINSTANCE.getEInt() || eFeature.getEType() == EcorePackage.eINSTANCE.getEIntegerObject()) {
                        lowLevelInterface.setIntegerAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Integer)newValue);
                        break block39;
                    }
                    if (eFeature.getEType() == EcorePackage.eINSTANCE.getEByteArray()) {
                        lowLevelInterface.setByteArrayAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), (Byte[])newValue);
                        break block39;
                    }
                    if (eFeature.getEType() instanceof EEnum) {
                        lowLevelInterface.setEnumAttribute(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), ((Enum)newValue).toString());
                        break block39;
                    }
                    if (eFeature instanceof EReference) {
                        if (newValue == null) {
                            lowLevelInterface.setReference(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), Long.valueOf(-1L));
                        } else {
                            lowLevelInterface.setReference(this.getTransactionId(), Long.valueOf(idEObject.getOid()), eFeature.getName(), Long.valueOf(((IdEObject)newValue).getOid()));
                        }
                        break block39;
                    }
                    throw new RuntimeException("Unimplemented " + eFeature.getEType().getName() + " " + newValue);
                }
                catch (ServiceException e) {
                    LOGGER.error("", (Throwable)e);
                }
                catch (PublicInterfaceNotFoundException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
    }

    public void checkin(long poid, String comment) throws ServerException, UserException, PublicInterfaceNotFoundException {
        this.fixOids(new OidProvider(){
            private long c = 1L;

            public long newOid(EClass eClass) {
                return this.c++;
            }
        });
        SharedJsonSerializer sharedJsonSerializer = new SharedJsonSerializer((IfcModelInterface)this, false);
        SDeserializerPluginConfiguration deserializer = this.bimServerClient.getBimsie1ServiceInterface().getSuggestedDeserializerForExtension("json", Long.valueOf(poid));
        this.bimServerClient.checkin(poid, comment, deserializer.getOid(), false, true, -1L, "test", (InputStream)new SerializerInputstream((StreamingReader)sharedJsonSerializer));
    }

    public void load(IdEObject object) {
        this.loadExplicit(object.getOid());
    }

    public void remove(IdEObject object) {
        try {
            this.bimServerClient.getBimsie1LowLevelInterface().removeObject(this.getTransactionId(), Long.valueOf(object.getOid()));
        }
        catch (PublicInterfaceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ServerException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UserException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void query(ObjectNode query) {
        try {
            this.modelState = ModelState.LOADING;
            Long downloadByTypes = this.bimServerClient.getBimsie1ServiceInterface().downloadByJsonQuery(Collections.singleton(this.roid), query.toString(), Long.valueOf(this.getJsonSerializerOid()), Boolean.valueOf(true));
            this.processDownload(downloadByTypes);
            this.modelState = ModelState.NONE;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public static enum ModelState {
        NONE,
        LOADING,
        FULLY_LOADED;

    }
}

