/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.http.impl.client.CloseableHttpClient;
import org.bimserver.client.Channel;
import org.bimserver.interfaces.objects.SDownloadResult;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.ServiceFactory;
import org.bimserver.shared.TokenChangeListener;
import org.bimserver.shared.TokenHolder;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1ServiceInterface;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.utils.InputStreamDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectChannel
extends Channel
implements TokenChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectChannel.class);
    private ServiceFactory serviceFactory;
    private SServicesMap sServicesMap;

    public DirectChannel(CloseableHttpClient httpClient, ServiceFactory serviceFactory, SServicesMap sServicesMap) {
        super(httpClient);
        this.serviceFactory = serviceFactory;
        this.sServicesMap = sServicesMap;
    }

    public void connect() throws UserException {
        for (Class interface1 : this.sServicesMap.getInterfaceClasses()) {
            if (this.has(interface1)) continue;
            try {
                this.add(interface1.getName(), this.serviceFactory.get(AccessMethod.INTERNAL).get(interface1));
            }
            catch (UserException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        this.notifyOfConnect();
    }

    @Override
    public void disconnect() {
        this.notifyOfDisconnect();
    }

    @Override
    public long checkin(String baseAddress, String token, long poid, String comment, long deserializerOid, boolean merge, boolean sync, long fileSize, String filename, InputStream inputStream) throws ServerException, UserException {
        try {
            return this.get(ServiceInterface.class).checkin(Long.valueOf(poid), comment, Long.valueOf(deserializerOid), Long.valueOf(fileSize), filename, new DataHandler((DataSource)new InputStreamDataSource(inputStream)), Boolean.valueOf(merge), Boolean.valueOf(sync));
        }
        catch (PublicInterfaceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public InputStream getDownloadData(String baseAddress, String token, long download, long serializerOid) throws IOException {
        try {
            SDownloadResult downloadData = this.get(Bimsie1ServiceInterface.class).getDownloadData(Long.valueOf(download));
            return downloadData.getFile().getInputStream();
        }
        catch (ServerException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (UserException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (PublicInterfaceNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    @Override
    public void connect(TokenHolder tokenHolder) throws ChannelConnectionException {
        tokenHolder.registerTokenChangeListener((TokenChangeListener)this);
    }

    public void newToken(String token) {
        for (Class interface1 : this.sServicesMap.getInterfaceClasses()) {
            try {
                this.add(interface1.getName(), this.serviceFactory.get(token, AccessMethod.INTERNAL).get(interface1));
            }
            catch (UserException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }
}

