/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.soap;

import org.bimserver.client.AbstractBimServerClientFactory;
import org.bimserver.client.BimServerClient;
import org.bimserver.client.soap.SoapChannel;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.meta.SServicesMap;

public class SoapBimServerClientFactory
extends AbstractBimServerClientFactory {
    private String address;

    public SoapBimServerClientFactory(String address, SServicesMap servicesMap, MetaDataManager metaDataManager) {
        super(servicesMap, metaDataManager);
        this.address = address;
    }

    public SoapBimServerClientFactory(MetaDataManager metaDataManager, String address) {
        super(metaDataManager);
        this.address = address;
    }

    public BimServerClient create(AuthenticationInfo authenticationInfo) throws ServiceException, ChannelConnectionException {
        SoapChannel soapChannel = new SoapChannel(this.getHttpClient(), this.address + "/soap11", true, this.getServicesMap().getInterfaceClasses());
        BimServerClient bimServerClient = new BimServerClient(this.getMetaDataManager(), this.address, this.getServicesMap(), soapChannel);
        soapChannel.connect(bimServerClient);
        bimServerClient.setAuthentication(authenticationInfo);
        bimServerClient.connect();
        return bimServerClient;
    }
}

