/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client;

import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.interfaces.SServiceInterfaceService;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.reflector.ReflectorFactoryImpl1;
import org.bimserver.shared.BimServerClientFactory;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.AuthInterface;
import org.bimserver.shared.interfaces.MetaInterface;
import org.bimserver.shared.interfaces.PluginInterface;
import org.bimserver.shared.interfaces.ServiceInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1AuthInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1LowLevelInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1NotificationInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1NotificationRegistryInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1RemoteServiceInterface;
import org.bimserver.shared.interfaces.bimsie1.Bimsie1ServiceInterface;
import org.bimserver.shared.meta.SService;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.reflector.ReflectorFactory;

public abstract class AbstractBimServerClientFactory
implements BimServerClientFactory {
    private final SServicesMap servicesMap;
    private final MetaDataManager metaDataManager;
    private CloseableHttpClient httpClient;

    public AbstractBimServerClientFactory(SServicesMap servicesMap, MetaDataManager metaDataManager) {
        this.servicesMap = servicesMap;
        if (metaDataManager == null) {
            throw new IllegalArgumentException("MetaDataManager cannot be null");
        }
        this.metaDataManager = metaDataManager;
        this.initHttpClient();
    }

    public AbstractBimServerClientFactory(MetaDataManager metaDataManager) {
        if (metaDataManager == null) {
            throw new IllegalArgumentException("MetaDataManager cannot be null");
        }
        this.metaDataManager = metaDataManager;
        this.servicesMap = new SServicesMap();
        this.servicesMap.setReflectorFactory((ReflectorFactory)new ReflectorFactoryImpl1());
        SServiceInterfaceService serviceInterface = new SServiceInterfaceService(this.servicesMap, null, ServiceInterface.class);
        this.addService((SService)serviceInterface);
        this.addService(new SService(this.servicesMap, null, MetaInterface.class));
        this.addService(new SService(this.servicesMap, null, AdminInterface.class));
        this.addService(new SService(this.servicesMap, null, AuthInterface.class));
        this.addService(new SService(this.servicesMap, null, SettingsInterface.class));
        this.addService(new SService(this.servicesMap, null, PluginInterface.class));
        this.addService(new SService(this.servicesMap, null, Bimsie1NotificationInterface.class));
        this.addService(new SService(this.servicesMap, null, Bimsie1RemoteServiceInterface.class));
        this.addService(new SService(this.servicesMap, null, Bimsie1AuthInterface.class));
        this.addService(new SService(this.servicesMap, null, Bimsie1LowLevelInterface.class));
        this.addService(new SService(this.servicesMap, null, Bimsie1NotificationRegistryInterface.class));
        this.addService(new SService(this.servicesMap, null, Bimsie1ServiceInterface.class));
        this.servicesMap.initialize();
        this.initHttpClient();
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void initHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        builder.setConnectionManager((HttpClientConnectionManager)connManager);
        this.httpClient = builder.build();
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public BimServerClientInterface create() throws ServiceException, ChannelConnectionException {
        return this.create(null);
    }

    public void addService(SService sService) {
        this.servicesMap.add(sService);
    }

    public SServicesMap getServicesMap() {
        return this.servicesMap;
    }
}

