/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.protocolbuffers;

import org.bimserver.client.AbstractBimServerClientFactory;
import org.bimserver.client.BimServerClient;
import org.bimserver.client.protocolbuffers.ProtocolBuffersChannel;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.exceptions.BimServerClientException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.shared.reflector.FileBasedReflectorFactoryBuilder;
import org.bimserver.shared.reflector.ReflectorFactory;

public class ProtocolBuffersBimServerClientFactory
extends AbstractBimServerClientFactory {
    private final String address;
    private final int port;
    private final int httpPort;
    private final ReflectorFactory reflectorFactory;
    private ProtocolBuffersMetaData protocolBuffersMetaData;

    public ProtocolBuffersBimServerClientFactory(String address, int port, int httpPort, ProtocolBuffersMetaData protocolBuffersMetaData, MetaDataManager metaDataManager) throws BimServerClientException {
        super(metaDataManager);
        this.httpPort = httpPort;
        this.address = address;
        this.port = port;
        this.protocolBuffersMetaData = protocolBuffersMetaData;
        FileBasedReflectorFactoryBuilder factoryBuilder = new FileBasedReflectorFactoryBuilder();
        this.reflectorFactory = factoryBuilder.newReflectorFactory();
    }

    public BimServerClient create(AuthenticationInfo authenticationInfo) throws ServiceException, ChannelConnectionException {
        ProtocolBuffersChannel channel = new ProtocolBuffersChannel(this.getHttpClient(), this.getServicesMap(), this.protocolBuffersMetaData, this.reflectorFactory, this.address, this.port);
        BimServerClient bimServerClient = new BimServerClient(this.getMetaDataManager(), "http://" + this.address + ":" + this.httpPort, this.getServicesMap(), channel);
        bimServerClient.setAuthentication(authenticationInfo);
        bimServerClient.connect();
        return bimServerClient;
    }
}

